/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.outputvalcount.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.outputvalcount.bean.MonthlyStatisticsEntity;
import com.ejianc.business.outputvalcount.mapper.MonthlyStatisticsMapper;
import com.ejianc.business.outputvalcount.service.IXmjdmxService;
import com.ejianc.business.outputvalcount.service.IXmyxglService;
import com.ejianc.business.outputvalcount.utils.SpecialityIdEnum;
import com.ejianc.business.outputvalcount.vo.OutputApiVO;
import com.ejianc.business.outputvalcount.vo.OutputValDTO;
import com.ejianc.business.outputvalcount.vo.OutputValueVO;
import com.ejianc.business.outputvalcount.vo.OutputvalTargetVO;
import com.ejianc.business.outputvalcount.vo.ProjectDetailDTO;
import com.ejianc.business.outputvalcount.vo.XmyxglVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/outputValue/"})
public class OutputValueApi {
    @Autowired
    private MonthlyStatisticsMapper mapper;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IXmyxglService service;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IXmjdmxService xmjdmxService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @RequestMapping(value={"getSumByProjectId"}, method={RequestMethod.GET})
    CommonResponse<OutputValueVO> getSumByProjectId(@RequestParam(value="projectId") Long projectId) {
        String name = "";
        List<MonthlyStatisticsEntity> monthlyStatistics = this.mapper.getMonthlyStatistics(projectId);
        BigDecimal sum = new BigDecimal(0);
        for (MonthlyStatisticsEntity entity : monthlyStatistics) {
            name = entity.getProjectName();
            if (entity.getBillState() != 1 && entity.getBillState() != 3) continue;
            sum = sum.add(entity.getBywccz());
        }
        OutputValueVO outputValueVO = new OutputValueVO();
        outputValueVO.setProjectName(name);
        outputValueVO.setProjectId(projectId);
        outputValueVO.setSum(sum);
        return CommonResponse.success((String)"\u83b7\u53d6\u6570\u636e\u6210\u529f\uff01", (Object)outputValueVO);
    }

    @RequestMapping(value={"getInfoByProjectId"}, method={RequestMethod.GET})
    CommonResponse<List<XmyxglVO>> getInfoByProjectId(@RequestParam(value="projectId") Long projectId, @RequestParam(value="num") Integer num) {
        List respData = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(projectId), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList departmentIds = new ArrayList();
        respData.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            }
        });
        QueryParam queryParam = new QueryParam();
        queryParam.getOrderMap().put("createTime", "desc");
        queryParam.setPageSize(num.intValue());
        queryParam.setPageIndex(1);
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        ArrayList<Integer> billStates = new ArrayList<Integer>();
        billStates.add(1);
        billStates.add(3);
        queryParam.getParams().put("billState", new Parameter("in", billStates));
        queryParam.getParams().put("syxs", new Parameter("eq", (Object)2));
        IPage xmyxglEntityIPage = this.service.queryPage(queryParam, false);
        List xmyxglVOS = BeanMapper.mapList((Iterable)xmyxglEntityIPage.getRecords(), XmyxglVO.class);
        for (XmyxglVO vo : xmyxglVOS) {
            List data;
            CommonResponse listCommonResponse = this.attachmentApi.queryListBySourceId(vo.getId(), "ZZYJ202205050002", "add", "");
            if (listCommonResponse.getCode() != 0 || (data = (List)listCommonResponse.getData()).size() <= 0) continue;
            String truePath = ((AttachmentVO)data.get(0)).getTruePath();
            int i = truePath.lastIndexOf(".");
            String substring = truePath.substring(0, i) + "_500x500" + truePath.substring(i);
            vo.setTruePath(substring);
        }
        return CommonResponse.success((String)"\u83b7\u53d6\u6570\u636e\u6210\u529f\uff01", (Object)xmyxglVOS);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"getSumByOrgId"}, method={RequestMethod.GET})
    CommonResponse<OutputValueVO> getSumByOrgId(@RequestParam(value="orgId") Long orgId) {
        List<MonthlyStatisticsEntity> monthlyStatistics = this.mapper.getMonthlyStatisticsByDeptId(orgId);
        BigDecimal sum = new BigDecimal(0);
        for (MonthlyStatisticsEntity entity : monthlyStatistics) {
            if (entity.getBillState() != 1 && entity.getBillState() != 3) continue;
            sum = sum.add(entity.getBywccz());
        }
        OutputValueVO outputValueVO = new OutputValueVO();
        CommonResponse oneById = this.iOrgApi.getOneById(orgId);
        if (oneById.getCode() == 0) {
            OrgVO data = (OrgVO)oneById.getData();
            outputValueVO.setProjectName(data.getName());
        }
        this.logger.info("\u67e5\u8be2\u4ea7\u503c\u7684\u7ec4\u7ec7id\uff1a{}", (Object)orgId);
        if (orgId == 1502571152583692289L) {
            sum = sum.add(this.getG9Money(null));
        }
        outputValueVO.setProjectId(orgId);
        outputValueVO.setSum(sum);
        return CommonResponse.success((String)"\u83b7\u53d6\u6570\u636e\u6210\u529f\uff01", (Object)outputValueVO);
    }

    @RequestMapping(value={"getSumByOrgIdUnder"}, method={RequestMethod.GET})
    CommonResponse<BigDecimal> getSumByOrgIdUnder(@RequestParam(value="orgId") Long orgId, @RequestParam(value="year") Integer year) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        param.getParams().put("projectDepartmentId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.getParams().put("projectId", new Parameter("ne", (Object)643021352342790201L));
        if (!year.equals(0)) {
            param.getParams().put("statDate", new Parameter("between", (Object)(year + "-1-1," + year + "-12-31")));
        }
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<MonthlyStatisticsEntity> monthlyStatistics = this.mapper.getSumByOrgIdUnder(wrapper);
        BigDecimal sum = new BigDecimal(0);
        for (MonthlyStatisticsEntity entity : monthlyStatistics) {
            if (entity.getBillState() != 1 && entity.getBillState() != 3) continue;
            sum = sum.add(entity.getBywccz());
        }
        this.logger.info("\u67e5\u8be2\u4ea7\u503c\u7684\u7ec4\u7ec7id\uff1a{}", (Object)orgId);
        if (orgId == 1502571152583692289L) {
            sum = sum.add(this.getG9Money(year));
        }
        return CommonResponse.success((String)"\u83b7\u53d6\u6570\u636e\u6210\u529f\uff01", (Object)sum);
    }

    @RequestMapping(value={"getSumByOrgIds"}, method={RequestMethod.POST})
    CommonResponse<HashMap<Long, BigDecimal>> getSumByOrgIds(@RequestBody OutputValDTO dto) {
        if (dto.getOrgIds() == null) {
            return CommonResponse.error((String)"\u9879\u76eeid\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        if (dto.getYear() != null && !dto.getYear().equals(0)) {
            param.getParams().put("statDate", new Parameter("between", (Object)(dto.getYear() + "-1-1," + dto.getYear() + "-12-31")));
        }
        HashMap<Long, BigDecimal> hashMap = new HashMap<Long, BigDecimal>();
        for (Long orgId : dto.getOrgIds()) {
            param.getParams().put("projectDepartmentId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
            List<MonthlyStatisticsEntity> monthlyStatistics = this.mapper.getSumByOrgIdUnder(wrapper);
            BigDecimal sum = new BigDecimal(0);
            for (MonthlyStatisticsEntity entity : monthlyStatistics) {
                if (entity.getBillState() != 1 && entity.getBillState() != 3) continue;
                sum = sum.add(entity.getBywccz());
            }
            hashMap.put(orgId, sum);
        }
        return CommonResponse.success((String)"\u83b7\u53d6\u6570\u636e\u6210\u529f\uff01", hashMap);
    }

    @RequestMapping(value={"getOutputValue"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<ProjectDetailDTO>> getOutputValue(HttpServletRequest request) {
        String syncMode = request.getParameter("syncMode");
        String syncTime = null;
        if ("increment".equals(syncMode)) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            Calendar calendar = Calendar.getInstance();
            calendar.add(5, -1);
            syncTime = dateFormat.format(calendar.getTime()) + " 00:00:00";
            this.logger.info("syncTime\u4e3a\uff1a--{}", (Object)syncTime);
        }
        List<ProjectDetailDTO> supplierBankList = this.xmjdmxService.queryOutputValueBySyncTime(syncTime);
        return CommonResponse.success(supplierBankList);
    }

    public BigDecimal getG9Money(Integer year1) {
        try {
            Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
            this.logger.info("\u8fde\u63a5\u6210\u529f1");
        }
        catch (Exception e) {
            this.logger.info("\u8fde\u63a5\u5931\u8d251");
        }
        String connectionUrl = "jdbc:sqlserver://172.16.1.242:1433;databaseName=master;user=sa;password=Zzyj2015;";
        Statement stmt = null;
        ResultSet rs = null;
        BigDecimal bigDecimal = new BigDecimal("0.00");
        try {
            Connection con = DriverManager.getConnection(connectionUrl);
            this.logger.info("\u8fde\u63a5\u6210\u529f2");
            Calendar date = Calendar.getInstance();
            String year = String.valueOf(date.get(1));
            if (year1 != null) {
                year = year1 + "";
            }
            String SQL = "SELECT SUM(F_JE) as je FROM [gtp-default].[dbo].[PG7ZZ_XMGLZFGSYY_ZFGSCZTJ]\nwhere F_TJNF =" + year + "\nand F_STATE = 3\nand F_DEPT_ID not in (22754)\nGROUP BY F_TJNF ";
            stmt = con.createStatement();
            rs = stmt.executeQuery(SQL);
            while (rs.next()) {
                bigDecimal = rs.getBigDecimal("je");
            }
            con.close();
        }
        catch (SQLException e) {
            this.logger.info("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u8868\u540d" + e + ".\u8fde\u63a5\u5931\u8d252");
        }
        return bigDecimal;
    }

    @RequestMapping(value={"outputvalYearTarget"}, method={RequestMethod.GET})
    CommonResponse<OutputvalTargetVO> outputvalYearTarget(@RequestParam(value="orgId") Long orgId, @RequestParam(value="dateIn") Integer dateIn) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        param.getParams().put("projectId", new Parameter("ne", (Object)643021352342790201L));
        param.getParams().put("statDate", new Parameter("between", (Object)(dateIn + "-1-1," + dateIn + "-12-31")));
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<MonthlyStatisticsEntity> monthlyStatistics = this.mapper.getSumByOrgIdUnder(wrapper);
        BigDecimal sum = new BigDecimal(0);
        for (MonthlyStatisticsEntity entity : monthlyStatistics) {
            if (entity.getBillState() != 1 && entity.getBillState() != 3) continue;
            sum = sum.add(entity.getBywccz());
        }
        this.logger.info("\u67e5\u8be2\u4ea7\u503c\u7684\u7ec4\u7ec7id\uff1a{}", (Object)orgId);
        sum = sum.add(this.getG9Money(dateIn));
        OutputvalTargetVO outputvalTargetVO = this.mapper.queryOutputvalYearTarget(dateIn + "");
        outputvalTargetVO.setOutputvalMny(sum);
        outputvalTargetVO.setPercentComplete(outputvalTargetVO.getOutputvalMny().divide(outputvalTargetVO.getTargetMny(), 2, 1).multiply(new BigDecimal(100)));
        return CommonResponse.success((String)"\u83b7\u53d6\u6570\u636e\u6210\u529f\uff01", (Object)outputvalTargetVO);
    }

    @RequestMapping(value={"/outputvalCostMonth"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<String>> outputvalCostMonth(@RequestParam(value="orgId", required=true) Long orgId, @RequestParam(value="dateIn", required=true) Integer dateIn) {
        List respData = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(orgId), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList<Long> orgIds = new ArrayList<Long>();
        respData.stream().forEach(org -> orgIds.add(org.getId()));
        List<String> bigDecimals = this.mapper.queryOutputvalCostMonth(dateIn + "", orgIds);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", bigDecimals);
    }

    @RequestMapping(value={"/queryMajorProjectIds"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<XmyxglVO>> queryMajorProjectIds(@RequestParam(value="orgId", required=true) Long orgId, @RequestParam(value="dateIn", required=true) Integer dateIn) {
        List respData = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(orgId), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList<Long> orgIds = new ArrayList<Long>();
        respData.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                orgIds.add(org.getId());
            }
        });
        List<XmyxglVO> xmyxglVOS = this.mapper.queryMajorProjectIds(orgIds);
        List collect = xmyxglVOS.stream().map(BaseVO::getId).collect(Collectors.toList());
        if (collect != null && collect.size() > 0) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("sourceIds", collect);
            jsonObject.put("orderType", (Object)"desc");
            CommonResponse listCommonResponse = this.attachmentApi.queryAllBySourceIdList(jsonObject);
            if (listCommonResponse.getCode() == 0) {
                List data = (List)listCommonResponse.getData();
                for (AttachmentVO datum : data) {
                    for (XmyxglVO vo : xmyxglVOS) {
                        if (!datum.getSourceId().equals(vo.getId())) continue;
                        int i = datum.getTruePath().lastIndexOf(".");
                        String substring = datum.getTruePath().substring(0, i) + "_500x500" + datum.getTruePath().substring(i);
                        vo.setTruePath(substring);
                    }
                }
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", xmyxglVOS);
    }

    @RequestMapping(value={"/getUndertakeInfo"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<OutputApiVO>> getUndertakeInfo(@RequestParam(value="orgId", required=true) Long orgId, Integer time, Integer dateIn) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        List respData = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(orgId), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList departmentIds = new ArrayList();
        respData.stream().forEach(org -> {
            if (3 == org.getOrgType() || 2 == org.getOrgType()) {
                departmentIds.add(org.getId());
            }
        });
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate nowDate = LocalDate.now();
        if (time != null) {
            if (time.equals(1)) {
                param.getParams().put("stat_date", new Parameter("between", (Object)(OutputValueApi.getMonthStartTime(dateTimeFormatter) + "," + OutputValueApi.getMonthEndTime(dateTimeFormatter))));
            } else if (time.equals(2)) {
                param.getParams().put("stat_date", new Parameter("between", (Object)(OutputValueApi.getFromThisQuarterStartTime(nowDate, dateTimeFormatter) + "," + OutputValueApi.getFromThisQuarterEndTime(nowDate, dateTimeFormatter))));
            } else {
                param.getParams().put("stat_date", new Parameter("between", (Object)(OutputValueApi.getFromThisYearStartTime(nowDate, dateTimeFormatter) + "," + OutputValueApi.getFromThisYearEndTime(nowDate, dateTimeFormatter))));
            }
        } else if (dateIn != null) {
            param.getParams().put("stat_date", new Parameter("between", (Object)(dateIn + "-01-01," + dateIn + "-12-31")));
        }
        param.getParams().put("billState", new Parameter("in", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode())));
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.groupBy(new Object[]{"lb_id"});
        List<OutputApiVO> undertakeVOS = this.mapper.queryUndertakeInfoList(wrapper);
        ArrayList<OutputApiVO> undertakeApiVOS = new ArrayList<OutputApiVO>();
        OutputApiVO vo1 = new OutputApiVO(SpecialityIdEnum.CODE_1.getCode(), SpecialityIdEnum.CODE_1.getName(), new BigDecimal(0.0), Integer.valueOf(0));
        OutputApiVO vo2 = new OutputApiVO(SpecialityIdEnum.CODE_2.getCode(), SpecialityIdEnum.CODE_2.getName(), new BigDecimal(0.0), Integer.valueOf(0));
        OutputApiVO vo3 = new OutputApiVO(SpecialityIdEnum.CODE_3.getCode(), SpecialityIdEnum.CODE_3.getName(), new BigDecimal(0.0), Integer.valueOf(0));
        OutputApiVO vo4 = new OutputApiVO(SpecialityIdEnum.CODE_4.getCode(), SpecialityIdEnum.CODE_4.getName(), new BigDecimal(0.0), Integer.valueOf(0));
        OutputApiVO vo5 = new OutputApiVO(SpecialityIdEnum.CODE_5.getCode(), SpecialityIdEnum.CODE_5.getName(), new BigDecimal(0.0), Integer.valueOf(0));
        OutputApiVO vo6 = new OutputApiVO(SpecialityIdEnum.CODE_6.getCode(), SpecialityIdEnum.CODE_6.getName(), new BigDecimal(0.0), Integer.valueOf(0));
        OutputApiVO vo7 = new OutputApiVO(SpecialityIdEnum.CODE_7.getCode(), SpecialityIdEnum.CODE_7.getName(), new BigDecimal(0.0), Integer.valueOf(0));
        OutputApiVO vo8 = new OutputApiVO(SpecialityIdEnum.CODE_8.getCode(), SpecialityIdEnum.CODE_8.getName(), new BigDecimal(0.0), Integer.valueOf(0));
        OutputApiVO vo9 = new OutputApiVO(SpecialityIdEnum.CODE_9.getCode(), SpecialityIdEnum.CODE_9.getName(), new BigDecimal(0.0), Integer.valueOf(0));
        for (OutputApiVO vo : undertakeVOS) {
            if (vo.getSpeciality().equals(SpecialityIdEnum.CODE_3.getCode())) {
                vo3.setValue(vo.getValue().multiply(new BigDecimal(10000)));
                continue;
            }
            if (vo.getSpeciality().equals(SpecialityIdEnum.CODE_4.getCode())) {
                vo4.setValue(vo.getValue().multiply(new BigDecimal(10000)));
                continue;
            }
            if (vo.getSpeciality().equals(SpecialityIdEnum.CODE_5.getCode())) {
                vo5.setValue(vo.getValue().multiply(new BigDecimal(10000)));
                continue;
            }
            if (vo.getSpeciality().equals(SpecialityIdEnum.CODE_6.getCode())) {
                vo6.setValue(vo.getValue().multiply(new BigDecimal(10000)));
                continue;
            }
            if (vo.getSpeciality().equals(SpecialityIdEnum.CODE_7.getCode())) {
                vo7.setValue(vo.getValue().multiply(new BigDecimal(10000)));
                continue;
            }
            if (vo.getSpeciality().equals(SpecialityIdEnum.CODE_8.getCode())) {
                vo8.setValue(vo.getValue().multiply(new BigDecimal(10000)));
                continue;
            }
            if (vo.getSpeciality().equals(SpecialityIdEnum.CODE_9.getCode())) {
                vo9.setValue(vo.getValue().multiply(new BigDecimal(10000)));
                continue;
            }
            if (vo.getSpeciality().equals(SpecialityIdEnum.CODE_1.getCode()) || vo.getSpeciality().equals(SpecialityIdEnum.CODE_101.getCode()) || vo.getSpeciality().equals(SpecialityIdEnum.CODE_102.getCode()) || vo.getSpeciality().equals(SpecialityIdEnum.CODE_103.getCode())) {
                vo1.setValue(vo1.getValue().add(vo.getValue().multiply(new BigDecimal(10000))));
                continue;
            }
            if (!vo.getSpeciality().equals(SpecialityIdEnum.CODE_2.getCode()) && !vo.getSpeciality().equals(SpecialityIdEnum.CODE_201.getCode()) && !vo.getSpeciality().equals(SpecialityIdEnum.CODE_202.getCode()) && !vo.getSpeciality().equals(SpecialityIdEnum.CODE_203.getCode()) && !vo.getSpeciality().equals(SpecialityIdEnum.CODE_204.getCode())) continue;
            vo2.setValue(vo2.getValue().add(vo.getValue().multiply(new BigDecimal(10000))));
        }
        undertakeApiVOS.add(vo1);
        undertakeApiVOS.add(vo2);
        undertakeApiVOS.add(vo3);
        undertakeApiVOS.add(vo4);
        undertakeApiVOS.add(vo5);
        undertakeApiVOS.add(vo6);
        undertakeApiVOS.add(vo7);
        undertakeApiVOS.add(vo8);
        undertakeApiVOS.add(vo9);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", undertakeApiVOS);
    }

    public static String getMonthStartTime(DateTimeFormatter dateTimeFormatter) {
        Long currentTime = System.currentTimeMillis();
        String timeZone = "GMT+8:00";
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(TimeZone.getTimeZone(timeZone));
        cal.setTimeInMillis(currentTime);
        cal.add(1, 0);
        cal.add(2, 0);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        LocalDateTime monthStart = LocalDateTime.ofInstant(Instant.ofEpochMilli(cal.getTimeInMillis()), ZoneId.systemDefault());
        return monthStart.format(dateTimeFormatter);
    }

    private static String getMonthEndTime(DateTimeFormatter dateTimeFormatter) {
        Long currentTime = System.currentTimeMillis();
        String timeZone = "GMT+8:00";
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(TimeZone.getTimeZone(timeZone));
        cal.setTimeInMillis(currentTime);
        cal.add(1, 0);
        cal.add(2, 0);
        cal.set(5, cal.getActualMaximum(5));
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        LocalDateTime monthEnd = LocalDateTime.ofInstant(Instant.ofEpochMilli(cal.getTimeInMillis()), ZoneId.systemDefault());
        return monthEnd.format(dateTimeFormatter);
    }

    public static String getFromThisQuarterStartTime(LocalDate nowDate, DateTimeFormatter dateTimeFormatter) {
        Month firstMonthOfQuarter = nowDate.getMonth().firstMonthOfQuarter();
        nowDate = LocalDate.of(nowDate.getYear(), firstMonthOfQuarter, 1);
        LocalDateTime fromThisQuarterStart = LocalDateTime.of(nowDate, LocalTime.MIN);
        return fromThisQuarterStart.format(dateTimeFormatter);
    }

    public static String getFromThisQuarterEndTime(LocalDate nowDate, DateTimeFormatter dateTimeFormatter) {
        Month firstMonthOfQuarter = nowDate.getMonth().firstMonthOfQuarter();
        Month endMonthOfQuarter = Month.of(firstMonthOfQuarter.getValue() + 2);
        nowDate = LocalDate.of(nowDate.getYear(), endMonthOfQuarter, endMonthOfQuarter.length(nowDate.isLeapYear()));
        LocalDateTime fromThisQuarterEnd = LocalDateTime.of(nowDate, LocalTime.MAX);
        return fromThisQuarterEnd.format(dateTimeFormatter);
    }

    public static String getFromThisYearStartTime(LocalDate nowDate, DateTimeFormatter dateTimeFormatter) {
        LocalDate firstDayOfYear = nowDate.with(TemporalAdjusters.firstDayOfYear());
        LocalDateTime fromThisYearStart = LocalDateTime.of(firstDayOfYear, LocalTime.MIN);
        return fromThisYearStart.format(dateTimeFormatter);
    }

    public static String getFromThisYearEndTime(LocalDate nowDate, DateTimeFormatter dateTimeFormatter) {
        LocalDate lastDayOfYear = nowDate.with(TemporalAdjusters.lastDayOfYear());
        LocalDateTime fromThisYearEnd = LocalDateTime.of(lastDayOfYear, LocalTime.MAX);
        return fromThisYearEnd.format(dateTimeFormatter);
    }
}

