package com.ejianc.business.outputvalcount.controller;

import java.io.Serializable;

import com.ejianc.business.outputvalcount.mapper.MonthlyStatisticsMapper;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectSurveyVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.outputvalcount.bean.MonthlyStatisticsEntity;
import com.ejianc.business.outputvalcount.service.IMonthlyStatisticsService;
import com.ejianc.business.outputvalcount.vo.MonthlyStatisticsVO;

/**
 * 月度产值统计
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("monthlyStatistics")
public class MonthlyStatisticsController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "outputvalcount_monthly_statistics";//此处需要根据实际修改

    private static final BigDecimal FIVE_MILLION = new BigDecimal(500_0000);//五百万
    private static final BigDecimal TEN_MILLION = new BigDecimal(1000_0000);//一千万

    @Autowired
    private IMonthlyStatisticsService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private MonthlyStatisticsMapper mapper;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<MonthlyStatisticsVO> saveOrUpdate(@RequestBody MonthlyStatisticsVO saveOrUpdateVO) {
    	MonthlyStatisticsEntity entity = BeanMapper.map(saveOrUpdateVO, MonthlyStatisticsEntity.class);
        UserContext userContextCache =sessionManager.getUserContext();
        if(entity.getId() == null || entity.getId() == 0){
            //设置创建人姓名
            entity.setCreateUserName(userContextCache.getUserName());
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }else {
            //设置修改人姓名
            entity.setUpdateUserName(userContextCache.getUserName());
        }
        MonthlyStatisticsEntity monthlyStatistics = service.getMonthlyStatistics(entity);
//    	entity.setBnwccz(monthlyStatistics.getBnwccz());
//    	entity.setKgwccz(monthlyStatistics.getKgwccz());
        service.saveOrUpdate(monthlyStatistics, false);
    	MonthlyStatisticsVO vo = BeanMapper.map(entity, MonthlyStatisticsVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MonthlyStatisticsVO> queryDetail(Long id) {

    	MonthlyStatisticsEntity entity = service.selectById(id);
        BigDecimal sumMny = service.getSumMny(entity.getProjectId());
        entity.setZje(sumMny);
        MonthlyStatisticsVO vo = BeanMapper.map(entity, MonthlyStatisticsVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description
     * @param id
     */
    @RequestMapping(value = "/getSumMny", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BigDecimal> getSumMny(Long id) { ;
        BigDecimal sumMny = service.getSumMny(id);
        System.out.println(sumMny);
        return CommonResponse.success("查询总金额成功！",sumMny);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MonthlyStatisticsVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (MonthlyStatisticsVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(MonthlyStatisticsVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MonthlyStatisticsVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();


        /**
         * 范围筛选
         */
        if(param.getParams().get("byjhwcczPlan") != null){
            //1:500以下 2:500万到1000万 3:1000万以上
            String flag = param.getParams().get("byjhwcczPlan").getValue().toString();

            if("1".equals(flag)){
                param.getParams().remove("byjhwcczPlan");
                param.getParams().put("byjhwcczPlan",new Parameter(QueryParam.LE,FIVE_MILLION));
            } else if("2".equals(flag)){
                param.getParams().remove("byjhwcczPlan");
                param.getParams().put("byjhwcczPlan",new Parameter(QueryParam.SQL,"byjhwccz_plan >= "+FIVE_MILLION + " and byjhwccz_plan <" + TEN_MILLION));
            } else if("3".equals(flag)){
                param.getParams().remove("byjhwcczPlan");
                param.getParams().put("byjhwcczPlan",new Parameter(QueryParam.GE,TEN_MILLION));
            }
        }
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(!param.getParams().containsKey("orgId")) {
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");

            //普通组织 id
            List<Long> commonOrgIds = new ArrayList<>();
            orgVOList.stream().forEach(org -> {
                //普通组织
                commonOrgIds.add(org.getId());
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
                param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
            }
            /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        }
        IPage<MonthlyStatisticsEntity> page = service.queryPage(param,false);
        IPage<MonthlyStatisticsVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), MonthlyStatisticsVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<MonthlyStatisticsEntity> list = service.queryList(param);
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("MonthlyStatistics-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refMonthlyStatisticsData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<MonthlyStatisticsVO>> refMonthlyStatisticsData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<MonthlyStatisticsEntity> page = service.queryPage(param,false);
        IPage<MonthlyStatisticsVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MonthlyStatisticsVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @Description queryList 查询列表
     * @param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryProjectOutputValueNotUpload", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ProjectSurveyVO>> queryProjectOutputValueNotUpload() {
        Calendar now = Calendar.getInstance();
        Integer year = now.get(Calendar.YEAR);
        Integer month = now.get(Calendar.MONTH) + 1;

        ArrayList<ProjectSurveyVO> projectList = new ArrayList<>();

        // List<Long> monthlyStatisticsByDate = statisticsService.getMonthlyStatisticsByDate(now.get(Calendar.YEAR), (now.get(Calendar.MONTH) + 1));
        List<Long> monthlyStatisticsByDate = service.getMonthlyStatisticsByDate(year, month);
        logger.info("本月上报数量数量：{}", monthlyStatisticsByDate.size());
        CommonResponse<List<ProjectSurveyVO>> listCommonResponse = projectPoolApi.queryProjectList("1", null, null, "henan");
        logger.info("查找项目池返回的消息：{}", listCommonResponse.getMsg());
        if (listCommonResponse.getCode() == 0) {
            List<ProjectSurveyVO> poolSetVOS = listCommonResponse.getData();
            logger.info("项目池在建数量：{}", poolSetVOS.size());
            //int i = 0;
            for (ProjectSurveyVO poolSetVO : poolSetVOS) {
                //if (i<7) {
                    if (!monthlyStatisticsByDate.contains(poolSetVO.getId())) {
                        projectList.add(poolSetVO);
                       // i++;
                    }
               // }
            }
        }
        return CommonResponse.success("查询列表数据成功！",projectList);
    }

}
