package com.ejianc.business.outputvalcount.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.outputvalcount.bean.MonthlyPlanEntity;
import com.ejianc.business.outputvalcount.bean.MonthlyStatisticsEntity;
import com.ejianc.business.outputvalcount.bean.XmyxglEntity;
import com.ejianc.business.outputvalcount.mapper.XmjdmxMapper;
import com.ejianc.business.outputvalcount.service.IMonthlyPlanService;
import com.ejianc.business.outputvalcount.service.IMonthlyStatisticsService;
import com.ejianc.business.outputvalcount.service.IXmyxglService;
import com.ejianc.business.outputvalcount.vo.*;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.outputvalcount.bean.XmjdmxEntity;
import com.ejianc.business.outputvalcount.service.IXmjdmxService;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;
import static java.math.BigDecimal.ROUND_HALF_UP;

/**
 * 项目进度明细
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("xmjdmx")
public class XmjdmxController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IXmjdmxService service;

    @Autowired
    private IMonthlyStatisticsService statisticsService;

    @Autowired
    private IMonthlyPlanService planService;

    @Autowired
    private IXmyxglService xmyxglService;

    @Autowired
    private XmjdmxMapper mapper;

    @Autowired
    private SessionManager sessionManager;



    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<XmjdmxVO> queryDetail(Long id) {
    	XmjdmxEntity entity = service.selectById(id);
        XmjdmxVO vo = new XmjdmxVO();
        if(entity == null) {
            return CommonResponse.success("该项目尚未上报项目进度数据！",vo);
        }
        vo = BeanMapper.map(entity, XmjdmxVO.class);
    	//查询参数
        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter(QueryParam.EQ,entity.getProjectId()));
        param.getParams().put("dr", new Parameter(QueryParam.EQ,0));
        LinkedHashMap<String, String> orderMap = param.getOrderMap();
        orderMap.put("createTime",QueryParam.DESC);
        //param.getParams().put("billState", new Parameter(QueryParam.EQ,0));

        //产值统计
        List<MonthlyStatisticsVO> statisticsVOList = new ArrayList<>();
        List<MonthlyStatisticsEntity> monthlyStatisticsEntities = statisticsService.queryList(param);
        for (MonthlyStatisticsEntity statisticsEntity: monthlyStatisticsEntities){
            MonthlyStatisticsVO map = BeanMapper.map(statisticsEntity, MonthlyStatisticsVO.class);
            statisticsVOList.add(map);
        }
        vo.setStatisticsList(statisticsVOList);

        //产值计划
        List<MonthlyPlanVO> planVOList = new ArrayList<>();
        List<MonthlyPlanEntity> monthlyPlanEntities = planService.queryList(param);
        for (MonthlyPlanEntity planEntity : monthlyPlanEntities){
            MonthlyPlanVO map = BeanMapper.map(planEntity, MonthlyPlanVO.class);
            planVOList.add(map);
        }
        vo.setPlanList(planVOList);

        //影像管理
        //查询参数2
        QueryParam param1 = new QueryParam();
        param1.getParams().put("xmId", new Parameter(QueryParam.EQ,entity.getProjectId()));
        param1.getParams().put("dr", new Parameter(QueryParam.EQ,0));
        param1.getOrderMap().put("createTime",QueryParam.DESC);

        List<XmyxglVO> xmyxglList = new ArrayList<>();
        List<XmyxglEntity> xmyxglEntities = xmyxglService.queryList(param1);
        for (XmyxglEntity xmyxglEntity : xmyxglEntities){
            XmyxglVO map = BeanMapper.map(xmyxglEntity, XmyxglVO.class);
            xmyxglList.add(map);
        }
        vo.setXmyxglList(xmyxglList);

        //产值报量
        List<ProductionVO> production = mapper.getProduction(entity.getProjectId());
        vo.setProductionList(production);

        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<XmjdmxVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (XmjdmxVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(XmjdmxVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));

        if (!param.getParams().containsKey("orgId")) {
            /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
            UserContext userContextCache = sessionManager.getUserContext();
            //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
            String authOrgIds = userContextCache.getAuthOrgIds();
            List<OrgVO> orgVOList = null;
            if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
            } else {//pc端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            }
            //普通组织 id
            List<Long> commonOrgIds = new ArrayList<>();
            orgVOList.stream().forEach(org -> {
                //普通组织
                commonOrgIds.add(org.getId());
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
                    param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
            }
            /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        }

        QueryWrapper wrapper = changeToQueryWrapper(param);
        BigDecimal sumValue2 = mapper.getSumValue(wrapper);
        BigDecimal sumValue = new BigDecimal(0.0);
        if (sumValue2 != null) {
             sumValue =  sumValue2.divide(new BigDecimal(10000), 2, ROUND_HALF_UP);
        }
        BigDecimal sumValue1 = new BigDecimal(0.0);
        BigDecimal sumValue11 = mapper.getSumValue1(wrapper);
        if (sumValue11 != null) {
            sumValue1 = sumValue11.divide(new BigDecimal(10000), 2, ROUND_HALF_UP);
        }

        IPage<XmjdmxEntity> page = service.queryPage(param,false);
        JSONObject pageJson = new JSONObject();
        pageJson.put("records", BeanMapper.mapList(page.getRecords(), XmjdmxVO.class));
        pageJson.put("total", page.getTotal());
        pageJson.put("current", page.getCurrent());
        pageJson.put("size", page.getSize());
        pageJson.put("pages", page.getPages());
        pageJson.put("sumValue", sumValue);
        pageJson.put("sumValue1", sumValue1);

        return CommonResponse.success("查询列表数据成功！",pageJson);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<XmjdmxEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Xmjdmx-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refXmjdmxData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<XmjdmxVO>> refXmjdmxData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<XmjdmxEntity> page = service.queryPage(param,false);
        IPage<XmjdmxVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), XmjdmxVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }


}
