package com.ejianc.business.outputvalcount.api;


import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.outputvalcount.bean.MonthlyStatisticsEntity;
import com.ejianc.business.outputvalcount.bean.XmjdmxEntity;
import com.ejianc.business.outputvalcount.bean.XmyxglEntity;
import com.ejianc.business.outputvalcount.mapper.MonthlyStatisticsMapper;
import com.ejianc.business.outputvalcount.service.IXmjdmxService;
import com.ejianc.business.outputvalcount.service.IXmyxglService;
import com.ejianc.business.outputvalcount.utils.SpecialityIdEnum;
import com.ejianc.business.outputvalcount.vo.*;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.sql.*;
import java.text.SimpleDateFormat;
import java.time.*;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.*;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/api/outputValue/")
public class OutputValueApi {

    @Autowired
    private MonthlyStatisticsMapper mapper;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IXmyxglService service;
    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private IXmjdmxService xmjdmxService;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    /**
     *
     * @param projectId
     * @return
     */
    @RequestMapping(value = "getSumByProjectId", method= RequestMethod.GET)
    CommonResponse<OutputValueVO> getSumByProjectId(@RequestParam(value = "projectId") Long projectId){
        //获取当前项目的所有单据
        String name = "";
        List<MonthlyStatisticsEntity> monthlyStatistics = mapper.getMonthlyStatistics(projectId);
        BigDecimal sum = new BigDecimal(0);//开工累计金额

        for(MonthlyStatisticsEntity entity : monthlyStatistics){
            name = entity.getProjectName();
            if(entity.getBillState() == 1 || entity.getBillState() == 3){
                sum = sum.add(entity.getBywccz());
            }

        }
        OutputValueVO outputValueVO = new OutputValueVO();

        outputValueVO.setProjectName(name);
        outputValueVO.setProjectId(projectId);
        outputValueVO.setSum(sum);
        return CommonResponse.success("获取数据成功！",outputValueVO);
    }


    /**
     *
     * @param projectId
     * @param num
     * @return
     */
    @RequestMapping(value = "getInfoByProjectId", method= RequestMethod.GET)
    CommonResponse<List<XmyxglVO>> getInfoByProjectId(@RequestParam(value = "projectId") Long projectId,@RequestParam(value = "num") Integer num) {
        //获取当前组织下的所有项目、组织
        List<OrgVO> respData = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(projectId), true, "查询失败，获取当前本下组织信息失败。");
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        respData.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            }
        });

        //获取当前项目的所有单据
        QueryParam queryParam = new QueryParam();
        queryParam.getOrderMap().put("createTime",QueryParam.DESC);
        queryParam.setPageSize(num);//获取的个数由传入的参数决定
       queryParam.setPageIndex(1);
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        List<Integer> billStates = new ArrayList<>();
        billStates.add(1);
        billStates.add(3);
        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, billStates));
        queryParam.getParams().put("syxs", new Parameter(QueryParam.EQ, 2));
        IPage<XmyxglEntity> xmyxglEntityIPage = service.queryPage(queryParam, false);
        List<XmyxglVO> xmyxglVOS = BeanMapper.mapList(xmyxglEntityIPage.getRecords(), XmyxglVO.class);
        //获取表单附件的地址
        for (XmyxglVO vo:xmyxglVOS) {
            CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.queryListBySourceId(vo.getId(), "ZZYJ202205050002", "add", "");
            if (listCommonResponse.getCode() == 0){
                List<AttachmentVO> data = listCommonResponse.getData();
                if (data.size()>0){
                    String truePath = data.get(0).getTruePath();
                    int i = truePath.lastIndexOf(".");
                    String substring = truePath.substring(0, i)+"_500x500"+truePath.substring(i);
                    vo.setTruePath(substring);//附件上传多个则取第一张图片
                }
            }
        }

        return CommonResponse.success("获取数据成功！",xmyxglVOS);
    }


    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    /**
     * 获取本项目的层级的  所有产值
     * @param orgId
     * @return
     */
    @RequestMapping(value = "getSumByOrgId", method= RequestMethod.GET)
    CommonResponse<OutputValueVO> getSumByOrgId(@RequestParam(value = "orgId") Long orgId){
        //获取当前项目的所有单据
        List<MonthlyStatisticsEntity> monthlyStatistics = mapper.getMonthlyStatisticsByDeptId(orgId);
        BigDecimal sum = new BigDecimal(0);//开工累计金额

        for(MonthlyStatisticsEntity entity : monthlyStatistics){
            if(entity.getBillState() == 1 || entity.getBillState() == 3){
                sum = sum.add(entity.getBywccz());
            }
        }
        OutputValueVO outputValueVO = new OutputValueVO();

        CommonResponse<OrgVO> oneById = iOrgApi.getOneById(orgId);
        if(oneById.getCode()==0){
            OrgVO data = oneById.getData();
            outputValueVO.setProjectName(data.getName());
        }
        logger.info("查询产值的组织id：{}",orgId);
        if (orgId == 1502571152583692289L ){
            //组织为郑州一建集团则增加G9项目
            sum = sum.add(getG9Money(null));
        }
        outputValueVO.setProjectId(orgId);
        outputValueVO.setSum(sum);
        return CommonResponse.success("获取数据成功！",outputValueVO);
    }

    /**
     * 获取本下单位的总产值  按年度取产值
     * @param orgId
     * @return
     */
    @RequestMapping(value = "getSumByOrgIdUnder", method= RequestMethod.GET)
    CommonResponse<BigDecimal> getSumByOrgIdUnder(@RequestParam(value = "orgId") Long orgId,
                                                  @RequestParam(value = "year") Integer year){
        //获取当前项目的所有单据
        //获取当前组织下的所有项目、组织
        QueryParam param = new QueryParam();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
        /** 单据状态 */
        param.getParams().put("billState", new Parameter(QueryParam.IN,
                Arrays.asList(new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()})));

        param.getParams().put("projectDepartmentId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
    //1539639347695513601
        //去除G9项目的值
        param.getParams().put("projectId",new Parameter(QueryParam.NE,643021352342790201L));

        /** ywDate */
        if (!year.equals(0)) {
        param.getParams().put("statDate", new Parameter(QueryParam.BETWEEN,
                year+"-1-1,"+year+"-12-31"));
        }
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);
        List<MonthlyStatisticsEntity> monthlyStatistics = mapper.getSumByOrgIdUnder(wrapper);

        BigDecimal sum = new BigDecimal(0);//开工累计金额

        for(MonthlyStatisticsEntity entity : monthlyStatistics){
            if(entity.getBillState() == 1 || entity.getBillState() == 3){
                sum = sum.add(entity.getBywccz());
            }
        }

        logger.info("查询产值的组织id：{}",orgId);
        if (orgId == 1502571152583692289L ){
            //组织为郑州一建集团则增加G9项目
            sum = sum.add(getG9Money(year));
        }
        return CommonResponse.success("获取数据成功！",sum);
    }


    /**
     * 批量获取本下单位的总产值  按年度取产值
     * @param
     * @return
     */
    @RequestMapping(value = "getSumByOrgIds", method= RequestMethod.POST)
    CommonResponse<HashMap<Long, BigDecimal>> getSumByOrgIds(@RequestBody OutputValDTO dto){

        if (dto.getOrgIds() == null){
            return CommonResponse.error("项目id不允许为空");
        }
        //获取当前项目的所有单据
        //获取当前组织下的所有项目、组织
        QueryParam param = new QueryParam();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
        /** 单据状态 */
        param.getParams().put("billState", new Parameter(QueryParam.IN,
                Arrays.asList(new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()})));

        /** ywDate */
        if (dto.getYear() != null && !dto.getYear().equals(0)) {
            param.getParams().put("statDate", new Parameter(QueryParam.BETWEEN,
                    dto.getYear()+"-1-1,"+dto.getYear()+"-12-31"));
        }
        HashMap<Long, BigDecimal> hashMap = new HashMap<>();
        for (Long orgId : dto.getOrgIds()) {
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

            QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);
            List<MonthlyStatisticsEntity> monthlyStatistics = mapper.getSumByOrgIdUnder(wrapper);

            BigDecimal sum = new BigDecimal(0);//开工累计金额

            for (MonthlyStatisticsEntity entity : monthlyStatistics) {
                if (entity.getBillState() == 1 || entity.getBillState() == 3) {
                    sum = sum.add(entity.getBywccz());
                }
            }
            hashMap.put(orgId,sum);
        }
        return CommonResponse.success("获取数据成功！",hashMap);
    }



    /**
     * 项目产值接口一提供给财务使用
     * @param
     * @return
     */
    @RequestMapping(value = "getOutputValue", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<ProjectDetailDTO>> getOutputValue(HttpServletRequest request) {
        String syncMode = request.getParameter("syncMode");
        String syncTime = null;
        if("increment".equals(syncMode)) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            Calendar calendar = Calendar.getInstance(); //创建Calendar 的实例
            calendar.add(Calendar.DAY_OF_MONTH, -1);

            syncTime = dateFormat.format(calendar.getTime()) + " 00:00:00";
            logger.info("syncTime为：--{}",syncTime);
        }
        List<ProjectDetailDTO> supplierBankList = xmjdmxService.queryOutputValueBySyncTime(syncTime);


       // List<XmjdmxEntity> xmjdmxEntities = xmjdmxService.queryList(param);
        // }
        //List<ProjectDetailDTO> projectDetailDTOS = BeanMapper.mapList(xmjdmxEntities, ProjectDetailDTO.class);

        return CommonResponse.success(supplierBankList);
    }

    //G9项目
    public BigDecimal getG9Money(Integer year1) {
        try{  Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
            logger.info("连接成功1");
        }
        catch(Exception e) {
            logger.info("连接失败1");
        }
        String connectionUrl =
                "jdbc:sqlserver://172.16.1.242:1433;"
                        + "databaseName=master;"
                        + "user=sa;"
                        + "password=Zzyj2015;";
        Connection con;//处理与特定数据库的连接

        Statement stmt = null;
        ResultSet rs = null;
        BigDecimal bigDecimal = new BigDecimal("0.00");
        try {
            con = DriverManager.getConnection(connectionUrl);
            logger.info("连接成功2");
            Calendar date = Calendar.getInstance();

            String year = String.valueOf(date.get(Calendar.YEAR));//本年

            if (year1 != null){
                year = year1+"";
            }
            String SQL = "SELECT SUM(F_JE) as je FROM [gtp-default].[dbo].[PG7ZZ_XMGLZFGSYY_ZFGSCZTJ]\n" +
                    "where F_TJNF =" +year+"\n"+
                    "and F_STATE = 3\n" +
                    "and F_DEPT_ID not in (22754)\n" +
                    "GROUP BY F_TJNF ";
            stmt = con.createStatement();// 创建Statement
            rs = stmt.executeQuery(SQL);// 执行SQL语句----------- *1

            while (rs.next()) {
                // 遍历result set 的结果并打印
                bigDecimal=rs.getBigDecimal("je");
            }

            con.close();
        } catch(SQLException e) {
            logger.info("请输入正确的表名"+e+".连接失败2");
        }

        return  bigDecimal;
    }




    /**
     * BI门户：年度产值达成率
     * @param orgId
     * @param dateIn
     * @return
     */
    @RequestMapping(value = "outputvalYearTarget", method= RequestMethod.GET)
    CommonResponse<OutputvalTargetVO> outputvalYearTarget(@RequestParam(value = "orgId") Long orgId,
                                                  @RequestParam(value = "dateIn") Integer dateIn){
        //获取当前项目的所有单据
        //获取当前组织下的所有项目、组织
        QueryParam param = new QueryParam();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
        /** 单据状态 */
        param.getParams().put("billState", new Parameter(QueryParam.IN,
                Arrays.asList(new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()})));

        //param.getParams().put("projectDepartmentId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        //1539639347695513601
        //去除G9项目的值
        param.getParams().put("projectId",new Parameter(QueryParam.NE,643021352342790201L));

        /** ywDate */
        param.getParams().put("statDate", new Parameter(QueryParam.BETWEEN,
                    dateIn+"-1-1,"+dateIn+"-12-31"));

        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);
        List<MonthlyStatisticsEntity> monthlyStatistics = mapper.getSumByOrgIdUnder(wrapper);
        BigDecimal sum = new BigDecimal(0);//开工累计金额
        for(MonthlyStatisticsEntity entity : monthlyStatistics){
            if(entity.getBillState() == 1 || entity.getBillState() == 3){
                sum = sum.add(entity.getBywccz());
            }
        }

        logger.info("查询产值的组织id：{}",orgId);
       // if (orgId == 1502571152583692289L ){
            //组织为郑州一建集团则增加G9项目
            sum = sum.add(getG9Money(dateIn));
        //}
        OutputvalTargetVO outputvalTargetVO = mapper.queryOutputvalYearTarget(dateIn + "");
        outputvalTargetVO.setOutputvalMny(sum);
        outputvalTargetVO.setPercentComplete((
                outputvalTargetVO.getOutputvalMny().divide(outputvalTargetVO.getTargetMny(),2,BigDecimal.ROUND_DOWN)).multiply(new BigDecimal(100)));

        return CommonResponse.success("获取数据成功！",outputvalTargetVO);
    }



    /**
     * BI门户：月度产值分布
     * @param orgId 门户的组织id
     * @param dateIn  年份
     * @return
     */
    @RequestMapping(value = "/outputvalCostMonth", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<String>> outputvalCostMonth(@RequestParam(value = "orgId", required = true) Long orgId,
                                                               @RequestParam(value = "dateIn", required = true) Integer dateIn
    ) {

        //获取当前组织下的所有项目、组织
        List<OrgVO> respData = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
        //项目部 id
        List<Long> orgIds = new ArrayList<>();
        respData.stream().forEach(org -> {
            orgIds.add(org.getId());
        });

        List<String> bigDecimals = mapper.queryOutputvalCostMonth(dateIn+"", orgIds);

        return CommonResponse.success("查询成功！",bigDecimals);
    }


    /**
     * BI门户：重点在施项目与施工进展
     * @param orgId 门户的组织id
     * @param dateIn  年份
     * @return
     */
    @RequestMapping(value = "/queryMajorProjectIds", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<XmyxglVO>> queryMajorProjectIds(@RequestParam(value = "orgId", required = true) Long orgId,
                                                               @RequestParam(value = "dateIn", required = true) Integer dateIn
    ) {

        //获取当前组织下的所有项目、组织
        List<OrgVO> respData = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
        //项目部 id
        List<Long> orgIds = new ArrayList<>();
        respData.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                orgIds.add(org.getId());
            }
        });
        //projectDepartmentId

        List<XmyxglVO> xmyxglVOS = mapper.queryMajorProjectIds(orgIds);
        List<Long> collect = xmyxglVOS.stream().map(XmyxglVO::getId).collect(Collectors.toList());
        if (collect != null && collect.size()>0){
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("sourceIds",collect);
            jsonObject.put("orderType","desc");

            //获取附件数据
            CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.queryAllBySourceIdList(jsonObject);
            //拼接附件地址
            if (listCommonResponse.getCode() == 0){
                List<AttachmentVO> data = listCommonResponse.getData();
                for (AttachmentVO datum : data) {
                    for (XmyxglVO vo:xmyxglVOS) {
                        if (datum.getSourceId().equals(vo.getId())){
                            int i = datum.getTruePath().lastIndexOf(".");
                            String substring = datum.getTruePath().substring(0, i)+"_500x500"+datum.getTruePath().substring(i);
                            vo.setTruePath(substring);//附件上传多个则取第一张图片
                        }
                    }
                }
            }
        }


        return CommonResponse.success("查询成功！",xmyxglVOS);
    }



    /**
     * 获取饼状图信息（组织本下）承建类型产值占比
     * @param orgId
     * @param time 1：月度  2：季度  3：年度
     *             type 0数量纬度（不显示补充协议） 1金额维度（显示补充协议）
     * @return
     */
    @RequestMapping(value = "/getUndertakeInfo", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<OutputApiVO>> getUndertakeInfo(@RequestParam(value = "orgId", required = true) Long orgId,
                                                                 Integer time,
                                                                 Integer dateIn
    ) {
        QueryParam param = new QueryParam();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
        //获取当前组织下的所有项目、组织
        List<OrgVO> respData = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        respData.stream().forEach(org -> {
            if(3 == org.getOrgType()  ||  2 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            }
        });
        /** orgId */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));


        /** stat_date */
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate nowDate = LocalDate.now();

        if (time != null) {
            if (time.equals(1)){//月度
                param.getParams().put("stat_date", new Parameter(QueryParam.BETWEEN,
                        getMonthStartTime(dateTimeFormatter) +","+ getMonthEndTime(dateTimeFormatter)));
            }else if (time.equals(2)){//季度
                param.getParams().put("stat_date", new Parameter(QueryParam.BETWEEN,
                        getFromThisQuarterStartTime(nowDate,dateTimeFormatter) +","+ getFromThisQuarterEndTime(nowDate,dateTimeFormatter)));
            }else {
                param.getParams().put("stat_date", new Parameter(QueryParam.BETWEEN,
                        getFromThisYearStartTime(nowDate,dateTimeFormatter) +","+ getFromThisYearEndTime(nowDate,dateTimeFormatter)));
            }
        }else if(dateIn != null){
            param.getParams().put("stat_date", new Parameter(QueryParam.BETWEEN,
                    dateIn+"-01-01,"+dateIn+"-12-31" ));
        }

        /** 单据状态 */
        param.getParams().put("billState", new Parameter(QueryParam.IN,
                Arrays.asList(new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()})));


        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);

        wrapper.groupBy("lb_id");

        List<OutputApiVO> undertakeVOS = mapper.queryUndertakeInfoList(wrapper);


        ArrayList<OutputApiVO> undertakeApiVOS = new ArrayList<>();

        OutputApiVO vo1 = new OutputApiVO(SpecialityIdEnum.CODE_1.getCode(),SpecialityIdEnum.CODE_1.getName(),new BigDecimal(0.00),0);//房屋建筑

        OutputApiVO vo2 = new OutputApiVO(SpecialityIdEnum.CODE_2.getCode(),SpecialityIdEnum.CODE_2.getName(),new BigDecimal(0.00),0);//市政工程

        OutputApiVO vo3 = new OutputApiVO(SpecialityIdEnum.CODE_3.getCode(),SpecialityIdEnum.CODE_3.getName(),new BigDecimal(0.00),0);//

        OutputApiVO vo4 = new OutputApiVO(SpecialityIdEnum.CODE_4.getCode(),SpecialityIdEnum.CODE_4.getName(),new BigDecimal(0.00),0);//

        OutputApiVO vo5 = new OutputApiVO(SpecialityIdEnum.CODE_5.getCode(),SpecialityIdEnum.CODE_5.getName(),new BigDecimal(0.00),0);//

        OutputApiVO vo6 = new OutputApiVO(SpecialityIdEnum.CODE_6.getCode(),SpecialityIdEnum.CODE_6.getName(),new BigDecimal(0.00),0);//

        OutputApiVO vo7 = new OutputApiVO(SpecialityIdEnum.CODE_7.getCode(),SpecialityIdEnum.CODE_7.getName(),new BigDecimal(0.00),0);//

        OutputApiVO vo8 = new OutputApiVO(SpecialityIdEnum.CODE_8.getCode(),SpecialityIdEnum.CODE_8.getName(),new BigDecimal(0.00),0);//

        OutputApiVO vo9 = new OutputApiVO(SpecialityIdEnum.CODE_9.getCode(),SpecialityIdEnum.CODE_9.getName(),new BigDecimal(0.00),0);//


        for (OutputApiVO vo : undertakeVOS){
            if (vo.getSpeciality().equals(SpecialityIdEnum.CODE_3.getCode())){
                //vo3.setSum(vo.getSum());
                vo3.setValue(vo.getValue().multiply(new BigDecimal(10000)));
            }else if (vo.getSpeciality().equals(SpecialityIdEnum.CODE_4.getCode())){
                //vo4.setSum(vo.getSum());
                vo4.setValue(vo.getValue().multiply(new BigDecimal(10000)));
            }else if (vo.getSpeciality().equals(SpecialityIdEnum.CODE_5.getCode())){
                // vo5.setSum(vo.getSum());
                vo5.setValue(vo.getValue().multiply(new BigDecimal(10000)));
            }else if (vo.getSpeciality().equals(SpecialityIdEnum.CODE_6.getCode())){
                // vo6.setSum(vo.getSum());
                vo6.setValue(vo.getValue().multiply(new BigDecimal(10000)));
            }else if (vo.getSpeciality().equals(SpecialityIdEnum.CODE_7.getCode())){
                //vo7.setSum(vo.getSum());
                vo7.setValue(vo.getValue().multiply(new BigDecimal(10000)));
            }else if (vo.getSpeciality().equals(SpecialityIdEnum.CODE_8.getCode())){
                //vo8.setSum(vo.getSum());
                vo8.setValue(vo.getValue().multiply(new BigDecimal(10000)));
            }else if (vo.getSpeciality().equals(SpecialityIdEnum.CODE_9.getCode())){
                //vo9.setSum(vo.getSum());
                vo9.setValue(vo.getValue().multiply(new BigDecimal(10000)));
            }else if(vo.getSpeciality().equals(SpecialityIdEnum.CODE_1.getCode())||
                    vo.getSpeciality().equals(SpecialityIdEnum.CODE_101.getCode())||
                    vo.getSpeciality().equals(SpecialityIdEnum.CODE_102.getCode())||
                    vo.getSpeciality().equals(SpecialityIdEnum.CODE_103.getCode())){
                //vo1.setSum(vo1.getSum()+vo.getSum());//总数
                vo1.setValue(vo1.getValue().add(vo.getValue().multiply(new BigDecimal(10000))));//金额
            }else if(vo.getSpeciality().equals(SpecialityIdEnum.CODE_2.getCode())||
                    vo.getSpeciality().equals(SpecialityIdEnum.CODE_201.getCode())||
                    vo.getSpeciality().equals(SpecialityIdEnum.CODE_202.getCode())||
                    vo.getSpeciality().equals(SpecialityIdEnum.CODE_203.getCode())||
                    vo.getSpeciality().equals(SpecialityIdEnum.CODE_204.getCode())){
                //vo2.setSum(vo2.getSum()+vo.getSum());//总数
                vo2.setValue(vo2.getValue().add(vo.getValue().multiply(new BigDecimal(10000))));//金额
            }
        }

        undertakeApiVOS.add(vo1);
        undertakeApiVOS.add(vo2);
        undertakeApiVOS.add(vo3);
        undertakeApiVOS.add(vo4);
        undertakeApiVOS.add(vo5);
        undertakeApiVOS.add(vo6);
        undertakeApiVOS.add(vo7);
        undertakeApiVOS.add(vo8);
        undertakeApiVOS.add(vo9);

        return CommonResponse.success("查询成功！",undertakeApiVOS);
    }



    /**
     * 本月开始时间
     * @param dateTimeFormatter
     * @return
     */
    public static String getMonthStartTime(DateTimeFormatter dateTimeFormatter) {
        Long currentTime = System.currentTimeMillis();
        String timeZone = "GMT+8:00";
        Calendar cal = Calendar.getInstance();// 获取当前日期
        cal.setTimeZone(TimeZone.getTimeZone(timeZone));
        cal.setTimeInMillis(currentTime);
        cal.add(Calendar.YEAR, 0);
        cal.add(Calendar.MONTH, 0);
        cal.set(Calendar.DAY_OF_MONTH, 1);// 设置为1号,当前日期既为本月第一天
        cal.set(Calendar.HOUR_OF_DAY, 0);
        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.SECOND, 0);
        cal.set(Calendar.MILLISECOND, 0);
        LocalDateTime monthStart = LocalDateTime.ofInstant(Instant.ofEpochMilli(cal.getTimeInMillis()), ZoneId.systemDefault());
        return monthStart.format(dateTimeFormatter);
    }

    /**
     * 本月结束时间
     *
     * @return
     */
    private static String getMonthEndTime(DateTimeFormatter dateTimeFormatter) {
        Long currentTime = System.currentTimeMillis();
        String timeZone = "GMT+8:00";
        Calendar cal = Calendar.getInstance();// 获取当前日期
        cal.setTimeZone(TimeZone.getTimeZone(timeZone));
        cal.setTimeInMillis(currentTime);
        cal.add(Calendar.YEAR, 0);
        cal.add(Calendar.MONTH, 0);
        cal.set(Calendar.DAY_OF_MONTH, cal.getActualMaximum(Calendar.DAY_OF_MONTH));// 获取当前月最后一天
        cal.set(Calendar.HOUR_OF_DAY, 23);
        cal.set(Calendar.MINUTE, 59);
        cal.set(Calendar.SECOND, 59);
        cal.set(Calendar.MILLISECOND, 999);
        LocalDateTime monthEnd = LocalDateTime.ofInstant(Instant.ofEpochMilli(cal.getTimeInMillis()), ZoneId.systemDefault());
        return monthEnd.format(dateTimeFormatter);
    }


    //获取本季度开始时间
    public static String getFromThisQuarterStartTime(LocalDate nowDate,DateTimeFormatter dateTimeFormatter) {
        Month firstMonthOfQuarter = nowDate.getMonth().firstMonthOfQuarter();
        nowDate = LocalDate.of(nowDate.getYear(), firstMonthOfQuarter, 1);
        LocalDateTime fromThisQuarterStart = LocalDateTime.of(nowDate, LocalTime.MIN);
        return fromThisQuarterStart.format(dateTimeFormatter);

    }
    //获取本季度结束时间
    public static String getFromThisQuarterEndTime(LocalDate nowDate,DateTimeFormatter dateTimeFormatter) {
        Month firstMonthOfQuarter = nowDate.getMonth().firstMonthOfQuarter();
        Month endMonthOfQuarter = Month.of(firstMonthOfQuarter.getValue() + 2);
        nowDate = LocalDate.of(nowDate.getYear(), endMonthOfQuarter, endMonthOfQuarter.length(nowDate.isLeapYear()));
        LocalDateTime fromThisQuarterEnd = LocalDateTime.of(nowDate, LocalTime.MAX);
        return fromThisQuarterEnd.format(dateTimeFormatter);
    }

    /**
     * 今年起开始时间
     *
     * @return
     */
    public static String getFromThisYearStartTime(LocalDate nowDate,DateTimeFormatter dateTimeFormatter) {
        LocalDate firstDayOfYear = nowDate.with(TemporalAdjusters.firstDayOfYear());
        LocalDateTime fromThisYearStart = LocalDateTime.of(firstDayOfYear, LocalTime.MIN);
        return fromThisYearStart.format(dateTimeFormatter);
    }

    /**
     * 今年起结束时间
     *
     * @return
     */
    public static String getFromThisYearEndTime(LocalDate nowDate,DateTimeFormatter dateTimeFormatter) {
        LocalDate lastDayOfYear = nowDate.with(TemporalAdjusters.lastDayOfYear());
        LocalDateTime fromThisYearEnd = LocalDateTime.of(lastDayOfYear, LocalTime.MAX);
        return fromThisYearEnd.format(dateTimeFormatter);
    }





    /**
     * 门户：年度产值分布情况，工程部要求使用对外展示
     * @param dateIn
     * @return
     */
    @RequestMapping(value = "outputvalYearDistribute", method= RequestMethod.GET)
    CommonResponse<OutputValYearDistributeDTO> outputvalYearDistribute(@RequestParam(value = "dateIn") Integer dateIn){
        //查询柴郭和决算超概
        OutputValYearDistributeDTO outputValYearDistributeDTO = mapper.outputvalYearDistribute(dateIn+"");
        //分别查询pm子分公司的   1502571152701132801子公司   1502571152793407490分公司   1502571152847933442 项目部
        BigDecimal zjgc  = BigDecimal.ZERO;
        BigDecimal zfgs  = BigDecimal.ZERO;
        BigDecimal zfdw  = BigDecimal.ZERO;

        //项目部
        List<OrgVO> orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(1502571152847933442L), true, "查询失败，获取当前本下组织信息失败。");
        List<Long> collect = orgVOList.stream().map(OrgVO::getId).collect(Collectors.toList());
        BigDecimal bigDecimal = mapper.outputvalYearDistributeWithOrgId(dateIn + "", collect);
        if (bigDecimal != null){
            zjgc = bigDecimal;
        }

            logger.info("pm在建产值：{}",zjgc);
        //子公司
        orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(1502571152701132801L), true, "查询失败，获取当前本下组织信息失败。");
        collect = orgVOList.stream().map(OrgVO::getId).collect(Collectors.toList());
        bigDecimal = mapper.outputvalYearDistributeWithOrgId(dateIn + "", collect);
        if (bigDecimal != null){
            zfgs = bigDecimal;
        }
        logger.info("pm子公司产值：{}",zfgs);
        //分公司
        orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(1502571152793407490L), true, "查询失败，获取当前本下组织信息失败。");
        collect = orgVOList.stream().map(OrgVO::getId).collect(Collectors.toList());
        bigDecimal = mapper.outputvalYearDistributeWithOrgId(dateIn + "", collect);
        if (bigDecimal != null){
            zfdw = bigDecimal;
        }
        logger.info("pm分公司产值：{}",zfdw);

        outputValYearDistributeDTO.setZjgc(zjgc);
        outputValYearDistributeDTO.setZfgs(zfgs);
        outputValYearDistributeDTO.setZfdw(zfdw);

        try{  Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver"); }
        catch(Exception e) { logger.info("连接失败1"); }
        String connectionUrl =
                "jdbc:sqlserver://172.16.1.242:1433;"
                        + "databaseName=master;"
                        + "user=sa;"
                        + "password=Zzyj2015;";
        Connection con;//处理与特定数据库的连接
        Statement stmt = null;
        ResultSet rs = null;

        try {
            con = DriverManager.getConnection(connectionUrl);
            logger.info("连接成功2");
            String SQL = "SELECT SUM(cztj.F_JE) as je,left(dept.F_CODE, 3) as code FROM [gtp-default].[dbo].[PG7ZZ_XMGLZFGSYY_ZFGSCZTJ] as cztj\n" +
                    "LEFT JOIN [gtp-default].[dbo].[T_ORG_DEPT] as dept\n" +
                    "on dept.F_DEPT_ID = cztj.F_DEPT_ID\n" +
                    "where cztj.F_TJNF = "+dateIn+"\n" +
                    "and cztj.F_STATE = 3\n" +
                    "and cztj.F_DEPT_ID not in (22754)\n" +
                    "group by left(dept.F_CODE, 3)";
            stmt = con.createStatement();// 创建Statement
            rs = stmt.executeQuery(SQL);// 执行SQL语句----------- *1
            while (rs.next()) {
                String code = rs.getString("code");
                if (code != null ){
                    if ("102".equals(code)) {//子公司
                        BigDecimal je = rs.getBigDecimal("je");
                        logger.info("g9102产值：{}",je);
                        if (je != null) {
                            outputValYearDistributeDTO.setZfgs(je.add(outputValYearDistributeDTO.getZfgs()));
                        }
                    }else if ("103".equals(code)) {//分公司
                        BigDecimal je = rs.getBigDecimal("je");
                        logger.info("g9103产值：{}",je);
                        if (je != null) {
                            outputValYearDistributeDTO.setZfdw(je.add(outputValYearDistributeDTO.getZfdw()));
                        }
                    }else if ("104".equals(code)) {//项目部
                        BigDecimal je = rs.getBigDecimal("je");
                        logger.info("g9104产值：{}",je);
                            if (je != null) {
                                outputValYearDistributeDTO.setZjgc(je.add(outputValYearDistributeDTO.getZjgc()));
                            }
                    }
                }

            }
            con.close();
        } catch(SQLException e) {
            logger.info("请输入正确的表名"+e+".连接失败2");
        }

        return CommonResponse.success("获取数据成功！",outputValYearDistributeDTO);
    }


}
