package com.ejianc.business.worklog.mapper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.worklog.vo.DepartmentLogDetailVO;
import com.ejianc.business.worklog.vo.WorkTypeVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.worklog.bean.PersonLogEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 工作日志-个人工作日志
 *
 * @author generator
 */
@Mapper
public interface PersonLogMapper extends BaseCrudMapper<PersonLogEntity> {
    /**
     * 根据日期查看个人日志
     *
     * @param startDate
     * @param endDate
     * @return
     */
    Page<DepartmentLogDetailVO> getPersonLogByDate(Page<DepartmentLogDetailVO> page,
                                                   @Param("startDate") String startDate,
                                                   @Param("endDate") String endDate,
                                                   @Param("departmentId") Long departmentId,
                                                   @Param("workTypeId") Long workTypeId);

    /**
     * 查询工作分类tree
     *
     * @param params
     * @return
     */
    List<WorkTypeVO> queryWorkTypeTree(Map<String, Object> params);
}
