package com.ejianc.business.worklog.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.worklog.bean.*;
import com.ejianc.business.worklog.enums.PlanSourceTypeEnum;
import com.ejianc.business.worklog.service.IWorkPlanLogService;
import com.ejianc.business.worklog.service.IWorkPlanPersonService;
import com.ejianc.business.worklog.service.IWorkPlanService;
import com.ejianc.business.worklog.service.IWorkPlanTaskService;
import com.ejianc.framework.core.kit.collection.ListUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.List;

@Service("workPlanLog") 
public class WorkPlanLogBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());


	@Autowired
	private IWorkPlanService workPlanService;

	@Autowired
	private IWorkPlanPersonService workPlanPersonService;

	@Autowired
	private IWorkPlanLogService workPlanLogService;

	@Autowired
	private IWorkPlanTaskService workPlanTaskService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO

		WorkPlanLogEntity workPlanLogEntity = workPlanLogService.selectById(billId);
		String sourceType = workPlanLogEntity.getSourceType();
		Long planId = workPlanLogEntity.getPlanId();
		Long taskId = workPlanLogEntity.getTaskId();
		/**
		 * 推送个人任务
		 */

		WorkPlanTaskEntity workPlanTaskEntity = workPlanTaskService.selectById(taskId);
		if(workPlanTaskEntity != null){
			workPlanTaskEntity.setFinishDate(workPlanLogEntity.getServiceDate());
			workPlanTaskEntity.setFinishFlag(workPlanLogEntity.getFinishFlag());
			workPlanTaskEntity.setFinishRemark(workPlanLogEntity.getRemark()+"/t——"+workPlanLogEntity.getDutyPersonName());
			workPlanTaskService.saveOrUpdate(workPlanTaskEntity);
		}
		if(PlanSourceTypeEnum.个人计划.getStatusName().equals(sourceType)){
			/**
			 * 推送个人计划、总计划
			 */
			WorkPlanPersonEntity workPlanPersonEntity = workPlanPersonService.selectById(planId);
			if(workPlanPersonEntity != null){
				workPlanPersonEntity.setFinishDate(workPlanLogEntity.getServiceDate());
				workPlanPersonEntity.setFinishFlag(workPlanLogEntity.getFinishFlag());
				workPlanPersonEntity.setFinishRemark(workPlanLogEntity.getRemark()+"/t——"+workPlanLogEntity.getDutyPersonName());
				workPlanPersonService.saveOrUpdate(workPlanPersonEntity);

				WorkPlanEntity workPlanEntity = workPlanService.selectById(workPlanPersonEntity.getPlanId());
				if(workPlanEntity != null){
					workPlanEntity.setProgressTime(workPlanLogEntity.getServiceDate());
					workPlanEntity.setProgressRemark(workPlanLogEntity.getRemark()+"/t——"+workPlanLogEntity.getDutyPersonName());

					//如果总计划拆分的个人计划均完成，则标记总计划完成
					List<WorkPlanPersonEntity> list = workPlanPersonService.list(Wrappers.<WorkPlanPersonEntity>lambdaQuery()
							.eq(WorkPlanPersonEntity::getPlanId, workPlanPersonEntity.getPlanId())
							.eq(WorkPlanPersonEntity::getFinishFlag,2)
					);
					if(ListUtil.isEmpty(list)){
						workPlanEntity.setFinishFlag("1");
					}
					workPlanService.saveOrUpdate(workPlanEntity);

					return CommonResponse.success();
				} else {
					return CommonResponse.error("未找到["+planId+"]总计划，推送总计划失败!");
				}


			} else {
				return CommonResponse.error("未找到["+planId+"]个人计划，推送个人计划失败!");
			}

		} else if(PlanSourceTypeEnum.总计划.getStatusName().equals(sourceType)){
			/**
			 * 推送总计划
			 */
			WorkPlanEntity workPlanEntity = workPlanService.selectById(planId);
			if(workPlanEntity != null){
				workPlanEntity.setProgressTime(workPlanLogEntity.getServiceDate());
				workPlanEntity.setFinishFlag(workPlanLogEntity.getFinishFlag());
				workPlanEntity.setProgressRemark(workPlanLogEntity.getRemark()+"/t——"+workPlanLogEntity.getDutyPersonName());

				workPlanService.saveOrUpdate(workPlanEntity);

				return CommonResponse.success();
			} else {
				return CommonResponse.error("未找到["+planId+"]总计划，推送总计划失败!");
			}
		}
		return CommonResponse.error("存在数据为空！");
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
