package com.ejianc.business.outputvalcount.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.outputvalcount.service.IEsService;
import com.ejianc.business.outputvalcount.utils.Base64Method;
import com.ejianc.business.outputvalcount.vo.*;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import java.net.URLEncoder;

import com.ejianc.framework.core.util.Utils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.*;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @Author sunxy
 * @Date 22/7/14 11:37
 */
@RestController
@RequestMapping("/es/")
public class EsController implements Serializable {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final long serialVersionUID = 1L;

    private final static Integer QUERY_TIMEOUT = 60;

    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private SessionManager sessionManager;
    /**
     * es索引名
     */
    private final static String INDEX_NAME = "srglsghttj";

    @Autowired(required = false)
    private RestHighLevelClient client;

    @Autowired
    private IUserApi userApi;

    /**
     * 施工合同台账
     *
     * @return
     */
    @RequestMapping(value = "esPage", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BidReportVO>> esPage(@RequestBody QueryParam param) {

        int pageNumber = param.getPageIndex();
        int pageSize = param.getPageSize();
        Map<String, Parameter> params = param.getParams();

        IPage<BidReportVO> page = new Page<>();
        SearchRequest searchRequest = new SearchRequest(INDEX_NAME);
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();

        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        //等于
        //boolQuery.must(QueryBuilders.termQuery("tenantId", InvocationInfoProxy.getTenantid().toString()));

        if (StringUtils.isNotBlank(param.getSearchText())) {
            QueryBuilder qb1 = QueryBuilders.matchQuery("contractName", param.getSearchText());
            QueryBuilder qb2 = QueryBuilders.matchQuery("supplierName", param.getSearchText());
            QueryBuilder qb3 = QueryBuilders.matchQuery("pName", param.getSearchText());
            QueryBuilder qb4 = QueryBuilders.matchQuery("billCode", param.getSearchText());
            boolQuery.must(QueryBuilders.boolQuery().should(qb1).should(qb2).should(qb3).should(qb4));
        }


//        List<String> orgIdS = new ArrayList<>();
//        List<OrgVO> orgVOS = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData();
//        if (orgVOS != null && orgVOS.size() > 0) {
//            for (OrgVO vo : orgVOS) {
//                orgIdS.add(String.valueOf(vo.getId()));
//            }
//        }
//        //in搜索
//        boolQuery.must(QueryBuilders.termsQuery("orgId", orgIdS));


        if (params != null && params.size() > 0) {
            //多字段模糊搜索
//            String searchText = getParamValue(params, "searchText");
//            if (StringUtils.isNotBlank(searchText)) {
//                QueryBuilder qb1 = QueryBuilders.matchQuery("contractname", searchText);
//                QueryBuilder qb2 = QueryBuilders.matchQuery("suppliername", searchText);
//                boolQuery.must(QueryBuilders.boolQuery().should(qb1).should(qb2));
//                params.remove("searchText");
//            }

//            String orgId = getParamValue(params, "orgId");
//            List<String> orgIdS = new ArrayList<>();
//            if (StringUtils.isNotBlank(orgId)) {
//            //按指定组织查询
//                orgIdS = Arrays.asList(orgId.split(","));
//                params.remove("orgId");
//
//            } else {
//                List<OrgVO> orgVOS = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData();
//                if (orgVOS != null && orgVOS.size() > 0) {
//                    for (OrgVO vo : orgVOS) {
//                        orgIdS.add(String.valueOf(vo.getId()));
//                    }
//                }
//            }
//            //in搜索
//            boolQuery.must(QueryBuilders.termsQuery("orgId", orgIdS));

            String contractId = getParamValue(params, "aId");
            if (StringUtils.isNotBlank(contractId)) {
                //按指定合同id查询
                boolQuery.must(QueryBuilders.termQuery("aId", contractId));
                params.remove("aId");

            }
            String projectid = getParamValue(params, "pId");
            if (StringUtils.isNotBlank(projectid)) {
                //按指定项目id查询
                boolQuery.must(QueryBuilders.termQuery("pId", projectid));
                params.remove("pId");

            }

            String orgId = getParamValue(params, "orgId");
            if (StringUtils.isNotBlank(orgId)) {
                //按指定项目id查询
                boolQuery.must(QueryBuilders.termQuery("orgId", orgId));
                params.remove("orgId");

            } else {
                List<String> orgIdS = new ArrayList<>();
                List<OrgVO> orgVOS = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData();
                if (orgVOS != null && orgVOS.size() > 0) {
                    for (OrgVO vo : orgVOS) {
                        orgIdS.add(String.valueOf(vo.getId()));
                    }
                }
                //in搜索
                boolQuery.must(QueryBuilders.termsQuery("orgId", orgIdS));
            }
            //其他多选检索
//            String xxx = getParamValue(params, "xxx");
//            if (StringUtils.isNotBlank(xxx)){
//                params.remove("xxx");
//                boolQuery.must(QueryBuilders.termsQuery("xxx",  Arrays.asList(xxx.split(","))));
//            }


            //日期范围搜索
//            String startDate = getParamValue(params, "startDate");
//            String endDate = getParamValue(params, "endDate");
//            if (startDate != null || endDate != null) {
//                RangeQueryBuilder settlementDate = QueryBuilders.rangeQuery("billDate");
//                if (startDate != null) {
//                    params.remove("startDate");
//                    settlementDate.gte(startDate);
//                }
//                if (endDate != null) {
//                    params.remove("endDate");
//                    settlementDate.lte(endDate);
//                }
//                boolQuery.must(settlementDate);
//            }
            //
            //其他单字段模糊搜索
            for (Map.Entry<String, Parameter> p : params.entrySet()) {
                String key = p.getKey();
                String value = getParamValue(params, key);
                if (StringUtils.isBlank(value)) {
                    continue;
                }
                boolQuery.must(QueryBuilders.matchQuery(key, value));
            }
        } else {
            List<String> orgIdS = new ArrayList<>();
            List<OrgVO> orgVOS = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData();
            if (orgVOS != null && orgVOS.size() > 0) {
                for (OrgVO vo : orgVOS) {
                    orgIdS.add(String.valueOf(vo.getId()));
                }
            }
            //in搜索
            boolQuery.must(QueryBuilders.termsQuery("orgId", orgIdS));
        }


        //根据分页条件设置查询范围
        sourceBuilder.from(pageNumber <= 0 ? 0 : (pageNumber - 1) * pageSize);
        sourceBuilder.size(pageSize);
        sourceBuilder.query(boolQuery);

        //排序
        LinkedHashMap<String, String> orderMap = param.getOrderMap();
        if (orderMap.size() > 0) {
            for (Map.Entry<String, String> entry : orderMap.entrySet()) {
                if (SortOrder.ASC.toString().equalsIgnoreCase(entry.getValue())) {
                    sourceBuilder.sort(entry.getKey(), SortOrder.ASC);
                } else {
                    sourceBuilder.sort(entry.getKey(), SortOrder.DESC);
                }
            }
        }

//        sourceBuilder.trackTotalHits(true);
//        sourceBuilder.timeout(new TimeValue(QUERY_TIMEOUT, TimeUnit.SECONDS)); //设置超时时间
        searchRequest.source(sourceBuilder);
        logger.info("打印查询参数   sourceBuilder------------------：" + JSON.toJSONString(sourceBuilder));

        try {
            List<BidReportVO> list = new ArrayList<>();
            //查询及转换
            SearchResponse response = client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits hits = response.getHits();
            for (SearchHit hit : hits) {
                String sourceAsString = hit.getSourceAsString();
                //logger.info("----------------ES获取数据为--------------：{}",sourceAsString);
                list.add(JSON.parseObject(sourceAsString, BidReportVO.class));
            }
            //TODO 如需要可对数据进行二次加工处理

            page.setCurrent(pageNumber);
            page.setSize(pageSize);


            //查询结果
            page.setRecords(list);
            //总条数
            page.setTotal(hits.getTotalHits().value);
        } catch (IOException e) {
            logger.error(e.getMessage());
            throw new BusinessException("根据 parammap 条件，查询全部记录索引失败，MSG：" + e.getMessage());
        }
        return CommonResponse.success("查询成功！", page);
    }


    /**
     * 设备临工、临机、临材合同
     *
     * @return
     */
    @RequestMapping(value = "sbPage", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MaterialReportVO>> sbPage(@RequestBody QueryParam param) {

        int pageNumber = param.getPageIndex();
        int pageSize = param.getPageSize();
        Map<String, Parameter> params = param.getParams();

        IPage<MaterialReportVO> page = new Page<>();
        SearchRequest searchRequest = new SearchRequest("lxfy_lgljlcls");
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();

        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        //等于
        //boolQuery.must(QueryBuilders.termQuery("tenantId", InvocationInfoProxy.getTenantid().toString()));

        if (StringUtils.isNotBlank(param.getSearchText())) {
            QueryBuilder qb1 = QueryBuilders.matchQuery("orgName", param.getSearchText());
            QueryBuilder qb2 = QueryBuilders.matchQuery("projectCode", param.getSearchText());
            QueryBuilder qb3 = QueryBuilders.matchQuery("projectName", param.getSearchText());
            QueryBuilder qb4 = QueryBuilders.matchQuery("ywLxname", param.getSearchText());
            boolQuery.must(QueryBuilders.boolQuery().should(qb1).should(qb2).should(qb3).should(qb4));
        }

        List<String> orgIdS = new ArrayList<>();
        List<OrgVO> orgVOS = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData();
        if (orgVOS != null && orgVOS.size() > 0) {
            for (OrgVO vo : orgVOS) {
                orgIdS.add(String.valueOf(vo.getId()));
            }
        }
        //in搜索
        boolQuery.must(QueryBuilders.termsQuery("orgId", orgIdS));
        if (params != null && params.size() > 0) {
            //多字段模糊搜索
//            String searchText = getParamValue(params, "searchText");
//            if (StringUtils.isNotBlank(searchText)) {
//                QueryBuilder qb1 = QueryBuilders.matchQuery("contractname", searchText);
//                QueryBuilder qb2 = QueryBuilders.matchQuery("suppliername", searchText);
//                boolQuery.must(QueryBuilders.boolQuery().should(qb1).should(qb2));
//                params.remove("searchText");
//            }

//            String orgId = getParamValue(params, "orgId");
//            List<String> orgIdS = new ArrayList<>();
//            if (StringUtils.isNotBlank(orgId)) {
//                //按指定组织查询
//                //orgIdS = Arrays.asList(orgId.split(","));
//                List<OrgVO> orgVOS = orgApi.findChildrenByParentId(Long.valueOf(orgId)).getData();
//                if (orgVOS != null && orgVOS.size() > 0) {
//                    for (OrgVO vo : orgVOS) {
//                        orgIdS.add(String.valueOf(vo.getId()));
//                    }
//                }
//                params.remove("orgId");
//                //in搜索
//                boolQuery.must(QueryBuilders.termsQuery("orgId", orgIdS));
//            }
//            else {
//                List<OrgVO> orgVOS = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData();
//                if (orgVOS != null && orgVOS.size() > 0) {
//                    for (OrgVO vo : orgVOS) {
//                        orgIdS.add(String.valueOf(vo.getId()));
//                    }
//                }
//            }


//            String contractId = getParamValue(params, "billId");
//            if (StringUtils.isNotBlank(contractId)) {
//                //按指定合同id查询
//                boolQuery.must(QueryBuilders.termQuery("billId", contractId));
//                params.remove("billId");
//
//            }

            String ywLx = getParamValue(params, "ywLx");
            if (StringUtils.isNotBlank(ywLx)) {
                //按指定业务类型查询
                boolQuery.must(QueryBuilders.termQuery("ywLx", ywLx));
                params.remove("ywLx");

            }

            String projectid = getParamValue(params, "projectId");
            if (StringUtils.isNotBlank(projectid)) {
                //按指定项目id查询
                boolQuery.must(QueryBuilders.termQuery("projectId", projectid));
                params.remove("projectId");

            }
            //其他多选检索
//            String xxx = getParamValue(params, "xxx");
//            if (StringUtils.isNotBlank(xxx)){
//                params.remove("xxx");
//                boolQuery.must(QueryBuilders.termsQuery("xxx",  Arrays.asList(xxx.split(","))));
//            }


            //日期范围搜索
            String ywDate = getParamValue(params, "ywDate");
            // String endDate = getParamValue(params, "endDate");
            if (ywDate != null) {
                RangeQueryBuilder settlementDate = QueryBuilders.rangeQuery("ywDate");
                List<String> dateList = Arrays.asList(ywDate.split(","));
                params.remove("ywDate");
                if (dateList.size() >= 2) {
                    settlementDate.gte(dateList.get(0));
                    settlementDate.lte(dateList.get(1));
                    boolQuery.must(settlementDate);
                }
            }
            //
            //其他单字段模糊搜索
            for (Map.Entry<String, Parameter> p : params.entrySet()) {
                String key = p.getKey();
                String value = getParamValue(params, key);
                if (StringUtils.isBlank(value)) {
                    continue;
                }
                boolQuery.must(QueryBuilders.matchQuery(key, value));
            }
        }


        //根据分页条件设置查询范围
        sourceBuilder.from(pageNumber <= 0 ? 0 : (pageNumber - 1) * pageSize);
        sourceBuilder.size(pageSize);
        sourceBuilder.query(boolQuery);

        //排序
        LinkedHashMap<String, String> orderMap = param.getOrderMap();
        if (orderMap.size() > 0) {
            for (Map.Entry<String, String> entry : orderMap.entrySet()) {
                if (SortOrder.ASC.toString().equalsIgnoreCase(entry.getValue())) {
                    sourceBuilder.sort(entry.getKey(), SortOrder.ASC);
                } else {
                    sourceBuilder.sort(entry.getKey(), SortOrder.DESC);
                }
            }
        }

//        sourceBuilder.trackTotalHits(true);
//        sourceBuilder.timeout(new TimeValue(QUERY_TIMEOUT, TimeUnit.SECONDS)); //设置超时时间
        searchRequest.source(sourceBuilder);
        logger.info("打印查询参数   sourceBuilder------------------：" + JSON.toJSONString(sourceBuilder));

        try {
            List<MaterialReportVO> list = new ArrayList<>();
            //查询及转换
            SearchResponse response = client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits hits = response.getHits();
            for (SearchHit hit : hits) {
                String sourceAsString = hit.getSourceAsString();
                //logger.info("----------------ES获取数据为--------------：{}",sourceAsString);
                list.add(JSON.parseObject(sourceAsString, MaterialReportVO.class));
            }
            //TODO 如需要可对数据进行二次加工处理

            page.setCurrent(pageNumber);
            page.setSize(pageSize);
            //查询结果
            page.setRecords(list);
            //总条数
            page.setTotal(hits.getTotalHits().value);
        } catch (IOException e) {
            logger.error(e.getMessage());
            throw new BusinessException("根据 parammap 条件，查询全部记录索引失败，MSG：" + e.getMessage());
        }
        return CommonResponse.success("查询成功！", page);
    }


    /**
     * 支出合同
     *
     * @return
     */
    @RequestMapping(value = "zcPage", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ZcReportVO>> zcPage(@RequestBody QueryParam param) {

        int pageNumber = param.getPageIndex();
        int pageSize = param.getPageSize();
        Map<String, Parameter> params = param.getParams();

        IPage<ZcReportVO> page = new Page<>();
        SearchRequest searchRequest = new SearchRequest("ex_contractt");
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();

        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        //等于
        //boolQuery.must(QueryBuilders.termQuery("tenantId", InvocationInfoProxy.getTenantid().toString()));

        if (StringUtils.isNotBlank(param.getSearchText())) {
            QueryBuilder qb1 = QueryBuilders.matchQuery("contractName", param.getSearchText());
            QueryBuilder qb2 = QueryBuilders.matchQuery("supplierName", param.getSearchText());
            QueryBuilder qb3 = QueryBuilders.matchQuery("projectName", param.getSearchText());
            QueryBuilder qb4 = QueryBuilders.matchQuery("billCode", param.getSearchText());

            QueryBuilder qb5 = QueryBuilders.matchQuery("partyName", param.getSearchText());
            QueryBuilder qb6 = QueryBuilders.matchQuery("categorypName", param.getSearchText());
            QueryBuilder qb7 = QueryBuilders.matchQuery("categoryName", param.getSearchText());

            boolQuery.must(QueryBuilders.boolQuery().should(qb1).should(qb2).should(qb3).should(qb4).should(qb5).should(qb6).should(qb7));
        }

//        List<String> orgIdS = new ArrayList<>();
//        List<OrgVO> orgVOS = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData();
//        if (orgVOS != null && orgVOS.size() > 0) {
//            for (OrgVO vo : orgVOS) {
//                orgIdS.add(String.valueOf(vo.getId()));
//            }
//        }
//        //in搜索
//        boolQuery.must(QueryBuilders.termsQuery("orgId", orgIdS));

        if (params != null && params.size() > 0) {
            //多字段模糊搜索
//            String searchText = getParamValue(params, "searchText");
//            if (StringUtils.isNotBlank(searchText)) {
//                QueryBuilder qb1 = QueryBuilders.matchQuery("contractname", searchText);
//                QueryBuilder qb2 = QueryBuilders.matchQuery("suppliername", searchText);
//                boolQuery.must(QueryBuilders.boolQuery().should(qb1).should(qb2));
//                params.remove("searchText");
//            }

//            String orgId = getParamValue(params, "orgId");
//            List<String> orgIdS = new ArrayList<>();
//            if (StringUtils.isNotBlank(orgId)) {
//                //按指定组织查询
//                orgIdS = Arrays.asList(orgId.split(","));
//                params.remove("orgId");
//
//            } else {
//                List<OrgVO> orgVOS = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData();
//                if (orgVOS != null && orgVOS.size() > 0) {
//                    for (OrgVO vo : orgVOS) {
//                        orgIdS.add(String.valueOf(vo.getId()));
//                    }
//                }
//            }
//            //in搜索
//            boolQuery.must(QueryBuilders.termsQuery("orgId", orgIdS));

            String contractId = getParamValue(params, "billId");
            if (StringUtils.isNotBlank(contractId)) {
                //按指定合同id查询
                boolQuery.must(QueryBuilders.termQuery("billId", contractId));
                params.remove("billId");

            }
            String projectid = getParamValue(params, "projectId");
            if (StringUtils.isNotBlank(projectid)) {
                //按指定项目id查询
                boolQuery.must(QueryBuilders.termQuery("projectId", projectid));
                params.remove("projectId");

            }

            String orgId = getParamValue(params, "orgId");
            if (StringUtils.isNotBlank(orgId)) {
                //按指定项目id查询
                boolQuery.must(QueryBuilders.termQuery("orgId", orgId));
                params.remove("orgId");

            } else {
                List<String> orgIdS = new ArrayList<>();
                List<OrgVO> orgVOS = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData();
                if (orgVOS != null && orgVOS.size() > 0) {
                    for (OrgVO vo : orgVOS) {
                        orgIdS.add(String.valueOf(vo.getId()));
                    }
                }
                //in搜索
                boolQuery.must(QueryBuilders.termsQuery("orgId", orgIdS));
            }

            String categoryPid = getParamValue(params, "categoryPid");
            if(StringUtils.isNotBlank(categoryPid)){
                params.remove("categoryPid");
                logger.info("categoryPid{}",JSON.toJSONString(Arrays.asList(categoryPid.split(","))));
                boolQuery.must(QueryBuilders.termsQuery("categoryPid", Arrays.asList(categoryPid.split(","))));

            }
            //其他多选检索
//            String xxx = getParamValue(params, "xxx");
//            if (StringUtils.isNotBlank(xxx)){
//                params.remove("xxx");
//                boolQuery.must(QueryBuilders.termsQuery("xxx",  Arrays.asList(xxx.split(","))));
//            }


            //日期范围搜索
//            String startDate = getParamValue(params, "startDate");
//            String endDate = getParamValue(params, "endDate");
//            if (startDate != null || endDate != null) {
//                RangeQueryBuilder settlementDate = QueryBuilders.rangeQuery("billDate");
//                if (startDate != null) {
//                    params.remove("startDate");
//                    settlementDate.gte(startDate);
//                }
//                if (endDate != null) {
//                    params.remove("endDate");
//                    settlementDate.lte(endDate);
//                }
//                boolQuery.must(settlementDate);
//            }
            //
            //其他单字段模糊搜索
            for (Map.Entry<String, Parameter> p : params.entrySet()) {
                String key = p.getKey();
                String value = getParamValue(params, key);
                if (StringUtils.isBlank(value)) {
                    continue;
                }
                boolQuery.must(QueryBuilders.matchQuery(key, value));
            }
        } else {
            List<String> orgIdS = new ArrayList<>();
            List<OrgVO> orgVOS = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData();
            if (orgVOS != null && orgVOS.size() > 0) {
                for (OrgVO vo : orgVOS) {
                    orgIdS.add(String.valueOf(vo.getId()));
                }
            }
            //in搜索
            boolQuery.must(QueryBuilders.termsQuery("orgId", orgIdS));
        }


        //根据分页条件设置查询范围
        sourceBuilder.from(pageNumber <= 0 ? 0 : (pageNumber - 1) * pageSize);
        sourceBuilder.size(pageSize);
        sourceBuilder.query(boolQuery);

        //排序
        LinkedHashMap<String, String> orderMap = param.getOrderMap();
        if (orderMap.size() > 0) {
            for (Map.Entry<String, String> entry : orderMap.entrySet()) {
                if (SortOrder.ASC.toString().equalsIgnoreCase(entry.getValue())) {
                    sourceBuilder.sort(entry.getKey(), SortOrder.ASC);
                } else {
                    sourceBuilder.sort(entry.getKey(), SortOrder.DESC);
                }
            }
        }

//        sourceBuilder.trackTotalHits(true);
//        sourceBuilder.timeout(new TimeValue(QUERY_TIMEOUT, TimeUnit.SECONDS)); //设置超时时间
        searchRequest.source(sourceBuilder);
        logger.info("打印查询参数   sourceBuilder------------------：" + JSON.toJSONString(sourceBuilder));

        try {
            List<ZcReportVO> list = new ArrayList<>();
            //查询及转换
            SearchResponse response = client.search(searchRequest, RequestOptions.DEFAULT);
            logger.info("----------------response获取数据为--------------：{}", JSON.toJSONString(response));
            SearchHits hits = response.getHits();
            for (SearchHit hit : hits) {
                String sourceAsString = hit.getSourceAsString();
                //logger.info("----------------ES获取数据为--------------：{}",sourceAsString);
                list.add(JSON.parseObject(sourceAsString, ZcReportVO.class));
            }
            //TODO 如需要可对数据进行二次加工处理


//            for (int i = 0; i < list.size() - 1; i++) {
//                for (int j = list.size() - 1; j > i; j--) {
//                    if (list.get(j).getBillid().equals(list.get(i).getBillid())) {
//                        list.remove(j);// 删除重复元素
//                    }
//                }
//            }
            page.setCurrent(pageNumber);
            page.setSize(pageSize);
            //查询结果
            page.setRecords(list);
            //总条数
            page.setTotal(hits.getTotalHits().value);
        } catch (IOException e) {
            logger.error(e.getMessage());
            throw new BusinessException("根据 parammap 条件，查询全部记录索引失败，MSG：" + e.getMessage());
        }
//        /**
//         * 本地测试无es环境
//         */
//        //测试
//        page.setCurrent(pageNumber);
//        page.setSize(pageSize);
//        //查询结果
//        page.setRecords(null);
//        //总条数
//        page.setTotal(0);
//        /**
//         * 测试结束
//         */
        return CommonResponse.success("查询成功！", page);
    }


    /**
     * 工人工资发放
     *
     * @return
     */
    @RequestMapping(value = "gzffPage", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SalaryReportVO>> gzffPage(@RequestBody QueryParam param) {

        int pageNumber = param.getPageIndex();
        int pageSize = param.getPageSize();
        Map<String, Parameter> params = param.getParams();

        IPage<SalaryReportVO> page = new Page<>();
        SearchRequest searchRequest = new SearchRequest("profinance_salary");
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();

        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        //等于
        //boolQuery.must(QueryBuilders.termQuery("tenantId", InvocationInfoProxy.getTenantid().toString()));

        if (StringUtils.isNotBlank(param.getSearchText())) {
            QueryBuilder qb1 = QueryBuilders.matchQuery("salaryBillCode", param.getSearchText());
            QueryBuilder qb2 = QueryBuilders.matchQuery("projectName", param.getSearchText());
            QueryBuilder qb3 = QueryBuilders.matchQuery("groupName", param.getSearchText());
            QueryBuilder qb4 = QueryBuilders.matchQuery("contractCode", param.getSearchText());

            QueryBuilder qb5 = QueryBuilders.matchQuery("contractName", param.getSearchText());
            QueryBuilder qb6 = QueryBuilders.matchQuery("workerIdCard", param.getSearchText());
            QueryBuilder qb7 = QueryBuilders.matchQuery("workerName", param.getSearchText());

            boolQuery.must(QueryBuilders.boolQuery().should(qb1).should(qb2).should(qb3).should(qb4).should(qb5).should(qb6).should(qb7));
        }

//        List<String> orgIdS = new ArrayList<>();
//        List<OrgVO> orgVOS = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData();
//        if (orgVOS != null && orgVOS.size() > 0) {
//            for (OrgVO vo : orgVOS) {
//                orgIdS.add(String.valueOf(vo.getId()));
//            }
//        }
        //in搜索
        //boolQuery.must(QueryBuilders.termsQuery("orgId", orgIdS));

        if (params != null && params.size() > 0) {


            String workerIdCard = getParamValue(params, "workerIdCard");
            if (StringUtils.isNotBlank(workerIdCard)) {
                //按指定身份证号查询
                boolQuery.must(QueryBuilders.matchPhrasePrefixQuery("workerIdCard", workerIdCard));
                //boolQuery.must(QueryBuilders.termQuery("workerIdCard", workerIdCard));
                params.remove("workerIdCard");

            }

            String contractId = getParamValue(params, "contractId");
            if (StringUtils.isNotBlank(contractId)) {
                //按指定合同id查询
                boolQuery.must(QueryBuilders.termQuery("contractId", contractId));
                params.remove("contractId");

            }

            String projectId = getParamValue(params, "projectId");
            if (StringUtils.isNotBlank(projectId)) {
                //按指定合同id查询
                boolQuery.must(QueryBuilders.termQuery("projectId", projectId));
                params.remove("projectId");

            }
            //其他单字段模糊搜索
            for (Map.Entry<String, Parameter> p : params.entrySet()) {
                String key = p.getKey();
                String value = getParamValue(params, key);
                if (StringUtils.isBlank(value)) {
                    continue;
                }
                boolQuery.must(QueryBuilders.matchQuery(key, value));
            }
        }


        //根据分页条件设置查询范围
        sourceBuilder.from(pageNumber <= 0 ? 0 : (pageNumber - 1) * pageSize);
        sourceBuilder.size(pageSize);
        sourceBuilder.query(boolQuery);

        //排序
        LinkedHashMap<String, String> orderMap = param.getOrderMap();
        if (orderMap.size() > 0) {
            for (Map.Entry<String, String> entry : orderMap.entrySet()) {
                if (SortOrder.ASC.toString().equalsIgnoreCase(entry.getValue())) {
                    sourceBuilder.sort(entry.getKey(), SortOrder.ASC);
                } else {
                    sourceBuilder.sort(entry.getKey(), SortOrder.DESC);
                }
            }
        }

        searchRequest.source(sourceBuilder);
        logger.info("打印查询参数   sourceBuilder------------------：" + JSON.toJSONString(sourceBuilder));

        try {
            List<SalaryReportVO> list = new ArrayList<>();
            //查询及转换
            SearchResponse response = client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits hits = response.getHits();
            for (SearchHit hit : hits) {
                String sourceAsString = hit.getSourceAsString();
                //logger.info("----------------ES获取数据为--------------：{}",sourceAsString);
                list.add(JSON.parseObject(sourceAsString, SalaryReportVO.class));
            }
            //TODO 如需要可对数据进行二次加工处理

            page.setCurrent(pageNumber);
            page.setSize(pageSize);
            //查询结果
            page.setRecords(list);
            //总条数
            page.setTotal(hits.getTotalHits().value);
        } catch (IOException e) {
            logger.error(e.getMessage());
            throw new BusinessException("根据 parammap 条件，查询全部记录索引失败，MSG：" + e.getMessage());
        }
        return CommonResponse.success("查询成功！", page);
    }


    /**
     * 工人工资
     *
     * @return
     */
    @RequestMapping(value = "gzPage", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ProfinanceReportVO>> gzPage(@RequestBody QueryParam param) {

        int pageNumber = param.getPageIndex();
        int pageSize = param.getPageSize();
        Map<String, Parameter> params = param.getParams();

        IPage<ProfinanceReportVO> page = new Page<>();
        SearchRequest searchRequest = new SearchRequest("labor_sumsalary");
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();

        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        //等于
        //boolQuery.must(QueryBuilders.termQuery("tenantId", InvocationInfoProxy.getTenantid().toString()));

        if (StringUtils.isNotBlank(param.getSearchText())) {
            QueryBuilder qb1 = QueryBuilders.matchQuery("projectCode", param.getSearchText());
            QueryBuilder qb2 = QueryBuilders.matchQuery("projectName", param.getSearchText());
            QueryBuilder qb3 = QueryBuilders.matchQuery("orgName", param.getSearchText());
            QueryBuilder qb4 = QueryBuilders.matchQuery("contractCode", param.getSearchText());

            QueryBuilder qb5 = QueryBuilders.matchQuery("contractName", param.getSearchText());
            QueryBuilder qb6 = QueryBuilders.matchQuery("workerIdCard", param.getSearchText());
            QueryBuilder qb7 = QueryBuilders.matchQuery("workerName", param.getSearchText());

            boolQuery.must(QueryBuilders.boolQuery().should(qb1).should(qb2).should(qb3).should(qb4).should(qb5).should(qb6).should(qb7));
        }

        List<String> orgIdS = new ArrayList<>();
        List<OrgVO> orgVOS = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData();
        if (orgVOS != null && orgVOS.size() > 0) {
            for (OrgVO vo : orgVOS) {
                orgIdS.add(String.valueOf(vo.getId()));
            }
        }
        //in搜索
        boolQuery.filter(QueryBuilders.termsQuery("orgId", orgIdS));

        if (params != null && params.size() > 0) {


            String workerIdCard = getParamValue(params, "workerIdCard");
            if (StringUtils.isNotBlank(workerIdCard)) {
                //按指定合同id查询
                boolQuery.must(QueryBuilders.termQuery("workerIdCard", workerIdCard));
                params.remove("workerIdCard");

            }

            String contractId = getParamValue(params, "contractId");
            if (StringUtils.isNotBlank(contractId)) {
                //按指定合同id查询
                boolQuery.must(QueryBuilders.termQuery("contractId", contractId));
                params.remove("contractId");

            }

            String projectId = getParamValue(params, "projectId");
            if (StringUtils.isNotBlank(projectId)) {
                //按指定合同id查询
                boolQuery.must(QueryBuilders.termQuery("projectId", projectId));
                params.remove("projectId");

            }

            //其他单字段模糊搜索
            for (Map.Entry<String, Parameter> p : params.entrySet()) {
                String key = p.getKey();
                String value = getParamValue(params, key);
                if (StringUtils.isBlank(value)) {
                    continue;
                }
                boolQuery.must(QueryBuilders.matchQuery(key, value));
            }
        }


        //根据分页条件设置查询范围
        sourceBuilder.from(pageNumber <= 0 ? 0 : (pageNumber - 1) * pageSize);
        sourceBuilder.size(pageSize);
        sourceBuilder.query(boolQuery);

        //排序
        LinkedHashMap<String, String> orderMap = param.getOrderMap();
        if (orderMap.size() > 0) {
            for (Map.Entry<String, String> entry : orderMap.entrySet()) {
                if (SortOrder.ASC.toString().equalsIgnoreCase(entry.getValue())) {
                    sourceBuilder.sort(entry.getKey(), SortOrder.ASC);
                } else {
                    sourceBuilder.sort(entry.getKey(), SortOrder.DESC);
                }
            }
        }

        searchRequest.source(sourceBuilder);
        logger.info("打印查询参数   sourceBuilder------------------：" + JSON.toJSONString(sourceBuilder));

        try {
            List<ProfinanceReportVO> list = new ArrayList<>();
            //查询及转换
            SearchResponse response = client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits hits = response.getHits();
            for (SearchHit hit : hits) {
                String sourceAsString = hit.getSourceAsString();
                //logger.info("----------------ES获取数据为--------------：{}",sourceAsString);
                list.add(JSON.parseObject(sourceAsString, ProfinanceReportVO.class));
            }
            //TODO 如需要可对数据进行二次加工处理

            page.setCurrent(pageNumber);
            page.setSize(pageSize);
            //查询结果
            page.setRecords(list);
            //总条数
            page.setTotal(hits.getTotalHits().value);
        } catch (IOException e) {
            logger.error(e.getMessage());
            throw new BusinessException("根据 parammap 条件，查询全部记录索引失败，MSG：" + e.getMessage());
        }
        return CommonResponse.success("查询成功！", page);
    }


    private String getParamValue(Map<String, Parameter> params, String paramKey) {
        if (params.get(paramKey) != null) {
            Object value = params.get(paramKey).getValue();
            return value != null ? String.valueOf(value) : null;
        }
        return null;
    }


    public static void main(String[] args) {
        String ywDate = "2022-07-01,2022-07-31";
        List<String> dateList = Arrays.asList(ywDate.split(","));
        for (String s : dateList) {
            System.out.println(s);
        }
    }


    @Autowired
    private IEsService esService;

    /**
     * 工人工资
     *
     * @return 结算明细、支付明细、
     */
    @RequestMapping(value = "queryDetailRecord", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SettleDetailVO> queryDetailRecord(Long contractId, Long supplierId, Long projectId) {

        SettleDetailVO settleDetailVO = new SettleDetailVO();

        //查询结算池数据 、、有合同
        if (contractId != null) {

            List<SettlePoolVO> settlePoolVOS = esService.queryDetailRecord(contractId);
            for (int i = 0; i < settlePoolVOS.size(); i++) {
                if ("劳务分包月度结算".equals(settlePoolVOS.get(i).getSettleSourceTypeName())
                        || "专业分包月度结算".equals(settlePoolVOS.get(i).getSettleSourceTypeName())) {
                    settlePoolVOS.remove(i);
                }
            }
            settleDetailVO.setSettlePoolVOList(settlePoolVOS);
            List<PaymentApplyVO> paymentApplyVOS = esService.queryDetailRecord1(contractId);

            //工资支付
            List<PaymentApplyVO> applyVOList = esService.queryApplyTaxMny(contractId);
            paymentApplyVOS.addAll(applyVOList);

            settleDetailVO.setPaymentApplyVOList(paymentApplyVOS);
        } else if (supplierId != null && projectId != null) {
            List<SettlePoolVO> settlePoolVOS = esService.queryDetailRecordNoContract(projectId, supplierId);
            for (int i = 0; i < settlePoolVOS.size(); i++) {
                if ("劳务分包月度结算".equals(settlePoolVOS.get(i).getSettleSourceTypeName())
                        || "专业分包月度结算".equals(settlePoolVOS.get(i).getSettleSourceTypeName())) {
                    settlePoolVOS.remove(i);
                }
            }

            settleDetailVO.setSettlePoolVOList(settlePoolVOS);

            settleDetailVO.setPaymentApplyVOList(esService.queryDetailRecordNoContract1(projectId, supplierId));

        }


        return CommonResponse.success("查询成功！", settleDetailVO);
    }

    /**
     * 企业支出合同总金额、应付金额
     *
     * @param param
     * @return
     */
    @RequestMapping(value = "/queryTotalContract", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryTotalContract(@RequestBody QueryParam param) {
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        //1.获取本下所有orgId
        List<Long> commonOrgIds = new ArrayList<>();
        if (!param.getParams().containsKey("orgId")) {
            Long orgId = InvocationInfoProxy.getOrgId();
            orgVOList = (List<OrgVO>) getRespData(orgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
            //普通组织 id

            orgVOList.stream().forEach(org -> {
                //普通组织
                commonOrgIds.add(org.getId());
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
                param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
            }
            /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        }
        Long tenantId = InvocationInfoProxy.getTenantid();
        //1.本下项目总金额,应付金额 初始为0
        BigDecimal totalMny = BigDecimal.ZERO;
        BigDecimal totalAmountMny = BigDecimal.ZERO;
        //2.遍历所有orgId获取合同总金额
        for (Long orgId : commonOrgIds) {
            //查询该orgId下的合同总金额
            BigDecimal totalContract = esService.totalContract(tenantId, orgId);

            //空值处理
            if (totalContract == null) {
                totalMny = totalMny.add(BigDecimal.ZERO);
            } else {
                totalMny = totalMny.add(totalContract);
            }
            //查询orgId下的实付金额
            BigDecimal AmountMny = esService.queryAmountMny(tenantId, orgId);
            //空值处理
            if (AmountMny == null) {
                totalAmountMny = totalAmountMny.add(BigDecimal.ZERO);
            } else {
                totalAmountMny = totalAmountMny.add(AmountMny);
            }
        }
        JSONObject pageJson = new JSONObject();
        //前端ajax接受参数为totalContract
        pageJson.put("totalContract", totalMny);
        pageJson.put("totalAmountMny", totalAmountMny);
        return CommonResponse.success("查询数据成功！", pageJson);

    }

    /**
     * 人员任职情况报表
     *
     * @return
     */
    @RequestMapping(value = "employeePage", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<EmployeeReportVO>> employeePage(@RequestBody QueryParam param) {
        //1.ES初始化对象
        //分页对象
        IPage<EmployeeReportVO> page = new Page<>();
        int pageNumber = param.getPageIndex();//当前页
        int pageSize = param.getPageSize();//分页条数
        Map<String, Parameter> params = param.getParams();//前端查询参数
        //ES查询对象
        SearchRequest searchRequest = new SearchRequest("employeedeptcx");//索引库
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();

        //2.构建查询条件
        //2.1搜索框搜索词
        if (StringUtils.isNotBlank(param.getSearchText())) {
            MatchQueryBuilder emName = QueryBuilders.matchQuery("emName", param.getSearchText());

            boolQuery.must(emName.operator(Operator.AND));
//            boolQuery.must(QueryBuilders.matchAllQuery());
        }
        //2.2组织隔离
        List<String> orgIdS = new ArrayList<>();
        List<OrgVO> orgVOS = new ArrayList<>();

        //手机端
        if(null != params.get("orgId")){
            Long orgId = Long.valueOf(params.get("orgId").getValue().toString());
            orgVOS = orgApi.findChildrenByParentId(orgId).getData();
            params.remove("orgId");

        }
        //电脑端
        else {
            orgVOS = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData();
        }
        if (orgVOS != null && orgVOS.size() > 0) {
            for (OrgVO vo : orgVOS) {
                orgIdS.add(String.valueOf(vo.getId()));
            }
        }
        boolQuery.filter(QueryBuilders.termsQuery("orgId", orgIdS));
        //2.3查询参数
        //TODO 跳转中携带参数处理


        //2.4其他查询参数进行模糊搜索
        for (Map.Entry<String, Parameter> p : params.entrySet()) {
            String key = p.getKey();
            String value = getParamValue(params, key);
            if (StringUtils.isBlank(value)) {
                continue;
            }
            boolQuery.must(QueryBuilders.matchQuery(key, value));
        }
        //2.5分页
        searchRequest.source().from(pageNumber <= 0 ? 0 : (pageNumber - 1) * pageSize);
        searchRequest.source().size(pageSize);
        searchRequest.source().query(boolQuery);
        //2.6排序
        LinkedHashMap<String, String> orderMap = param.getOrderMap();
        if (orderMap.size() > 0) {
            for (Map.Entry<String, String> entry : orderMap.entrySet()) {
                if (SortOrder.ASC.toString().equalsIgnoreCase(entry.getValue())) {
                    searchRequest.source().sort(entry.getKey(), SortOrder.ASC);
                } else {
                    searchRequest.source().sort(entry.getKey(), SortOrder.DESC);
                }
            }
        }
        //2.7放入查询条件
        searchRequest.source().query(boolQuery);
        //3.发送查询请求
        try {
            SearchResponse response = client.search(searchRequest, RequestOptions.DEFAULT);
            //3.1文档类型转换
            ArrayList<EmployeeReportVO> list = new ArrayList<>();
            SearchHits hits = response.getHits();
            for (SearchHit hit : hits) {
                String sourceAsString = hit.getSourceAsString();
                logger.info("----------------ES获取数据为--------------：{}", sourceAsString);
                list.add(JSON.parseObject(sourceAsString, EmployeeReportVO.class));
                //3.2处理数据
                /**
                 * url etoken生成并放入VO返回
                 */
                for (EmployeeReportVO reportVO : list) {
                    //通过建造师编号查询员工信息
                    CommonResponse<UserVO> userVO = userApi.findUserByUserId(reportVO.getUserID());
                    if (userVO != null) {
                        try {
                            UserVO userVOData = userVO.getData();
                            if (userVOData != null) {
                                String userCode = userVOData.getUserCode();
                                //登录账号+,999912310000
                                userCode = userCode + ",999912310000";
                                //BASE64 GBK编码在URL GBK编码
                                String etoken = URLEncoder.encode(Base64Method.EncryptBase64(userCode), "GBK");
                                String url = "http://hr.zzyjjt.com/templates/index/ssoiframe.jsp?url=/workbench/browse/showselfinfo.do?b_search=link`a0100=A0100`flag=infoself&etoken=" + etoken;
                                //0qa%2FocX0MDkxMCw5OTk5MTIzMTAwMDA%3D
                                reportVO.setUrl(url);
                            }

                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }

                }

                //4.封装pageVO
                page.setCurrent(pageNumber);
                page.setSize(pageSize);
                //查询结果
                page.setRecords(list);
                //总条数
                page.setTotal(hits.getTotalHits().value);
            }
        } catch (IOException e) {
            logger.error(e.getMessage());
            throw new BusinessException("根据 paramMap 条件，查询全部记录索引失败，MSG：" + e.getMessage());

        }

        return CommonResponse.success("查询成功！", page);
    }

    /**
     * 人员任职情况报表
     *
     * @return
     */
    @RequestMapping(value = "queryAllEmployee", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Map<String,String>> queryAllEmployee(@RequestBody QueryParam param) {
        HashMap<String, String> map = new HashMap<>();
        Map<String, Parameter> params = param.getParams();//前端查询参数
        //ES查询对象
        SearchRequest searchRequest = new SearchRequest("employeedeptcx");//索引库
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();

        //2.构建查询条件
        //2.1搜索框搜索词
        if (StringUtils.isNotBlank(param.getSearchText())) {
            MatchQueryBuilder emName = QueryBuilders.matchQuery("emName", param.getSearchText());

            boolQuery.must(emName.operator(Operator.AND));
//            boolQuery.must(QueryBuilders.matchAllQuery());
        }
        //2.2组织隔离
        List<String> orgIdS = new ArrayList<>();
        List<OrgVO> orgVOS = new ArrayList<>();

        //手机端
        if(null != params.get("orgId")){
            Long orgId = Long.valueOf(params.get("orgId").getValue().toString());
            orgVOS = orgApi.findChildrenByParentId(orgId).getData();
            params.remove("orgId");

        }
        //电脑端
        else {
            orgVOS = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData();
        }
        if (orgVOS != null && orgVOS.size() > 0) {
            for (OrgVO vo : orgVOS) {
                orgIdS.add(String.valueOf(vo.getId()));
            }
        }
        boolQuery.filter(QueryBuilders.termsQuery("orgId", orgIdS));
        //2.3查询参数
        //TODO 跳转中携带参数处理


        //2.4其他查询参数进行模糊搜索
        for (Map.Entry<String, Parameter> p : params.entrySet()) {
            String key = p.getKey();
            String value = getParamValue(params, key);
            if (StringUtils.isBlank(value)) {
                continue;
            }
            boolQuery.must(QueryBuilders.matchQuery(key, value));
        }
        //2.5分页
        searchRequest.source().from(0);
        searchRequest.source().size(10000);
        searchRequest.source().query(boolQuery);
        //2.6排序
        LinkedHashMap<String, String> orderMap = param.getOrderMap();
        if (orderMap.size() > 0) {
            for (Map.Entry<String, String> entry : orderMap.entrySet()) {
                if (SortOrder.ASC.toString().equalsIgnoreCase(entry.getValue())) {
                    searchRequest.source().sort(entry.getKey(), SortOrder.ASC);
                } else {
                    searchRequest.source().sort(entry.getKey(), SortOrder.DESC);
                }
            }
        }
        //2.7放入查询条件
        searchRequest.source().query(boolQuery);

        //3.发送查询请求
        try {
            SearchResponse response = client.search(searchRequest, RequestOptions.DEFAULT);
            //3.1文档类型转换
            HashSet<Long> idSet = new HashSet<>();
            SearchHits hits = response.getHits();
            for (SearchHit hit : hits) {
                String sourceAsString = hit.getSourceAsString();
                logger.info("----------------ES获取数据为--------------：{}", sourceAsString);
                EmployeeReportVO employeeReportVO = JSON.parseObject(sourceAsString, EmployeeReportVO.class);
                idSet.add(employeeReportVO.getUserID());
                map.put("value",idSet.size()+"");
            }


        } catch (IOException e) {
            logger.error(e.getMessage());
            throw new BusinessException("根据 paramMap 条件，查询全部记录索引失败，MSG：" + e.getMessage());

        }

        return CommonResponse.success("查询成功！", map);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }




    /**
     * 目标成本利润台账
     *
     * @return
     */
    @RequestMapping(value = "targetLrlPage", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<TargetLrlReportVO>> targetLrlPage(@RequestBody QueryParam param) {
        logger.info("请求参数   param------------------：" + JSON.toJSONString(param));
        int pageNumber = param.getPageIndex();
        int pageSize = param.getPageSize();
        Map<String, Parameter> params = param.getParams();

        IPage<TargetLrlReportVO> page = new Page<>();
        SearchRequest searchRequest = new SearchRequest("target_xmmblrtz");
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();

        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();


        if (StringUtils.isNotBlank(param.getSearchText())) {
            QueryBuilder qb1 = QueryBuilders.matchQuery("pCode", param.getSearchText());
            QueryBuilder qb2 = QueryBuilders.matchQuery("pName", param.getSearchText());
            QueryBuilder qb3 = QueryBuilders.matchQuery("orgName", param.getSearchText());
            QueryBuilder qb4 = QueryBuilders.matchQuery("billCode", param.getSearchText());
            QueryBuilder qb5 = QueryBuilders.matchQuery("porName", param.getSearchText());

            boolQuery.must(QueryBuilders.boolQuery().should(qb1).should(qb2).should(qb3).should(qb4).should(qb5));
        }

        if (params != null && params.size() > 0) {

            String xfllv = getParamValue(params, "xfllv");
            if (StringUtils.isNotBlank(xfllv)) {
                //按指定合同id查询
                boolQuery.must(QueryBuilders.termQuery("xfllv", xfllv));
                params.remove("xfllv");

            }
            String cTime = getParamValue(params, "cTime");
            if (StringUtils.isNotBlank(cTime)) {
                //按指定项目id查询
                boolQuery.must(QueryBuilders.termQuery("cTime", cTime));
                params.remove("cTime");

            }

            String engineeringTypeName = getParamValue(params, "engineeringTypeName");
            if (StringUtils.isNotBlank(engineeringTypeName)) {

                List<String> orgIdS = new ArrayList<>();
                if("房建".equals(engineeringTypeName)){
                    orgIdS.add("1543799043577856001");
                    orgIdS.add("1508279975020908545");
                    orgIdS.add("1508280161793265665");
                    orgIdS.add("1508280244257476610");
                }else if("市政".equals(engineeringTypeName)){
                    orgIdS.add("1506579865592565761");
                    orgIdS.add("1508280612022439938");
                    orgIdS.add("1508280815651704833");
                    orgIdS.add("1508280877136007170");
                    orgIdS.add("1508280929900351489");
                }else {
                    orgIdS.add("1506580163417509890");
                    orgIdS.add("1506580227888156674");
                    orgIdS.add("1506580278014283778");
                    orgIdS.add("1506580325225369602");
                    orgIdS.add("1506580379570966530");
                    orgIdS.add("1506580435753668610");
                    orgIdS.add("1506580495430225922");
                    orgIdS.add("1678193025898856449");
                    orgIdS.add("1506517642809184257");
                }

                //in搜索
                boolQuery.must(QueryBuilders.termsQuery("engineering_type_id", orgIdS));

                params.remove("engineeringTypeName");
            }



            for (Map.Entry<String, Parameter> p : params.entrySet()) {
                String key = p.getKey();
                String value = getParamValue(params, key);
                if (StringUtils.isBlank(value)) {
                    continue;
                }
                boolQuery.must(QueryBuilders.matchQuery(key, value));
            }
        } else {
            List<String> orgIdS = new ArrayList<>();
            List<OrgVO> orgVOS = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData();
            if (orgVOS != null && orgVOS.size() > 0) {
                for (OrgVO vo : orgVOS) {
                    orgIdS.add(String.valueOf(vo.getId()));
                }
            }
            //in搜索
            boolQuery.must(QueryBuilders.termsQuery("orgId", orgIdS));
        }


        //根据分页条件设置查询范围
        sourceBuilder.from(pageNumber <= 0 ? 0 : (pageNumber - 1) * pageSize);
        sourceBuilder.size(pageSize);
        sourceBuilder.query(boolQuery);

        //排序
        LinkedHashMap<String, String> orderMap = param.getOrderMap();
        if (orderMap.size() > 0) {
            for (Map.Entry<String, String> entry : orderMap.entrySet()) {
                if (SortOrder.ASC.toString().equalsIgnoreCase(entry.getValue())) {
                    sourceBuilder.sort(entry.getKey(), SortOrder.ASC);
                } else {
                    sourceBuilder.sort(entry.getKey(), SortOrder.DESC);
                }
            }
        }

        searchRequest.source(sourceBuilder);
        logger.info("打印查询参数   sourceBuilder------------------：" + JSON.toJSONString(sourceBuilder));

        try {
            List<TargetLrlReportVO> list = new ArrayList<>();
            //查询及转换
            SearchResponse response = client.search(searchRequest, RequestOptions.DEFAULT);
            logger.info("----------------response获取数据为--------------：{}", JSON.toJSONString(response));
            SearchHits hits = response.getHits();
            for (SearchHit hit : hits) {
                String sourceAsString = hit.getSourceAsString();
                //logger.info("----------------ES获取数据为--------------：{}",sourceAsString);
                list.add(JSON.parseObject(sourceAsString, TargetLrlReportVO.class));
            }
            //TODO 如需要可对数据进行二次加工处理


//            for (int i = 0; i < list.size() - 1; i++) {
//                for (int j = list.size() - 1; j > i; j--) {
//                    if (list.get(j).getBillid().equals(list.get(i).getBillid())) {
//                        list.remove(j);// 删除重复元素
//                    }
//                }
//            }
            page.setCurrent(pageNumber);
            page.setSize(pageSize);
            //查询结果
            page.setRecords(list);
            //总条数
            page.setTotal(hits.getTotalHits().value);
        } catch (IOException e) {
            logger.error(e.getMessage());
            throw new BusinessException("根据 parammap 条件，查询全部记录索引失败，MSG：" + e.getMessage());
        }
//        /**
//         * 本地测试无es环境
//         */
//        //测试
//        page.setCurrent(pageNumber);
//        page.setSize(pageSize);
//        //查询结果
//        page.setRecords(null);
//        //总条数
//        page.setTotal(0);
//        /**
//         * 测试结束
//         */
        return CommonResponse.success("查询成功！", page);
    }



    /**
     * 节点分析台账
     *
     * @return
     */
    @RequestMapping(value = "nodeAnalysisPage", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<NodeAnalysisReportVO>> nodeAnalysisPage(@RequestBody QueryParam param) {
        logger.info("请求参数   param------------------：" + JSON.toJSONString(param));
        int pageNumber = param.getPageIndex();
        int pageSize = param.getPageSize();
        Map<String, Parameter> params = param.getParams();

        IPage<NodeAnalysisReportVO> page = new Page<>();
        SearchRequest searchRequest = new SearchRequest("cost_cbfxjdjh");
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();

        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();


        if (StringUtils.isNotBlank(param.getSearchText())) {
            QueryBuilder qb1 = QueryBuilders.matchQuery("analysis_type", param.getSearchText());
            QueryBuilder qb2 = QueryBuilders.matchQuery("pName", param.getSearchText());
            QueryBuilder qb3 = QueryBuilders.matchQuery("orgName", param.getSearchText());
            QueryBuilder qb4 = QueryBuilders.matchQuery("mbName", param.getSearchText());
            QueryBuilder qb5 = QueryBuilders.matchQuery("assessName", param.getSearchText());

            boolQuery.must(QueryBuilders.boolQuery().should(qb1).should(qb2).should(qb3).should(qb4).should(qb5));
        }

        if (params != null && params.size() > 0) {

            String analysisType = getParamValue(params, "analysisType");
            if (StringUtils.isNotBlank(analysisType)) {
                //节点类型
                boolQuery.must(QueryBuilders.termQuery("analysis_type", analysisType));
                params.remove("analysisType");
            }

            String assessTime = getParamValue(params, "assessTime");
            if (StringUtils.isNotBlank(assessTime)) {

                RangeQueryBuilder settlementDate = QueryBuilders.rangeQuery("assessTime");
                List<String> dateList = Arrays.asList(assessTime.split(","));
                params.remove("assessTime");
                if (dateList.size() >= 2) {
                    settlementDate.gte(dateList.get(0));
                    settlementDate.lte(dateList.get(1));
                    boolQuery.must(settlementDate);
                }

            }
            //利润率
            String srsjRate = getParamValue(params, "srsjRate");
            if (StringUtils.isNotBlank(srsjRate)) {

                RangeQueryBuilder srsjRateBuilder = QueryBuilders.rangeQuery("srsjRate");
                List<String> dateList = Arrays.asList(srsjRate.split(","));
                params.remove("srsjRate");
                if (dateList.size() >= 2) {
                    srsjRateBuilder.gte(dateList.get(0));
                    srsjRateBuilder.lte(dateList.get(1));
                    boolQuery.must(srsjRateBuilder);
                }

            }
            String engineeringTypeName = getParamValue(params, "engineeringTypeName");
            if (StringUtils.isNotBlank(engineeringTypeName)) {

                List<String> orgIdS = new ArrayList<>();
                if("房建".equals(engineeringTypeName)){
                    orgIdS.add("1543799043577856001");
                    orgIdS.add("1508279975020908545");
                    orgIdS.add("1508280161793265665");
                    orgIdS.add("1508280244257476610");

                    //in搜索
                    boolQuery.must(QueryBuilders.termsQuery("typeId", orgIdS));
                }else if("市政".equals(engineeringTypeName)){
                    orgIdS.add("1506579865592565761");
                    orgIdS.add("1508280612022439938");
                    orgIdS.add("1508280815651704833");
                    orgIdS.add("1508280877136007170");
                    orgIdS.add("1508280929900351489");

                    //in搜索
                    boolQuery.must(QueryBuilders.termsQuery("typeId", orgIdS));
                }else {
                    orgIdS.add("1506580163417509890");
                    orgIdS.add("1506580227888156674");
                    orgIdS.add("1506580278014283778");
                    orgIdS.add("1506580325225369602");
                    orgIdS.add("1506580379570966530");
                    orgIdS.add("1506580435753668610");
                    orgIdS.add("1506580495430225922");
                    orgIdS.add("1678193025898856449");
                    orgIdS.add("1506517642809184257");

                    boolQuery.should(QueryBuilders.existsQuery("typeId"));
                    //in搜索
                    boolQuery.must(QueryBuilders.termsQuery("typeId", orgIdS));
                }

                params.remove("engineeringTypeName");
            }



            for (Map.Entry<String, Parameter> p : params.entrySet()) {
                String key = p.getKey();
                String value = getParamValue(params, key);
                if (StringUtils.isBlank(value)) {
                    continue;
                }
                boolQuery.must(QueryBuilders.matchQuery(key, value));
            }
        } else {
            List<String> orgIdS = new ArrayList<>();
            List<OrgVO> orgVOS = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData();
            if (orgVOS != null && orgVOS.size() > 0) {
                for (OrgVO vo : orgVOS) {
                    orgIdS.add(String.valueOf(vo.getId()));
                }
            }
            //in搜索
            boolQuery.must(QueryBuilders.termsQuery("orgId", orgIdS));
        }
        logger.info("打印查询参数   boolQuery------------------：" + JSON.toJSONString(boolQuery));


        //根据分页条件设置查询范围
        sourceBuilder.from(pageNumber <= 0 ? 0 : (pageNumber - 1) * pageSize);
        sourceBuilder.size(pageSize);
        sourceBuilder.query(boolQuery);

        //排序
        LinkedHashMap<String, String> orderMap = param.getOrderMap();
        if (orderMap.size() > 0) {
            for (Map.Entry<String, String> entry : orderMap.entrySet()) {
                if (SortOrder.ASC.toString().equalsIgnoreCase(entry.getValue())) {
                    sourceBuilder.sort(entry.getKey(), SortOrder.ASC);
                } else {
                    sourceBuilder.sort(entry.getKey(), SortOrder.DESC);
                }
            }
        }

        searchRequest.source(sourceBuilder);
        //logger.info("打印查询参数   sourceBuilder------------------：" + JSON.toJSONString(sourceBuilder));

        try {
            List<NodeAnalysisReportVO> list = new ArrayList<>();
            //查询及转换
            SearchResponse response = client.search(searchRequest, RequestOptions.DEFAULT);
            logger.info("----------------response获取数据为--------------：{}", JSON.toJSONString(response));
            SearchHits hits = response.getHits();
            for (SearchHit hit : hits) {
                String sourceAsString = hit.getSourceAsString();
                //logger.info("----------------ES获取数据为--------------：{}",sourceAsString);
                list.add(JSON.parseObject(sourceAsString, NodeAnalysisReportVO.class));
            }
            //TODO 如需要可对数据进行二次加工处理


//            for (int i = 0; i < list.size() - 1; i++) {
//                for (int j = list.size() - 1; j > i; j--) {
//                    if (list.get(j).getBillid().equals(list.get(i).getBillid())) {
//                        list.remove(j);// 删除重复元素
//                    }
//                }
//            }
            page.setCurrent(pageNumber);
            page.setSize(pageSize);
            //查询结果
            page.setRecords(list);
            //总条数
            page.setTotal(hits.getTotalHits().value);
        } catch (IOException e) {
            logger.error(e.getMessage());
            throw new BusinessException("根据 parammap 条件，查询全部记录索引失败，MSG：" + e.getMessage());
        }
//        /**
//         * 本地测试无es环境
//         */
//        //测试
//        page.setCurrent(pageNumber);
//        page.setSize(pageSize);
//        //查询结果
//        page.setRecords(null);
//        //总条数
//        page.setTotal(0);
//        /**
//         * 测试结束
//         */
        return CommonResponse.success("查询成功！", page);
    }
}

