package com.ejianc.business.worklog.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.worklog.bean.WorkPlanEntity;
import com.ejianc.business.worklog.service.IWorkPlanService;
import com.ejianc.business.worklog.vo.WorkPlanVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.permission.vo.RoleUserRelationVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Service("workPlan") 
public class WorkPlanBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IWorkPlanService workPlanService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		WorkPlanEntity workPlanEntity = workPlanService.selectById(billId);
		if(workPlanEntity != null){
			boolean b = sendMsg(BeanMapper.map(workPlanEntity, WorkPlanVO.class));
		}


		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	@Value("${msg.anentId}")
	private String anentId;
	@Value("${msg.secret}")
	private String secret;
	@Value("${msg.enUrl}")
	private String enUrl;

	@Autowired
	private IPushMessageApi pushMessageApi;

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	private boolean sendMsg(WorkPlanVO vo) {

		String operatorId = vo.getOperatorId();

		String[] split = operatorId.split(",");

		String subject = "您有一项新的工作计划！";
		String content = "任务名称："+vo.getProjectName() +"/n计划开始时间："+vo.getRegistTime() + "计划完成时间:"+vo.getEndTime();
		String pcUrl = "/zzyj-outputvalcount-frontend/#/article/card?id=" + vo.getId();

		/**
		 * 发送消息
		 */

		for (String userId : split) {

			String moUrl = enUrl+"/portal/sso/index?&userid="+userId+
					"&targeturl="+enUrl+"/zzyj-outputvalcount-frontend/#/article/card?id="+vo.getId();
			PushMsgParameter parameter = new PushMsgParameter();
			List<String> channel = new ArrayList<>();
			channel.add(PushMsgParameter.CHANNEL_TYPE_WEXINEE);//发送企业微信标志
			channel.add(PushMsgParameter.CHANNEL_TYPE_SYS);//
			String[] receivers = {userId};
			parameter.setReceivers(receivers);// 收信人
			parameter.setChannel(channel.toArray(new String[channel.size()]));// 消息类型
			parameter.setMsgType("notice");//预警消息
			parameter.setSubject(content);// 标题
			parameter.setContent(content);// 内容
			parameter.setPcUrl(pcUrl);// pc端url
			parameter.setMobileUrl(moUrl);// 移动端url
			parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
			parameter.setSendUserId(InvocationInfoProxy.getUserid());
			JSONObject weixineeParams = new JSONObject();
			weixineeParams.put("agentid", anentId);//企业微信应用id
			weixineeParams.put("secret", secret);//企业微信secret
			weixineeParams.put("msgtype", "textcard");
			weixineeParams.put("title", subject);
			weixineeParams.put("description", content);
			weixineeParams.put("url", (enUrl+"/portal/sso/index?&userid="+userId+
					"&targeturl="+enUrl+"/zzyj-outputvalcount-frontend/#/article/card?id=" + vo.getId()));//移动端点击的urlweixineeParams.put("btntxt", "点击查看");
			parameter.setWeixineeParams(weixineeParams);

			CommonResponse<String> result = pushMessageApi.pushMessage(parameter);
			if (result.isSuccess()) {
				logger.error("消息发送成功---------------->" + result.getMsg());
			} else {
				logger.error("消息发送失败---------------->" + result.getMsg());
			}
		}
		return true;

	}
}
