package com.ejianc.business.worklog.controller;

import java.io.Serializable;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.worklog.bean.*;
import com.ejianc.business.worklog.enums.PlanSourceTypeEnum;
import com.ejianc.business.worklog.service.IWorkPlanLogService;
import com.ejianc.business.worklog.service.IWorkPlanPersonService;
import com.ejianc.business.worklog.service.IWorkPlanTaskService;
import com.ejianc.business.worklog.vo.*;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.Utils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.worklog.service.IWorkPlanService;

/**
 * 工作日志-工作计划
 *
 * @author generator
 */
@Controller
@RequestMapping("workPlan")
public class WorkPlanController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IWorkPlanService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IWorkPlanLogService workPlanLogService;

    @Autowired
    private IWorkPlanTaskService planTaskService;

    @Autowired
    private IWorkPlanPersonService planPersonService;


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<WorkPlanVO> saveOrUpdate(@RequestBody WorkPlanVO saveOrUpdateVO) {
        WorkPlanEntity entity = BeanMapper.map(saveOrUpdateVO, WorkPlanEntity.class);
        UserContext userContextCache = sessionManager.getUserContext();
        if (entity.getId() == null || entity.getId() == 0) {
            //设置创建人姓名
            entity.setCreateUserName(userContextCache.getUserName());
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                //entity.setCode(billCode.getData());//此处需要根据实际修改删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改删除本行或者上一行
            } else {
                throw new BusinessException("网络异常，编码生成失败，请稍后再试");
            }
        } else {
            //设置修改人姓名
            entity.setUpdateUserName(userContextCache.getUserName());
        }
        entity.setProgressName("0%");//默认进展为0;
        service.saveOrUpdate(entity, false);

        /**
         * 内码生成
         */
        if (entity.getParentId() != null) {
            WorkPlanEntity pEntity = service.selectById(entity.getParentId());
            String innerCode = pEntity.getInnerCode();
            String innerName = pEntity.getInnerName();
            entity.setInnerCode(innerCode + "-" + entity.getId().toString());
            entity.setInnerName(innerName + "-" + entity.getProjectName());

        } else {
            entity.setInnerCode(entity.getId().toString());
            entity.setInnerName(entity.getProjectName());
        }
        service.saveOrUpdate(entity);

        WorkPlanVO vo = BeanMapper.map(entity, WorkPlanVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<WorkPlanVO> queryDetail(Long id) {
        WorkPlanEntity entity = service.selectById(id);
        WorkPlanVO vo = BeanMapper.map(entity, WorkPlanVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<WorkPlanVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (WorkPlanVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(WorkPlanVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<WorkPlanVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            //普通组织
            commonOrgIds.add(org.getId());
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */


        int pageSize = param.getPageSize();
        int pageIndex = param.getPageIndex();

        List<WorkPlanEntity> allData = service.queryList(param);
        List<WorkPlanVO> records = BeanMapper.mapList(allData, WorkPlanVO.class);
        /**
         * 树形显示
         */
        List<WorkPlanVO> parentWorkType = records.stream().filter(s -> s.getParentId() == null).collect(Collectors.toList());
        for (WorkPlanVO workTypeVO : parentWorkType) {
            workTypeVO.setChildren(getTreeList(workTypeVO, records));
        }
        IPage<WorkPlanVO> pageData = new Page<>();
        if (ListUtil.isNotEmpty(parentWorkType)) {
            pageData = new Page<>(pageIndex, pageSize, parentWorkType.size());

            pageData.setRecords(parentWorkType);
        } else {
            pageData = new Page<>(pageIndex, pageSize, records.size());

            pageData.setRecords(records);
        }


        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 递归放入
     */
    private List<WorkPlanVO> getTreeList(WorkPlanVO parentNode, List<WorkPlanVO> records) {
        List<WorkPlanVO> resultList = new ArrayList<>();
        List<WorkPlanVO> childrenList = new ArrayList<>();
        childrenList = records.stream().filter(s -> parentNode.getId().equals(s.getParentId())).collect(Collectors.toList());
        if (ListUtil.isNotEmpty(childrenList)) {
            int totalNum = childrenList.size();
            int finishNum = 0;
            for (WorkPlanVO child : childrenList) {
                if (child.getFinishFlag().equals("2")) {
                    finishNum++;
                }
            }
            if(parentNode != null){
                parentNode.setProgressName(finishNum + "/" + totalNum);
            }
            for (WorkPlanVO child : childrenList) {
                child.setChildren(getTreeList(child, records));
                resultList.add(child);
            }
        }
        if (ListUtil.isNotEmpty(resultList)) {
            return resultList;
        } else {
            return null;
        }
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<WorkPlanEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("WorkPlan-export.xlsx", beans, response);
    }

    /**
     * @param param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refWorkPlanData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<WorkPlanVO>> refWorkPlanData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                             String condition,
                                                             String searchObject,
                                                             String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getOrderMap().put("createTime", QueryParam.DESC);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(1, 3)));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.get("operatorId") != null) {
                param.getParams().put("operatorId", new Parameter(QueryParam.LIKE, _con.getString("operatorId")));
            }
        }

        IPage<WorkPlanEntity> page = service.queryPage(param, false);
        IPage<WorkPlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), WorkPlanVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }


    /**
     * @param param
     * @Description 参照树
     * @Return void
     */
    @RequestMapping(value = "/refWorkPlanTree", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<WorkPlanVO>> refWorkPlanTree(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                             String condition,
                                                             String searchObject,
                                                             String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        //未完成的
        param.getParams().put("finishFlag", new Parameter(QueryParam.EQ, 2));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (_con.get("departmentId") != null) {
                param.getParams().put("departmentId", new Parameter(QueryParam.EQ, _con.get("departmentId")));
            }

            if (_con.get("operatorId") != null) {
                param.getParams().put("operatorId", new Parameter(QueryParam.LIKE, _con.getString("operatorId")));
            }
        }


        List<WorkPlanEntity> allData = service.queryList(param);
        List<WorkPlanVO> records = BeanMapper.mapList(allData, WorkPlanVO.class);
        /**
         * 树形显示
         */
        List<WorkPlanVO> copyList = new ArrayList<>(records);
        List<WorkPlanVO> parentWorkType = new ArrayList<>();
        //如果父级节点没有在内，放在最外层。
        for (WorkPlanVO record : records) {
            boolean flag = false;
            for (WorkPlanVO planVO : copyList) {
                if (record.getParentId() != null && record.getParentId().equals(planVO.getId())) {
                    flag = true;
                }
            }
            if (!flag) {
                parentWorkType.add(record);
            }
        }
        for (WorkPlanVO workTypeVO : parentWorkType) {
            workTypeVO.setChildren(getTreeList(workTypeVO, records));
        }
        IPage<WorkPlanVO> pageData = new Page<>();
        if (ListUtil.isNotEmpty(parentWorkType)) {
            pageData = new Page<>(pageNumber, pageSize, parentWorkType.size());

            pageData.setRecords(parentWorkType);
        } else {
            pageData = new Page<>(pageNumber, pageSize, records.size());

            pageData.setRecords(records);
        }
        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetailWithProgress", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProjectRegistWithProgressVO> queryDetailWithProgress(Long id) {
        WorkPlanEntity entity = service.selectById(id);
        ProjectRegistWithProgressVO vo = BeanMapper.map(entity, ProjectRegistWithProgressVO.class);

        List<Integer> billState = Arrays.asList(1, 3);

        List<WorkPlanLogEntity> workPlanLogEntities = workPlanLogService.list(new QueryWrapper<WorkPlanLogEntity>()
                .like("inner_code", id)
                .eq("dr", 0)
                .in("bill_state", billState)
                .orderByDesc("service_date"));
        if (ListUtil.isNotEmpty(workPlanLogEntities)) {
            List<WorkPlanLogVO> workPlanLogVOS = BeanMapper.mapList(workPlanLogEntities, WorkPlanLogVO.class);
            vo.setPlanLogVOS(workPlanLogVOS);
        }
        List<WorkPlanEntity> workPlanEntities = service.list(new QueryWrapper<WorkPlanEntity>()
                .eq("parent_id", id)
                .eq("dr", 0));
        if (ListUtil.isNotEmpty(workPlanEntities)) {
            List<WorkPlanVO> workPlanVOS = BeanMapper.mapList(workPlanEntities, WorkPlanVO.class);
            vo.setChildrenVOS(workPlanVOS);
        }
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @param id
     * @Description pushWorkTask 推送个人任务
     */
    @RequestMapping(value = "/pushWorkTask", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse pushWorkTask(Long id) {

        List<WorkPlanPersonEntity> personEntities = planPersonService.list(Wrappers.<WorkPlanPersonEntity>lambdaQuery()
                .in(WorkPlanPersonEntity::getBillState, Arrays.asList(1, 3))
                .eq(WorkPlanPersonEntity::getPlanId, id)
        );
        if (ListUtil.isNotEmpty(personEntities)) {
            return CommonResponse.error("已经被个人计划引用，推送个人任务失败！");
        }
        List<WorkPlanTaskEntity> taskEntities = planTaskService.list(Wrappers.<WorkPlanTaskEntity>lambdaQuery()
                .eq(WorkPlanTaskEntity::getSourceId, id)
        );
        if (ListUtil.isNotEmpty(taskEntities)) {
            return CommonResponse.error("已经推送个人任务，无法再次推送！");
        }
        WorkPlanEntity entity = service.selectById(id);
        String operatorIdStr = entity.getOperatorId();
        String operatorNameStr = entity.getOperatorName();
        String[] operatorIds = operatorIdStr.split(",");
        String[] operatorNames = operatorNameStr.split(",");
        for (int i = 0; i < operatorIds.length; i++) {
            WorkPlanTaskEntity taskEntity = new WorkPlanTaskEntity();

            taskEntity.setDutyPerson(Long.valueOf(operatorIds[i]));
            taskEntity.setDutyPersonName(operatorNames[i]);


            taskEntity.setOrgId(entity.getOrgId());
            taskEntity.setOrgName(entity.getOrgName());
            taskEntity.setCreateUserName(entity.getCreateUserName());
            taskEntity.setSourceId(entity.getId());
            taskEntity.setPlanStartData(entity.getRegistTime());
            taskEntity.setPlanEndDate(entity.getEndTime());
            taskEntity.setFinishFlag(entity.getFinishFlag());
            taskEntity.setPlanName(entity.getProjectName());
            taskEntity.setInnerCode(entity.getInnerCode());
            taskEntity.setInnerName(entity.getInnerName());
            taskEntity.setTargetRemark(entity.getAnticipatedResults());
            taskEntity.setSourceType(PlanSourceTypeEnum.总计划.getStatusName());
            taskEntity.setPlanType(entity.getPlanType());

            if (entity.getInnerCode() != null) {
                String[] split = entity.getInnerCode().split("-");
                taskEntity.setTreeNum(split.length);
            }
            planTaskService.saveOrUpdate(taskEntity);
        }
        service.sendMsg(entity);
        return CommonResponse.success("推送个人任务成功！");

    }


}
