package com.ejianc.business.projectmanage.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.projectmanage.mapper.ThreeBoardMapper;
import com.ejianc.business.projectmanage.vo.PatrolPlanVO;
import com.ejianc.business.projectmanage.vo.ThreeBoardViewVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.projectmanage.bean.ThreeBoardEntity;
import com.ejianc.business.projectmanage.service.IThreeBoardService;
import com.ejianc.business.projectmanage.vo.ThreeBoardVO;

/**
 * 三板一库一室
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("threeBoard")
public class ThreeBoardController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "threeBoard";//此处需要根据实际修改

    @Autowired
    private IThreeBoardService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private ThreeBoardMapper mappper;
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ThreeBoardVO> saveOrUpdate(@RequestBody ThreeBoardVO saveOrUpdateVO) {
    	ThreeBoardEntity entity = BeanMapper.map(saveOrUpdateVO, ThreeBoardEntity.class);
        UserContext userContextCache =sessionManager.getUserContext();
        if(entity.getId() == null || entity.getId() == 0){
            //设置创建人姓名
            entity.setCreateUserName(userContextCache.getUserName());
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }else {
            //设置修改人姓名
            entity.setUpdateUserName(userContextCache.getUserName());
        }
    	service.saveOrUpdate(entity, false);
    	ThreeBoardVO vo = BeanMapper.map(entity, ThreeBoardVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ThreeBoardVO> queryDetail(Long id) {
    	ThreeBoardEntity entity = service.selectById(id);
    	ThreeBoardVO vo = BeanMapper.map(entity, ThreeBoardVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ThreeBoardVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ThreeBoardVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(ThreeBoardVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ThreeBoardVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");

        if (param.getOrderMap().containsKey("typeId")){
            param.getOrderMap().put("typeId",QueryParam.ASC);
            param.getOrderMap().put("startDate",QueryParam.ASC);
        }
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<ThreeBoardEntity> page = service.queryPage(param,false);
        IPage<ThreeBoardVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ThreeBoardVO.class));



        List<Long> siteIds = pageData.getRecords().stream().map(ThreeBoardVO::getId).collect(Collectors.toList());
        Long[] array = new Long[siteIds.size()];
        siteIds.toArray(array);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("sourceIds",array);
        jsonObject.put("orderType","desc");

        //附件集合
        Map<String, AttachmentVO> collect = new HashMap<>();
        CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.queryAllBySourceIdList(jsonObject);
        if (listCommonResponse.getCode() == 0){
            if(listCommonResponse.getData() != null){
                collect = listCommonResponse.getData().stream().collect(
                        Collectors.toMap(x -> String.format("%s:%s", x.getSourceId(), x.getSourceType()), AttachmentVO -> AttachmentVO,(k1,k2)->k1));
            }
        }
        if (collect.size() > 0 &&  pageData.getRecords() != null){
            for (ThreeBoardVO siteTrackingVO :  pageData.getRecords()) {
                //附件
                if (collect.containsKey(siteTrackingVO.getId()+":cgzp")){
                    siteTrackingVO.setGzFileName(collect.get(siteTrackingVO.getId()+":cgzp").getFileName());
                    siteTrackingVO.setGzFileUrl(collect.get(siteTrackingVO.getId()+":cgzp").getId()+"");
                }else {
                    siteTrackingVO.setGzFileName("无");
                    siteTrackingVO.setGzFileUrl("");
                }
            }
        }
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ThreeBoardEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ThreeBoard-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refThreeBoardData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ThreeBoardVO>> refThreeBoardData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ThreeBoardEntity> page = service.queryPage(param,false);
        IPage<ThreeBoardVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ThreeBoardVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }


    /**
     * @Description 分页查询成本关门台账信息
     */
    @PostMapping(value = "/queryReportList")
    @ResponseBody
    public CommonResponse<Page<ThreeBoardViewVO>> queryReportList(@RequestBody QueryParam param) {
        /**
         * 组织隔离
         */
        List<OrgVO> orgVOList = null;
        //普通组织 id
        if (!param.getParams().containsKey("orgId")) {
            //若当前上下文为项目部，则根据项目部Id来进行查询
            if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
            } else {
                CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId());
                if (!orgResp.isSuccess()) {
                    logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                    return CommonResponse.error("查询失败，获取组织信息失败！");
                }
                param.getParams().put("orgId", new Parameter(QueryParam.IN,
                        orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        }
        param.getFuzzyFields().add("projectName");
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);
        Page<ThreeBoardViewVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        List<ThreeBoardViewVO> closeCostReportVOS = mappper.queryReportList(page,wrapper);

        page.setRecords(closeCostReportVOS);

        return CommonResponse.success("查询台账信息成功！",page);
    }
}
