package com.ejianc.business.projectmanage.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.projectmanage.bean.FireWorkUserEntity;
import com.ejianc.business.projectmanage.bean.FireWorkInfoEntity;

/**
 * 工程安全管理-动火作业
 *
 * @author generator
 */
@TableName("t_project_fire_work")
public class FireWorkEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value = "bill_code")
    private String billCode; // 单据编码
    @TableField(value = "org_id")
    private Long orgId; // 组织id
    @TableField(value = "org_name")
    private String orgName; // 组织名称
    @TableField(value = "bill_state")
    private Integer billState; // 单据状态
    @TableField(value = "create_user_name")
    private String createUserName; // 编制人
    @TableField(value = "update_user_name")
    private String updateUserName; // 修改者
    @TableField(value = "remark")
    private String remark; // 备注
    @TableField(value = "parent_org_id")
    private Long parentOrgId; // 单位id
    @TableField(value = "parent_org_name")
    private String parentOrgName; // 单位名称
    @TableField(value = "project_id")
    private Long projectId; // 工程id
    @TableField(value = "project_name")
    private String projectName; // 工程名称
    @TableField(value = "check_type_name")
    private String checkTypeName; // 检查类别
    @TableField(value = "start_date")
    private Date startDate; // 计划日期
    @TableField(value = "fire_work_name")
    private String fireWorkName; // 动火作业交底
    @TableField(value = "plan_start_date")
    private Date planStartDate; // 计划动火开始时间
    @TableField(value = "plan_end_date")
    private Date planEndDate; // 计划动火结束时间


    @TableField(exist = false)
    @SubEntity(serviceName = "fireWorkUserService", pidName = "pid")
    private List<FireWorkUserEntity> fireWorkUserList = new ArrayList<>(); // 工程安全管理-动火作业-人员
    @TableField(exist = false)
    @SubEntity(serviceName = "fireWorkInfoService", pidName = "pid")
    private List<FireWorkInfoEntity> fireWorkInfoList = new ArrayList<>(); // 工程安全管理-动火作业-信息


    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getCheckTypeName() {
        return checkTypeName;
    }

    public void setCheckTypeName(String checkTypeName) {
        this.checkTypeName = checkTypeName;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public String getFireWorkName() {
        return fireWorkName;
    }

    public void setFireWorkName(String fireWorkName) {
        this.fireWorkName = fireWorkName;
    }

    public Date getPlanStartDate() {
        return planStartDate;
    }

    public void setPlanStartDate(Date planStartDate) {
        this.planStartDate = planStartDate;
    }

    public Date getPlanEndDate() {
        return planEndDate;
    }

    public void setPlanEndDate(Date planEndDate) {
        this.planEndDate = planEndDate;
    }


    public List<FireWorkUserEntity> getFireWorkUserList() {
        return fireWorkUserList;
    }

    public void setFireWorkUserList(List<FireWorkUserEntity> fireWorkUserList) {
        this.fireWorkUserList = fireWorkUserList;
    }

    public List<FireWorkInfoEntity> getFireWorkInfoList() {
        return fireWorkInfoList;
    }

    public void setFireWorkInfoList(List<FireWorkInfoEntity> fireWorkInfoList) {
        this.fireWorkInfoList = fireWorkInfoList;
    }
}
