package com.ejianc.business.outputvalcount.utils;

import java.util.HashMap;
import java.util.Map;

/**
 * @author sunxy
 * @version 1.0
 * @description: 工程类别id
 * @date 2022/07/13
 */
public enum SpecialityIdEnum {

    CODE_1(1543799043577856001L, "房屋建筑工程"),
    CODE_101(1508280244257476610L, "房屋建筑（住宅）"),
    CODE_102(1508280161793265665L, "房屋建筑（工业）"),
    CODE_103(1508279975020908545L, "房屋建筑（公共建筑）"),
    CODE_2(1506579865592565761L, "市政公用工程"),
    CODE_201(1508280929900351489L, "市政道路"),
    CODE_202(1508280877136007170L, "市政桥梁"),
    CODE_203(1508280815651704833L, "城市轨道交通"),
    CODE_204(1508280612022439938L, "市政其它"),
    CODE_3(1506580163417509890L, "装修装饰工程"),
    CODE_4(1506580227888156674L, "幕墙工程"),
    CODE_5(1506580278014283778L, "机电设备消防设施工程"),
    CODE_6(1506580325225369602L, "地基与基础工程"),
    CODE_7(1506580379570966530L, "体育场地设施工程"),
    CODE_8(1506580435753668610L, "公路工程"),
    CODE_9(1506580495430225922L, "其它");

    private Long code;
    private String name;


    private static Map<Long, String> enumMap;

    static {
        enumMap = new HashMap<>();
        enumMap.put(CODE_1.getCode(), CODE_1.getName());
        enumMap.put(CODE_101.getCode(), CODE_101.getName());
        enumMap.put(CODE_102.getCode(), CODE_102.getName());
        enumMap.put(CODE_103.getCode(), CODE_103.getName());
        enumMap.put(CODE_2.getCode(), CODE_2.getName());
        enumMap.put(CODE_201.getCode(), CODE_201.getName());
        enumMap.put(CODE_202.getCode(), CODE_202.getName());
        enumMap.put(CODE_203.getCode(), CODE_203.getName());
        enumMap.put(CODE_204.getCode(), CODE_204.getName());
        enumMap.put(CODE_3.getCode(), CODE_3.getName());
        enumMap.put(CODE_4.getCode(), CODE_4.getName());
        enumMap.put(CODE_5.getCode(), CODE_5.getName());
        enumMap.put(CODE_6.getCode(), CODE_6.getName());
        enumMap.put(CODE_7.getCode(), CODE_7.getName());
        enumMap.put(CODE_8.getCode(), CODE_8.getName());
        enumMap.put(CODE_9.getCode(), CODE_9.getName());

    }

    public static String getNameByCode(Long code) {
        return enumMap.get(code);
    }

    SpecialityIdEnum(Long code, String name) {
        this.code = code;
        this.name = name;
    }


    public Long getCode() {
        return code;
    }

    public String getName() {
        return name;
    }
}
