package com.ejianc.business.projectmanage.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.projectmanage.bean.ReturnVisitRecordDetailEntity;

/**
 * 工程管理-回访记录表
 *
 * @author generator
 */
@TableName("t_project_return_visit_record")
public class ReturnVisitRecordEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value = "bill_code")
    private String billCode; // 单据编码
    @TableField(value = "org_id")
    private Long orgId; // 组织id
    @TableField(value = "org_name")
    private String orgName; // 组织名称
    @TableField(value = "bill_state")
    private Integer billState; // 单据状态
    @TableField(value = "create_user_name")
    private String createUserName; // 编制人
    @TableField(value = "update_user_name")
    private String updateUserName; // 修改者
    @TableField(value = "remark")
    private String remark; // 备注
    @TableField(value = "parent_org_id")
    private Long parentOrgId; // 单位id
    @TableField(value = "parent_org_name")
    private String parentOrgName; // 单位名称
    @TableField(value = "project_id")
    private Long projectId; // 工程id
    @TableField(value = "project_name")
    private String projectName; // 工程名称
    @TableField(value = "visit_date")
    private Date visitDate; // 回访日期
    @TableField(value = "duty_person")
    private Long dutyPerson; // 回访负责人
    @TableField(value = "duty_person_name")
    private String dutyPersonName; // 回访负责人名称
    @TableField(value = "duty_person_phone")
    private String dutyPersonPhone; // 回访负责人联系方式
    @TableField(value = "build_unit_id")
    private Long buildUnitId; // 施工单位
    @TableField(value = "build_unit_name")
    private String buildUnitName; // 施工单位名称
    @TableField(value = "commit_user")
    private Long commitUser; // 提交人
    @TableField(value = "commit_user_name")
    private String commitUserName; // 提交人名称
    @TableField(value = "commit_date")
    private Date commitDate; // 提交日期
    @TableField(value = "engineering_type")
    private Long engineeringType; // 工程类别
    @TableField(value = "engineering_type_name")
    private String engineeringTypeName; // 工程类别名称
    @TableField(value = "visit_type")
    private Long visitType; // 回访类型
    @TableField(value = "visit_type_name")
    private String visitTypeName; // 回访类型名称
    @TableField(value = "finish_date")
    private Date finishDate; // 竣工日期
    @TableField(value = "measure_type")
    private Long measureType; // 工程度量方式
    @TableField(value = "measure_type_name")
    private String measureTypeName; // 工程度量方式名称
    @TableField(value = "measure_value")
    private String measureValue; // 度量值
    @TableField(value = "visit_plan_id")
    private Long visitPlanId; // 回访计划id
    @TableField(value = "handle_flag")
    private String handleFlag; // 处理标识
    @TableField(value = "last_handle_date")
    private Date lastHandleDate; // 最新处理日期
    @TableField(value="plan_handle_date")
    private Date planHandleDate; // 计划处理完成日期

    @TableField(exist = false)
    @SubEntity(serviceName = "returnVisitRecordDetailService", pidName = "zhuId")
    private List<ReturnVisitRecordDetailEntity> returnVisitRecordDetailList = new ArrayList<>(); // 工程管理-回访记录问题详情


    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Date getVisitDate() {
        return visitDate;
    }

    public void setVisitDate(Date visitDate) {
        this.visitDate = visitDate;
    }

    public Long getDutyPerson() {
        return dutyPerson;
    }

    public void setDutyPerson(Long dutyPerson) {
        this.dutyPerson = dutyPerson;
    }

    public String getDutyPersonName() {
        return dutyPersonName;
    }

    public void setDutyPersonName(String dutyPersonName) {
        this.dutyPersonName = dutyPersonName;
    }

    public String getDutyPersonPhone() {
        return dutyPersonPhone;
    }

    public void setDutyPersonPhone(String dutyPersonPhone) {
        this.dutyPersonPhone = dutyPersonPhone;
    }

    public Long getBuildUnitId() {
        return buildUnitId;
    }

    public void setBuildUnitId(Long buildUnitId) {
        this.buildUnitId = buildUnitId;
    }

    public String getBuildUnitName() {
        return buildUnitName;
    }

    public void setBuildUnitName(String buildUnitName) {
        this.buildUnitName = buildUnitName;
    }

    public Long getCommitUser() {
        return commitUser;
    }

    public void setCommitUser(Long commitUser) {
        this.commitUser = commitUser;
    }

    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }

    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }

    public Long getEngineeringType() {
        return engineeringType;
    }

    public void setEngineeringType(Long engineeringType) {
        this.engineeringType = engineeringType;
    }

    public String getEngineeringTypeName() {
        return engineeringTypeName;
    }

    public void setEngineeringTypeName(String engineeringTypeName) {
        this.engineeringTypeName = engineeringTypeName;
    }

    public Long getVisitType() {
        return visitType;
    }

    public void setVisitType(Long visitType) {
        this.visitType = visitType;
    }

    public String getVisitTypeName() {
        return visitTypeName;
    }

    public void setVisitTypeName(String visitTypeName) {
        this.visitTypeName = visitTypeName;
    }

    public Date getFinishDate() {
        return finishDate;
    }

    public void setFinishDate(Date finishDate) {
        this.finishDate = finishDate;
    }

    public Long getMeasureType() {
        return measureType;
    }

    public void setMeasureType(Long measureType) {
        this.measureType = measureType;
    }

    public String getMeasureTypeName() {
        return measureTypeName;
    }

    public void setMeasureTypeName(String measureTypeName) {
        this.measureTypeName = measureTypeName;
    }

    public String getMeasureValue() {
        return measureValue;
    }

    public void setMeasureValue(String measureValue) {
        this.measureValue = measureValue;
    }

    public Long getVisitPlanId() {
        return visitPlanId;
    }

    public void setVisitPlanId(Long visitPlanId) {
        this.visitPlanId = visitPlanId;
    }

    public String getHandleFlag() {
        return handleFlag;
    }

    public void setHandleFlag(String handleFlag) {
        this.handleFlag = handleFlag;
    }

    public Date getLastHandleDate() {
        return lastHandleDate;
    }

    public void setLastHandleDate(Date lastHandleDate) {
        this.lastHandleDate = lastHandleDate;
    }


    public List<ReturnVisitRecordDetailEntity> getReturnVisitRecordDetailList() {
        return returnVisitRecordDetailList;
    }

    public void setReturnVisitRecordDetailList(List<ReturnVisitRecordDetailEntity> returnVisitRecordDetailList) {
        this.returnVisitRecordDetailList = returnVisitRecordDetailList;
    }

    public Date getPlanHandleDate() {
        return planHandleDate;
    }

    public void setPlanHandleDate(Date planHandleDate) {
        this.planHandleDate = planHandleDate;
    }
}
