package com.ejianc.business.outputvalcount.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.outputvalcount.bean.MonthlyStatisticsEntity;
import com.ejianc.business.outputvalcount.bean.MonthlyStatisticsPayDetailEntity;
import com.ejianc.business.outputvalcount.bean.PayDetailSourceEntity;
import com.ejianc.business.outputvalcount.bean.PayOffEntity;
import com.ejianc.business.outputvalcount.controller.api.PayOffApi;
import com.ejianc.business.outputvalcount.mapper.MonthlyStatisticsMapper;
import com.ejianc.business.outputvalcount.service.IMonthlyStatisticsService;
import com.ejianc.business.outputvalcount.service.IPayDetailSourceService;
import com.ejianc.business.outputvalcount.service.IPayOffService;
import com.ejianc.business.receipt.api.IReceiptRegisterApi;
import com.ejianc.business.receipt.vo.ReceiptRegisterVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

@Service("monthlyStatistics") 
public class MonthlyStatisticsBpmServiceImpl implements ICommonBusinessService {


	@Autowired
	private IMonthlyStatisticsService service;

	@Autowired
	private MonthlyStatisticsMapper mapper;

	@Autowired
	private IPayDetailSourceService payDetailSourceService;

	@Autowired
	private IReceiptRegisterApi receiptRegisterApi;

	@Autowired
	private IPayOffService payOffService;

	@Autowired
	private PayOffApi payOffApi;


	private Logger logger = LoggerFactory.getLogger(this.getClass());

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		MonthlyStatisticsEntity monthlyStatisticsEntity = service.getById(billId);

		List<MonthlyStatisticsEntity> monthlyStatistics = mapper.getMonthlyStatistics(monthlyStatisticsEntity.getProjectId());
		int year = monthlyStatisticsEntity.getYear();
		int month = monthlyStatisticsEntity.getMonth();
		for(MonthlyStatisticsEntity entity : monthlyStatistics){
			if (entity.getYear() > year ||(entity.getYear() == year && entity.getMonth() > month ) ){
				if(entity.getBillState() == 1 || entity.getBillState() == 3){
					throw new BusinessException(entity.getYear()+"年"+entity.getMonth()+"月份的单据已提交或审批通过！");
				}
			}
		}
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		MonthlyStatisticsEntity statisticsEntity = service.selectById(billId);
		List<MonthlyStatisticsPayDetailEntity> payDetailList = statisticsEntity.getMonthlyStatisticsPayDetailList();
		if(ListUtil.isNotEmpty(payDetailList)){
			logger.info("1---------推送应收中间库开始{}", JSON.toJSONString(payDetailList));
			for (MonthlyStatisticsPayDetailEntity payDetailEntity : payDetailList) {
				if("应收".equals(payDetailEntity.getDetailType())){
					PayDetailSourceEntity payDetailSourceEntity = new PayDetailSourceEntity();
					if(payDetailEntity.getLastId() == null){

						payDetailSourceEntity.setSourceId(payDetailEntity.getId());
						payDetailSourceEntity.setPayPer(payDetailEntity.getPayPer());
						payDetailSourceEntity.setPayRemarkId(payDetailEntity.getPayRemarkId());
						payDetailSourceEntity.setPayNode(payDetailEntity.getPayNode());
						payDetailSourceEntity.setPayNodeNum(payDetailEntity.getPayNodeNum());
						payDetailSourceEntity.setServiceDate(new Date());


						payDetailSourceEntity.setProjectId(payDetailEntity.getProjectId());
						payDetailSourceEntity.setProjectName(payDetailEntity.getProjectName());


						payDetailSourceEntity.setQuoteMny(payDetailEntity.getQuoteMny());//本次对甲
						payDetailSourceEntity.setReceiveMny(payDetailEntity.getReceiveMny());//本次应收
						payDetailSourceEntity.setActualMny(BigDecimal.ZERO);//已收
						payDetailSourceEntity.setUnMny(payDetailEntity.getReceiveMny());//未收

						logger.info("2---------推送应收中间库数据{}", JSON.toJSONString(payDetailSourceEntity));


					} else {
						payDetailSourceEntity = payDetailSourceService.getOne(Wrappers.<PayDetailSourceEntity>lambdaQuery()
								.eq(PayDetailSourceEntity::getSourceId, payDetailEntity.getLastId())
						);
						payDetailSourceEntity.setQuoteMny(payDetailEntity.getQuoteMny());//本次对甲
						payDetailSourceEntity.setReceiveMny(payDetailEntity.getReceiveMny());//本次应收
						BigDecimal unMny = payDetailEntity.getReceiveMny().subtract(payDetailSourceEntity.getActualMny());
						payDetailSourceEntity.setUnMny(unMny);
						payDetailSourceEntity.setServiceDate(new Date());

						logger.info("2---------修改应收中间库数据{}", JSON.toJSONString(payDetailSourceEntity));

					}

					payDetailSourceService.saveOrUpdate(payDetailSourceEntity);
				}
			}
		}

		//核销过程
		payOffApi.payOffByProjectId(statisticsEntity.getProjectId());


		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO


		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("已推送收款核销表，不允许撤回，请联系管理员！");
	}

}
