package com.ejianc.business.outputvalcount.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.outputvalcount.bean.PayDetailSourceEntity;
import com.ejianc.business.outputvalcount.bean.PayOffEntity;
import com.ejianc.business.outputvalcount.service.IPayDetailSourceService;
import com.ejianc.business.outputvalcount.service.IPayOffService;
import com.ejianc.business.profinance.vo.ContractPaymentResultVO;
import com.ejianc.business.receipt.api.IReceiptRegisterApi;
import com.ejianc.business.receipt.vo.ReceiptRegisterVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

/**
 *
 * 应收核销表
 * @Author: jiang
 * @Date: 2025/1/15 10:43
 *
 **/
@RestController
@RequestMapping("/api/payOff/")
public class PayOffApi {


    @Autowired
    private IPayDetailSourceService payDetailSourceService;

    @Autowired
    private IReceiptRegisterApi receiptRegisterApi;

    @Autowired
    private IPayOffService payOffService;


    private Logger logger = LoggerFactory.getLogger(this.getClass());


    /**
     * 根据应收中间库和收款记录表生成的核销记录处理
     * @param projectId 项目id
     * @param payDetailSourceEntities 未核销的应收中间库
     * @param receiptRegisterVOS      未核销的收款登记
     */
    @GetMapping(value = "payOffByProjectId")
    public CommonResponse payOffByProjectId(@RequestParam(value = "projectId") Long projectId) {

        logger.info("核销逻辑开始-----------------");
        payOffService.payOffByProjectId(projectId);
        logger.info("-------------------核销逻辑结束");
        return CommonResponse.success();
    }
}
