package com.ejianc.business.outputvalcount.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.outputvalcount.bean.ProjectInfoRegisterExamineEntity;
import com.ejianc.business.outputvalcount.bean.ProjectInfoRegisterDisputeEntity;
import com.ejianc.business.outputvalcount.bean.ProjectInfoRegisterCommunicationEntity;
/**
 * 项目相关方信息每日填报
 * 
 * @author generator
 * 
 */
 @TableName("t_project_info_register")
public class ProjectInfoRegisterEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="create_user_name")
    private String createUserName; // 编制人
    @TableField(value="update_user_name")
    private String updateUserName; // 修改者
    @TableField(value="remark")
    private String remark; // 备注
    @TableField(value="project_id")
    private Long projectId; // 工程名称id
    @TableField(value="project_name")
    private String projectName; // 工程名称
    @TableField(value="create_date")
    private Date createDate; // 创建日期
    @TableField(value="operator_id")
    private Long operatorId; // 经办人ID
    @TableField(value="operator_name")
    private String operatorName; // 经办人姓名
    @TableField(value="operator_phone")
    private String operatorPhone; // 经办人手机号
    @TableField(value="examine_state")
    private Integer examineState; // 外部行政部门检查
    @TableField(value="dispute_state")
    private Integer disputeState; // 现场是否存在纠纷
    @TableField(value="communication_state")
    private Integer communicationState; // 现场是否存在外部沟通
    @TableField(value = "check_status")
    private String checkStatus;//检查状态(1-进行中 2-已结束 3-无检查)
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="projectInfoRegisterExamineService",pidName = "zhuId")
    private List<ProjectInfoRegisterExamineEntity> projectInfoRegisterExamineList = new ArrayList<>(); // 信息每日填报行政部门检查
    @TableField(exist=false)
    @SubEntity(serviceName="projectInfoRegisterDisputeService",pidName = "zhuId")
    private List<ProjectInfoRegisterDisputeEntity> projectInfoRegisterDisputeList = new ArrayList<>(); // 信息每日填报-纠纷
    @TableField(exist=false)
    @SubEntity(serviceName="projectInfoRegisterCommunicationService",pidName = "zhuId")
    private List<ProjectInfoRegisterCommunicationEntity> projectInfoRegisterCommunicationList = new ArrayList<>(); // 信息每日填报-外部沟通
    //patrol_group
    @TableField(value="patrol_group")
    private String patrolGroup; // 巡检组
    @TableField(value = "progress_num")
    private Long progressNum;//子表待办数量

    public String getPatrolGroup() {
        return patrolGroup;
    }

    public void setPatrolGroup(String patrolGroup) {
        this.patrolGroup = patrolGroup;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public String getOperatorPhone() {
        return operatorPhone;
    }

    public void setOperatorPhone(String operatorPhone) {
        this.operatorPhone = operatorPhone;
    }
    public Integer getExamineState() {
        return examineState;
    }

    public void setExamineState(Integer examineState) {
        this.examineState = examineState;
    }
    public Integer getDisputeState() {
        return disputeState;
    }

    public void setDisputeState(Integer disputeState) {
        this.disputeState = disputeState;
    }
    public Integer getCommunicationState() {
        return communicationState;
    }

    public void setCommunicationState(Integer communicationState) {
        this.communicationState = communicationState;
    }
    

    public List<ProjectInfoRegisterExamineEntity> getProjectInfoRegisterExamineList() {
        return projectInfoRegisterExamineList;
    }

    public void setProjectInfoRegisterExamineList(List<ProjectInfoRegisterExamineEntity> projectInfoRegisterExamineList) {
        this.projectInfoRegisterExamineList = projectInfoRegisterExamineList;
    }

    public List<ProjectInfoRegisterDisputeEntity> getProjectInfoRegisterDisputeList() {
        return projectInfoRegisterDisputeList;
    }

    public void setProjectInfoRegisterDisputeList(List<ProjectInfoRegisterDisputeEntity> projectInfoRegisterDisputeList) {
        this.projectInfoRegisterDisputeList = projectInfoRegisterDisputeList;
    }

    public List<ProjectInfoRegisterCommunicationEntity> getProjectInfoRegisterCommunicationList() {
        return projectInfoRegisterCommunicationList;
    }

    public void setProjectInfoRegisterCommunicationList(List<ProjectInfoRegisterCommunicationEntity> projectInfoRegisterCommunicationList) {
        this.projectInfoRegisterCommunicationList = projectInfoRegisterCommunicationList;
    }

    public String getCheckStatus() {
        return checkStatus;
    }

    public void setCheckStatus(String checkStatus) {
        this.checkStatus = checkStatus;
    }

    public Long getProgressNum() {
        return progressNum;
    }

    public void setProgressNum(Long progressNum) {
        this.progressNum = progressNum;
    }
}
