/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.outputvalcount.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.outputvalcount.bean.PayDetailSourceEntity;
import com.ejianc.business.outputvalcount.bean.PayOffEntity;
import com.ejianc.business.outputvalcount.mapper.PayOffMapper;
import com.ejianc.business.outputvalcount.service.IPayDetailSourceService;
import com.ejianc.business.outputvalcount.service.IPayOffService;
import com.ejianc.business.receipt.api.IReceiptRegisterApi;
import com.ejianc.business.receipt.vo.ReceiptRegisterVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="payOffService")
public class PayOffServiceImpl
extends BaseServiceImpl<PayOffMapper, PayOffEntity>
implements IPayOffService {
    @Autowired
    private IPayDetailSourceService payDetailSourceService;
    @Autowired
    private IReceiptRegisterApi receiptRegisterApi;
    @Autowired
    private IPayOffService payOffService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void payOffByProjectId(Long projectId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
        queryParam.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        queryParam.getParams().put("unMny", new Parameter("gt", (Object)BigDecimal.ZERO));
        queryParam.getOrderMap().put("receiptDate", "asc");
        CommonResponse receiptResponse = this.receiptRegisterApi.queryReceiptRegisterList(queryParam);
        if (!receiptResponse.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u6536\u6b3e\u5217\u8868\u5931\u8d25\uff01");
        }
        List receiptRegisterVOS = (List)receiptResponse.getData();
        this.logger.info("3.1---------\u67e5\u8be2\u6536\u6b3e\u5217\u8868\u6570\u636e\u4e3a{}", (Object)JSONObject.toJSONString((Object)receiptRegisterVOS));
        QueryParam payDetailParam = new QueryParam();
        payDetailParam.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        payDetailParam.getParams().put("unMny", new Parameter("gt", (Object)BigDecimal.ZERO));
        payDetailParam.getOrderMap().put("serviceDate", "asc");
        List payDetailSourceEntities = this.payDetailSourceService.queryList(payDetailParam);
        this.logger.info("3.2---------\u67e5\u8be2\u5e94\u6536\u4e2d\u95f4\u5e93\u6570\u636e\u4e3a{}", (Object)JSONObject.toJSONString((Object)payDetailSourceEntities));
        ArrayList<PayOffEntity> payOffEntities = new ArrayList<PayOffEntity>();
        ArrayList<ReceiptRegisterVO> changeReceiptRegisterVOS = new ArrayList<ReceiptRegisterVO>();
        for (PayDetailSourceEntity detailSourceEntity : payDetailSourceEntities) {
            if (detailSourceEntity.getUnMny().compareTo(BigDecimal.ZERO) == 0) {
                throw new BusinessException("\u6838\u9500\u8bb0\u5f55\u751f\u6210\u5931\u8d25\uff0c\u5b58\u5728\u5df2\u6838\u9500\u6570\u636e\uff01");
            }
            for (ReceiptRegisterVO receiptRegisterVO : receiptRegisterVOS) {
                PayOffEntity payOffEntity;
                BigDecimal unMny;
                BigDecimal sumReceivedMny = receiptRegisterVO.getUnMny();
                BigDecimal receiveMny = detailSourceEntity.getReceiveMny();
                if (receiveMny.compareTo(sumReceivedMny) >= 1) {
                    unMny = receiveMny.subtract(sumReceivedMny);
                    detailSourceEntity.setUnMny(unMny);
                    detailSourceEntity.setActualMny(sumReceivedMny);
                    this.logger.info("4.1---------\u56de\u5199\u5e94\u6536\u4e2d\u95f4\u8868\u6570\u636e\u7ed3\u679c\u4e3a{}", (Object)JSONObject.toJSONString((Object)((Object)detailSourceEntity)));
                    payOffEntity = new PayOffEntity();
                    payOffEntity.setServiceDate(new Date());
                    payOffEntity.setPayRemarkId(detailSourceEntity.getPayRemarkId());
                    payOffEntity.setSourceId(detailSourceEntity.getId());
                    payOffEntity.setReceiveId(receiptRegisterVO.getId());
                    payOffEntity.setProjectId(detailSourceEntity.getProjectId());
                    payOffEntity.setProjectName(detailSourceEntity.getProjectName());
                    payOffEntity.setReceiveMny(receiveMny);
                    payOffEntity.setActualMny(sumReceivedMny);
                    payOffEntity.setUnMny(unMny);
                    payOffEntities.add(payOffEntity);
                    this.logger.info("4.2---------\u6838\u9500\u8bb0\u5f55\u751f\u6210\u7ed3\u679c\u4e3a{}", (Object)JSONObject.toJSONString((Object)((Object)payOffEntity)));
                    receiptRegisterVO.setUnMny(BigDecimal.ZERO);
                    changeReceiptRegisterVOS.add(receiptRegisterVO);
                    this.logger.info("4.3---------\u56de\u5199\u6536\u6b3e\u8bb0\u5f55\u7ed3\u679c\u4e3a{}", (Object)JSONObject.toJSONString((Object)receiptRegisterVO));
                    continue;
                }
                unMny = BigDecimal.ZERO;
                detailSourceEntity.setUnMny(unMny);
                detailSourceEntity.setActualMny(receiveMny);
                this.logger.info("4.1---------\u56de\u5199\u5e94\u6536\u4e2d\u95f4\u8868\u6570\u636e\u7ed3\u679c\u4e3a{}", (Object)JSONObject.toJSONString((Object)((Object)detailSourceEntity)));
                payOffEntity = new PayOffEntity();
                payOffEntity.setServiceDate(new Date());
                payOffEntity.setPayRemarkId(detailSourceEntity.getPayRemarkId());
                payOffEntity.setSourceId(detailSourceEntity.getId());
                payOffEntity.setReceiveId(receiptRegisterVO.getId());
                payOffEntity.setProjectId(detailSourceEntity.getProjectId());
                payOffEntity.setProjectName(detailSourceEntity.getProjectName());
                payOffEntity.setReceiveMny(receiveMny);
                payOffEntity.setActualMny(receiveMny);
                payOffEntity.setUnMny(unMny);
                payOffEntities.add(payOffEntity);
                this.logger.info("4.2---------\u6838\u9500\u8bb0\u5f55\u751f\u6210\u7ed3\u679c\u4e3a{}", (Object)JSONObject.toJSONString((Object)((Object)payOffEntity)));
                BigDecimal changeMny = sumReceivedMny.subtract(receiveMny);
                receiptRegisterVO.setUnMny(changeMny);
                changeReceiptRegisterVOS.add(receiptRegisterVO);
                this.logger.info("4.3---------\u56de\u5199\u6536\u6b3e\u8bb0\u5f55\u7ed3\u679c\u4e3a{}", (Object)JSONObject.toJSONString((Object)receiptRegisterVO));
            }
        }
        this.logger.info("\u6570\u636e\u5904\u7406\u5b8c\u6bd5\uff0c\u51c6\u5907\u6267\u884c\u4fdd\u5b58\u64cd\u4f5c");
        if (ListUtil.isNotEmpty(payOffEntities)) {
            this.payOffService.saveOrUpdateBatch(payOffEntities);
        }
        if (ListUtil.isNotEmpty((List)payDetailSourceEntities)) {
            this.payDetailSourceService.saveOrUpdateBatch(payDetailSourceEntities);
        }
        if (ListUtil.isNotEmpty(changeReceiptRegisterVOS)) {
            this.receiptRegisterApi.saveOrUpdateReceiptRegisterList(changeReceiptRegisterVOS);
        }
        this.logger.info("\u4fdd\u5b58\u7ed3\u675f");
    }
}

