package com.ejianc.business.outputvalcount.controller.warn;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.center.api.IWarnCenterApi;
import com.ejianc.business.center.vo.EarlyWarnTransVO;
import com.ejianc.business.outputvalcount.bean.MeetingMinutesEntity;
import com.ejianc.business.outputvalcount.mapper.CostDesktopWarnMapper;
import com.ejianc.business.outputvalcount.service.IMonthlyStatisticsService;
import com.ejianc.business.outputvalcount.vo.CostDesktopVO;
import com.ejianc.business.outputvalcount.vo.MeetingMinutesVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectSurveyVO;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * @author sunxy
 * @Description:
 * @date 2023/8/18 11:22
 */
@RestController
@RequestMapping(value = "/costDeaktop/")
public class CostDesktopWarnController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private CostDesktopWarnMapper mapper;


       /**
     * @Description 产值收款比例低于50%
     * @param
     * @Return
     */
    @RequestMapping(value = "/outputvalLessHalf", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CostDesktopVO>> outputvalLessHalf(@RequestBody QueryParam param) {
        IPage<CostDesktopVO> page = new Page<>(param.getPageIndex(), param.getPageSize());

        List<CostDesktopVO> costDesktopVOS = mapper.queryOutputvalLessHalf(changeToQueryWrapper(param), page);

        IPage<CostDesktopVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());

        pageData.setRecords(costDesktopVOS);

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 目标责任成本占施工合同总金额百分比超过90%
     * @param
     * @Return
     */
    @RequestMapping(value = "/costOverPercent90", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CostDesktopVO>> costOverPercent90(@RequestBody QueryParam param) {
        IPage<CostDesktopVO> page = new Page<>(param.getPageIndex(), param.getPageSize());

        List<CostDesktopVO> costDesktopVOS = mapper.queryCostOverPercent90(changeToQueryWrapper(param), page);

        IPage<CostDesktopVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());

        pageData.setRecords(costDesktopVOS);

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 立项60天目标责任成本未编制
     * @param
     * @Return
     */
    @RequestMapping(value = "/queryNoTargetcostOver60Day", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CostDesktopVO>> queryNoTargetcostOver60Day(@RequestBody QueryParam param) {
        IPage<CostDesktopVO> page = new Page<>(param.getPageIndex(), param.getPageSize());

        List<CostDesktopVO> costDesktopVOS = mapper.queryNoTargetcostOver60Day(changeToQueryWrapper(param), page);

        IPage<CostDesktopVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());

        pageData.setRecords(costDesktopVOS);

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 无合同间接支出占施工合同额比例超百分比10%
     * @param
     * @Return
     */
    @RequestMapping(value = "/queryNoContractJjfOver10Percent", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CostDesktopVO>> queryNoContractJjfOver10Percent(@RequestBody QueryParam param) {
        IPage<CostDesktopVO> page = new Page<>(param.getPageIndex(), param.getPageSize());

        List<CostDesktopVO> costDesktopVOS = mapper.queryNoContractJjfOver10Percent(changeToQueryWrapper(param), page);

        IPage<CostDesktopVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());

        pageData.setRecords(costDesktopVOS);

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 特殊其他支出项目百分1%预警
     * @param
     * @Return
     */
    @RequestMapping(value = "/queryOtherOver1Percent", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CostDesktopVO>> queryOtherOver1Percent(@RequestBody QueryParam param) {
        IPage<CostDesktopVO> page = new Page<>(param.getPageIndex(), param.getPageSize());

        List<CostDesktopVO> costDesktopVOS = mapper.queryOtherOver1Percent(changeToQueryWrapper(param), page);

        IPage<CostDesktopVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());

        pageData.setRecords(costDesktopVOS);

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description 查询所有的个数
     * @param
     * @Return
     */
    @RequestMapping(value = "/queryAllNum", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryAllNum(@RequestBody QueryParam param) {
        JSONObject jsonObject = new JSONObject();
        IPage<CostDesktopVO> page1 = new Page<>(param.getPageIndex(), param.getPageSize());
        mapper.queryOutputvalLessHalf(changeToQueryWrapper(param), page1);
        jsonObject.put("estimationMny",page1.getTotal());

        IPage<CostDesktopVO> page2 = new Page<>(param.getPageIndex(), param.getPageSize());
        mapper.queryCostOverPercent90(changeToQueryWrapper(param), page2);
        jsonObject.put("yearEstimationMny",page2.getTotal());

        IPage<CostDesktopVO> page3 = new Page<>(param.getPageIndex(), param.getPageSize());
        mapper.queryNoTargetcostOver60Day(changeToQueryWrapper(param), page3);
        jsonObject.put("utilizeMny",page3.getTotal());

        IPage<CostDesktopVO> page4 = new Page<>(param.getPageIndex(), param.getPageSize());
        mapper.queryNoContractJjfOver10Percent(changeToQueryWrapper(param), page4);
        jsonObject.put("turnoverRate",page4.getTotal());

        IPage<CostDesktopVO> page5 = new Page<>(param.getPageIndex(), param.getPageSize());
        mapper.queryOtherOver1Percent(changeToQueryWrapper(param), page5);
        jsonObject.put("anewone",page5.getTotal());

        return CommonResponse.success("查询列表数据成功！",jsonObject);
    }

}