package com.ejianc.business.worklog.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.worklog.bean.OrgIndexStatisticsDetailEntity;
import com.ejianc.business.worklog.bean.OrgIndexStatisticsEntity;
import com.ejianc.business.worklog.bean.OrgIndexSubmitEntity;
import com.ejianc.business.worklog.bean.YearOrgIndexStatisticsEntity;
import com.ejianc.business.worklog.service.IOrgIndexSubmitService;
import com.ejianc.business.worklog.service.IYearOrgIndexStatisticsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.List;

@Service("yearOrgIndexStatistics") 
public class YearOrgIndexStatisticsBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IYearOrgIndexStatisticsService yearService;
	@Autowired
	private IOrgIndexSubmitService indexSubmitService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		YearOrgIndexStatisticsEntity entity = yearService.selectById(billId);
		if(entity != null){
			LambdaUpdateWrapper<OrgIndexSubmitEntity> updateWrapper = new LambdaUpdateWrapper<>();
			updateWrapper.set(OrgIndexSubmitEntity::getIndexProgress,entity.getIndexProgress());
			updateWrapper.set(OrgIndexSubmitEntity::getProgressDate,entity.getProgressDate());
			updateWrapper.eq(OrgIndexSubmitEntity::getId,entity.getIndexId());
			indexSubmitService.update(updateWrapper);
		}

		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
