package com.ejianc.business.worklog.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.worklog.bean.DepartmentLogDetailEntity;
/**
 * 工作日志-部门日志
 * 
 * @author generator
 * 
 */
 @TableName("t_outputvalcount_work_log_department")
public class DepartmentLogEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="create_user_name")
    private String createUserName; // 编制人
    @TableField(value="operator_id")
    private Long operatorId; // 经办人ID
    @TableField(value="operator_name")
    private String operatorName; // 经办人姓名
    @TableField(value="update_user_name")
    private String updateUserName; // 修改者
    @TableField(value="remark")
    private String remark; // 备注
    @TableField(value="department_id")
    private Long departmentId; // 部门
    @TableField(value="department_name")
    private String departmentName; // 部门名称
    @TableField(value="work_date")
    private Date workDate; // 工作日期
    @TableField(value="department_log_name")
    private String departmentLogName; // 部门日志名称
    @TableField(value="log_type")
    private String logType; // 日志类型(1-周报 2-日报)
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="departmentLogDetailService",pidName = "departmentLogId")
    private List<DepartmentLogDetailEntity> departmentLogDetailList = new ArrayList<>(); // 工作日志-部门日志详情
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public Date getWorkDate() {
        return workDate;
    }

    public void setWorkDate(Date workDate) {
        this.workDate = workDate;
    }
    public String getDepartmentLogName() {
        return departmentLogName;
    }

    public void setDepartmentLogName(String departmentLogName) {
        this.departmentLogName = departmentLogName;
    }
    public String getLogType() {
        return logType;
    }

    public void setLogType(String logType) {
        this.logType = logType;
    }
    

    public List<DepartmentLogDetailEntity> getDepartmentLogDetailList() {
        return departmentLogDetailList;
    }

    public void setDepartmentLogDetailList(List<DepartmentLogDetailEntity> departmentLogDetailList) {
        this.departmentLogDetailList = departmentLogDetailList;
    }
}
