package com.ejianc.business.worklog.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.worklog.bean.WorkTypeEntity;
import com.ejianc.business.worklog.vo.DepartmentLogDetailVO;
import com.ejianc.business.worklog.vo.DepartmentLogVO;
import com.ejianc.business.worklog.vo.PersonLogVO;
import com.ejianc.business.worklog.vo.WorkTypeVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.worklog.bean.PersonLogEntity;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 工作日志-个人工作日志
 * 
 * @author generator
 * 
 */
public interface IPersonLogService extends IBaseService<PersonLogEntity> {
    /**
     * 查询个人工作日志
     * @param page
     * @param departmentId
     * @param logType
     * @param workDate
     * @param workTypeId
     * @return
     */
    Page<DepartmentLogDetailVO> getPersonLog(Page<DepartmentLogDetailVO> page,
                                             Long departmentId,
                                             Date workDate,
                                             String logType,
                                             Long workTypeId);

    /**
     * 查询工作分类tree
     *
     * @param params
     * @return
     */
    List<WorkTypeVO> queryWorkTypeTree(Map<String, Object> params);
}
