package com.ejianc.business.worklog.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.worklog.mapper.DepartmentLogMapper;
import com.ejianc.business.worklog.vo.DepartmentLogDetailVO;
import com.ejianc.business.worklog.vo.DepartmentLogVO;
import com.ejianc.business.worklog.vo.PersonLogVO;
import com.ejianc.business.worklog.vo.WorkTypeVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.worklog.mapper.PersonLogMapper;
import com.ejianc.business.worklog.bean.PersonLogEntity;
import com.ejianc.business.worklog.service.IPersonLogService;

import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 工作日志-个人工作日志
 *
 * @author generator
 */
@Service("personLogService")
public class PersonLogServiceImpl extends BaseServiceImpl<PersonLogMapper, PersonLogEntity> implements IPersonLogService {
    @Autowired
    private PersonLogMapper personLogMapper;

    @Override
    public Page<DepartmentLogDetailVO> getPersonLog(Page<DepartmentLogDetailVO> page, Long departmentId, Date workDate, String logType, Long workTypeId) {

        String endDateSdf = "";
        String startDateSdf = "";
        //Date->LocalDate
        if(workDate != null){
            Instant instant = workDate.toInstant();
            ZoneId zoneId = ZoneId.systemDefault();
            LocalDate endDate = instant.atZone(zoneId).toLocalDate();
            endDateSdf = endDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            //周报
            if ("1".equals(logType)) {
                startDateSdf = endDate.minusDays(7).format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            } else {
                startDateSdf = endDateSdf;
            }
        }
        return personLogMapper.getPersonLogByDate(page, startDateSdf, endDateSdf, departmentId, workTypeId);
    }

    @Override
    public List<WorkTypeVO> queryWorkTypeTree(Map<String, Object> params) {
        List<WorkTypeVO> workTypeVOS = personLogMapper.queryWorkTypeTree(params);
        return workTypeVOS;
    }
}
