package com.ejianc.business.outputvalcount.service.impl;

import com.ejianc.business.outputvalcount.mapper.EsMapper;
import com.ejianc.business.outputvalcount.service.IEsService;
import com.ejianc.business.outputvalcount.vo.PaymentApplyVO;
import com.ejianc.business.outputvalcount.vo.SettlePoolVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;

/**
 * 校验信息
 *
 * @author generator
 */
@Service("esService")
public class EsServiceImpl implements IEsService {

    @Autowired
    private EsMapper esMapper;

    /**
     * 根据合同id查询当前合同下结算列表
     *
     * @param contractId 合同id
     * @return 查询结果
     */
    @Override
    public List<SettlePoolVO> queryDetailRecord(Long contractId) {
        return esMapper.queryDetailRecord(contractId);
    }

    @Override
    public List<SettlePoolVO> queryDetailRecordNoContract(Long projectId, Long supplierId) {
        return esMapper.queryDetailRecordNoContract(projectId, supplierId);
    }

    @Override
    public List<PaymentApplyVO> queryDetailRecord1(Long contractId) {
        return esMapper.queryDetailRecord1(contractId);
    }

    @Override
    public List<PaymentApplyVO> queryDetailRecordNoContract1(Long projectId, Long supplierId) {
        return esMapper.queryDetailRecordNoContract1(projectId, supplierId);
    }

    @Override
    public BigDecimal totalContract(Long tenantId, Long orgId) {
        return esMapper.totalContract(tenantId, orgId);
    }

    @Override
    public BigDecimal queryAmountMny(Long tenantId, Long orgId) {
        //两个表中的实付金额
        BigDecimal totalMny;
        BigDecimal actualMny = esMapper.actualMny(tenantId, orgId);
        BigDecimal applyMny = esMapper.applyMny(tenantId, orgId);
        if (applyMny == null) {
            applyMny = BigDecimal.ZERO;
        }
        if (actualMny == null) {
            actualMny = BigDecimal.ZERO;
        }
        totalMny = actualMny.add(applyMny);

        return totalMny;
    }

    @Override
    public List<PaymentApplyVO> queryApplyTaxMny(Long contractId) {
        return esMapper.queryApplyTaxMny(contractId);
    }

}
