package com.ejianc.business.worklog.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.worklog.bean.OrgIndexStatisticsDetailEntity;
/**
 * 指标线上化-指标达成统计
 * 
 * @author generator
 * 
 */
 @TableName("t_outputvalcount_org_index_statistics")
public class OrgIndexStatisticsEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="create_user_name")
    private String createUserName; // 编制人
    @TableField(value="operator_id")
    private Long operatorId; // 经办人ID
    @TableField(value="operator_name")
    private String operatorName; // 经办人姓名
    @TableField(value="update_user_name")
    private String updateUserName; // 修改者
    @TableField(value="remark")
    private String remark; // 备注
    @TableField(value="manage_type")
    private String manageType; // 管理模块
    @TableField(value="department_Id")
    private Long departmentId; // 责任部门
    @TableField(value="department_name")
    private String departmentName; // 责任部门名称
    @TableField(value="year")
    private Integer year; // 年份
    @TableField(value="service_date")
    private Date serviceDate;
    @TableField(value = "work_split")
    private String workSplit;
    @TableField(value = "index_remark")
    private String indexRemark;

    @TableField(exist=false)
    @SubEntity(serviceName="orgIndexStatisticsDetailService",pidName = "zhuId")
    private List<OrgIndexStatisticsDetailEntity> orgIndexStatisticsDetailList = new ArrayList<>(); // 指标线上化-指标达成统计详情
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public String getManageType() {
        return manageType;
    }

    public void setManageType(String manageType) {
        this.manageType = manageType;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public Integer getYear() {
        return year;
    }

    public void setYear(Integer year) {
        this.year = year;
    }
    

    public List<OrgIndexStatisticsDetailEntity> getOrgIndexStatisticsDetailList() {
        return orgIndexStatisticsDetailList;
    }

    public void setOrgIndexStatisticsDetailList(List<OrgIndexStatisticsDetailEntity> orgIndexStatisticsDetailList) {
        this.orgIndexStatisticsDetailList = orgIndexStatisticsDetailList;
    }

    public Date getServiceDate() {
        return serviceDate;
    }

    public void setServiceDate(Date serviceDate) {
        this.serviceDate = serviceDate;
    }

    public String getWorkSplit() {
        return workSplit;
    }

    public void setWorkSplit(String workSplit) {
        this.workSplit = workSplit;
    }

    public String getIndexRemark() {
        return indexRemark;
    }

    public void setIndexRemark(String indexRemark) {
        this.indexRemark = indexRemark;
    }
}
