package com.ejianc.business.worklog.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.worklog.bean.WorkPlanDayLogDetailEntity;
/**
 * 工作计划-日报
 * 
 * @author generator
 * 
 */
 @TableName("t_outputvalcount_work_plan_day_log")
public class WorkPlanDayLogEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="create_user_name")
    private String createUserName; // 编制人
    @TableField(value="operator_id")
    private Long operatorId; // 经办人ID
    @TableField(value="operator_name")
    private String operatorName; // 经办人姓名
    @TableField(value="update_user_name")
    private String updateUserName; // 修改者
    @TableField(value="remark")
    private String remark; // 备注
    @TableField(value="person_id")
    private Long personId; // 人员id
    @TableField(value="person_name")
    private String personName; // 人员名称
    @TableField(value="service_date")
    private Date serviceDate; // 统计日期
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="workPlanDayLogDetailService",pidName = "zhuId")
    private List<WorkPlanDayLogDetailEntity> workPlanDayLogDetailList = new ArrayList<>(); // 工作计划-日报详情
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public Long getPersonId() {
        return personId;
    }

    public void setPersonId(Long personId) {
        this.personId = personId;
    }
    public String getPersonName() {
        return personName;
    }

    public void setPersonName(String personName) {
        this.personName = personName;
    }
    public Date getServiceDate() {
        return serviceDate;
    }

    public void setServiceDate(Date serviceDate) {
        this.serviceDate = serviceDate;
    }
    

    public List<WorkPlanDayLogDetailEntity> getWorkPlanDayLogDetailList() {
        return workPlanDayLogDetailList;
    }

    public void setWorkPlanDayLogDetailList(List<WorkPlanDayLogDetailEntity> workPlanDayLogDetailList) {
        this.workPlanDayLogDetailList = workPlanDayLogDetailList;
    }
}
