package com.ejianc.business.outputvalcount.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.outputvalcount.bean.PayDetailSourceEntity;
import com.ejianc.business.outputvalcount.service.IPayDetailSourceService;
import com.ejianc.business.receipt.api.IReceiptRegisterApi;
import com.ejianc.business.receipt.vo.ReceiptRegisterVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.outputvalcount.mapper.PayOffMapper;
import com.ejianc.business.outputvalcount.bean.PayOffEntity;
import com.ejianc.business.outputvalcount.service.IPayOffService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

/**
 * 月度产值与统计-收款核销表
 * 
 * @author generator
 * 
 */
@Service("payOffService")
public class PayOffServiceImpl extends BaseServiceImpl<PayOffMapper, PayOffEntity> implements IPayOffService{


    @Autowired
    private IPayDetailSourceService payDetailSourceService;

    @Autowired
    private IReceiptRegisterApi receiptRegisterApi;

    @Autowired
    private IPayOffService payOffService;


    private Logger logger = LoggerFactory.getLogger(this.getClass());

    /**
     * @param projectId 项目id
     */
    @Override
    public void payOffByProjectId(Long projectId) {

        //未核销的收款登记
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("billState",new Parameter(QueryParam.IN, Arrays.asList(1,3)));
        queryParam.getParams().put("projectId",new Parameter(QueryParam.EQ, projectId));
        queryParam.getParams().put("unMny",new Parameter(QueryParam.GT, BigDecimal.ZERO));
        queryParam.getOrderMap().put("receiptDate",QueryParam.ASC);

        CommonResponse<List<ReceiptRegisterVO>> receiptResponse = receiptRegisterApi.queryReceiptRegisterList(queryParam);
        if(!receiptResponse.isSuccess()){
            throw new BusinessException("查询收款列表失败！");
        }
        List<ReceiptRegisterVO> receiptRegisterVOS = receiptResponse.getData();//收款列表
        logger.info("3.1---------查询收款列表数据为{}", JSONObject.toJSONString(receiptRegisterVOS));

        //未核销的应收中间库
        QueryParam payDetailParam = new QueryParam();
        payDetailParam.getParams().put("projectId",new Parameter(QueryParam.EQ, projectId));
        payDetailParam.getParams().put("unMny",new Parameter(QueryParam.GT, BigDecimal.ZERO));
        payDetailParam.getOrderMap().put("serviceDate",QueryParam.ASC);

        List<PayDetailSourceEntity> payDetailSourceEntities = payDetailSourceService.queryList(payDetailParam);//应收中间表
        logger.info("3.2---------查询应收中间库数据为{}", JSONObject.toJSONString(payDetailSourceEntities));
        List<PayOffEntity> payOffEntities = new ArrayList<>();//核销记录表
        List<ReceiptRegisterVO> changeReceiptRegisterVOS = new ArrayList<>();//回写收款列表

        for (int i = 0; i < payDetailSourceEntities.size();) {
            PayDetailSourceEntity detailSourceEntity = payDetailSourceEntities.get(i);
//            if(detailSourceEntity.getUnMny().compareTo(BigDecimal.ZERO) == 0){
//
//                throw new BusinessException("核销记录生成失败，存在已核销数据！");
//            }
            if(detailSourceEntity.getUnMny().compareTo(BigDecimal.ZERO) == 0){
                continue;
            }
            for (int j = 0; j < receiptRegisterVOS.size(); j++) {

                ReceiptRegisterVO receiptRegisterVO = receiptRegisterVOS.get(j);
                BigDecimal sumReceivedMny = receiptRegisterVO.getUnMny();//剩余未核销
                BigDecimal receiveMny = detailSourceEntity.getUnMny();//本次应收
                if(receiptRegisterVO.getUnMny().compareTo(BigDecimal.ZERO) == 0){
                    continue;
                }
                if(receiveMny.compareTo(sumReceivedMny) > 0){
                    //回写应收中间表数据
                    BigDecimal unMny = receiveMny.subtract(sumReceivedMny);//未收
                    detailSourceEntity.setUnMny(unMny);
                    detailSourceEntity.setActualMny(detailSourceEntity.getActualMny().add(sumReceivedMny));
                    logger.info("4.1---------回写应收中间表数据结果为{}", JSONObject.toJSONString(detailSourceEntity));
                    //生成核销记录
                    PayOffEntity payOffEntity = new PayOffEntity();
                    payOffEntity.setServiceDate(new Date());
                    payOffEntity.setPayRemarkId(detailSourceEntity.getPayRemarkId());
                    payOffEntity.setSourceId(detailSourceEntity.getId());
                    payOffEntity.setReceiveId(receiptRegisterVO.getId());
                    payOffEntity.setProjectId(detailSourceEntity.getProjectId());
                    payOffEntity.setProjectName(detailSourceEntity.getProjectName());

                    payOffEntity.setReceiveMny(receiveMny);
                    payOffEntity.setActualMny(sumReceivedMny);
                    payOffEntity.setUnMny(unMny);
                    payOffEntities.add(payOffEntity);
                    logger.info("4.2---------核销记录生成结果为{}", JSONObject.toJSONString(payOffEntity));
                    //回写收款记录
                    receiptRegisterVO.setUnMny(BigDecimal.ZERO);
                    changeReceiptRegisterVOS.add(receiptRegisterVO);
                    logger.info("4.3---------回写收款记录结果为{}", sumReceivedMny);
                } else if(receiveMny.compareTo(sumReceivedMny) < 0){
                    //回写应收中间表数据
                    BigDecimal unMny = BigDecimal.ZERO;//未收
                    detailSourceEntity.setUnMny(unMny);
                    detailSourceEntity.setActualMny(detailSourceEntity.getActualMny().add(sumReceivedMny));
                    logger.info("4.1---------回写应收中间表数据结果为{}", JSONObject.toJSONString(detailSourceEntity));



                    //回写收款记录
                    BigDecimal changeMny = sumReceivedMny.subtract(receiveMny);//差值
                    receiptRegisterVO.setUnMny(changeMny);
                    changeReceiptRegisterVOS.add(receiptRegisterVO);
                    logger.info("4.2---------回写收款记录结果为{}", sumReceivedMny);

                    //生成核销记录
                    PayOffEntity payOffEntity = new PayOffEntity();
                    payOffEntity.setServiceDate(new Date());
                    payOffEntity.setPayRemarkId(detailSourceEntity.getPayRemarkId());
                    payOffEntity.setSourceId(detailSourceEntity.getId());
                    payOffEntity.setReceiveId(receiptRegisterVO.getId());
                    payOffEntity.setProjectId(detailSourceEntity.getProjectId());
                    payOffEntity.setProjectName(detailSourceEntity.getProjectName());

                    payOffEntity.setReceiveMny(receiveMny);
                    payOffEntity.setActualMny(changeMny);
                    payOffEntity.setUnMny(unMny);
                    payOffEntities.add(payOffEntity);

                    logger.info("4.3---------核销记录生成结果为{}", JSONObject.toJSONString(payOffEntity));
                    break;
                } else {
                    //回写应收中间表数据
                    BigDecimal unMny = BigDecimal.ZERO;//未收
                    detailSourceEntity.setUnMny(unMny);
                    detailSourceEntity.setActualMny(detailSourceEntity.getActualMny().add(sumReceivedMny));
                    logger.info("4.1---------回写应收中间表数据结果为{}", JSONObject.toJSONString(detailSourceEntity));



                    //回写收款记录
                    BigDecimal changeMny = sumReceivedMny.subtract(receiveMny);//差值
                    receiptRegisterVO.setUnMny(changeMny);
                    changeReceiptRegisterVOS.add(receiptRegisterVO);
                    logger.info("4.2---------回写收款记录结果为{}", sumReceivedMny);

                    //生成核销记录
                    PayOffEntity payOffEntity = new PayOffEntity();
                    payOffEntity.setServiceDate(new Date());
                    payOffEntity.setPayRemarkId(detailSourceEntity.getPayRemarkId());
                    payOffEntity.setSourceId(detailSourceEntity.getId());
                    payOffEntity.setReceiveId(receiptRegisterVO.getId());
                    payOffEntity.setProjectId(detailSourceEntity.getProjectId());
                    payOffEntity.setProjectName(detailSourceEntity.getProjectName());

                    payOffEntity.setReceiveMny(receiveMny);
                    payOffEntity.setActualMny(changeMny);
                    payOffEntity.setUnMny(unMny);
                    payOffEntities.add(payOffEntity);

                    logger.info("4.3---------核销记录生成结果为{}", JSONObject.toJSONString(payOffEntity));
                    break;
                }

            }
        }


        logger.info("数据处理完毕，准备执行保存操作");
        if(ListUtil.isNotEmpty(payOffEntities)){
            payOffService.saveOrUpdateBatch(payOffEntities);
        }
        if(ListUtil.isNotEmpty(payDetailSourceEntities)){
            payDetailSourceService.saveOrUpdateBatch(payDetailSourceEntities);
        }
        if(ListUtil.isNotEmpty(receiptRegisterVOS)){
            receiptRegisterApi.saveOrUpdateReceiptRegisterList(receiptRegisterVOS);
        }
        logger.info("保存结束");
    }
}
