package com.ejianc.business.worklog.service.impl;

import com.ejianc.business.worklog.bean.WorkPlanPersonEntity;
import com.ejianc.business.worklog.bean.WorkPlanTaskEntity;
import com.ejianc.business.worklog.enums.PlanSourceTypeEnum;
import com.ejianc.business.worklog.service.IWorkPlanPersonService;
import com.ejianc.business.worklog.service.IWorkPlanTaskService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("workPlanPerson") 
public class WorkPlanPersonBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IWorkPlanPersonService planPersonService;

	@Autowired
	private IWorkPlanTaskService planTaskService;


	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {

		/**
		 * 推送工作任务
		 */
		WorkPlanPersonEntity planPersonEntity = planPersonService.selectById(billId);
		if(planPersonEntity != null){
			WorkPlanTaskEntity taskEntity = new WorkPlanTaskEntity();

			taskEntity.setOrgId(planPersonEntity.getOrgId());
			taskEntity.setOrgName(planPersonEntity.getOrgName());
			taskEntity.setCreateUserName(planPersonEntity.getCreateUserName());

			taskEntity.setSourceId(planPersonEntity.getId());
			taskEntity.setDutyPerson(planPersonEntity.getDutyPerson());
			taskEntity.setDutyPersonName(planPersonEntity.getDutyPersonName());
			taskEntity.setPlanStartData(planPersonEntity.getPlanStartData());
			taskEntity.setPlanEndDate(planPersonEntity.getPlanEndDate());
			taskEntity.setFinishFlag(planPersonEntity.getFinishFlag());
			taskEntity.setPlanName(planPersonEntity.getPlanName());
			taskEntity.setInnerCode(planPersonEntity.getInnerCode());
			taskEntity.setInnerName(planPersonEntity.getInnerName());
			taskEntity.setTargetRemark(planPersonEntity.getTargetRemark());
			taskEntity.setSourceType(PlanSourceTypeEnum.个人计划.getStatusName());
			taskEntity.setPlanType(planPersonEntity.getPlanType());
			planTaskService.saveOrUpdate(taskEntity);
			return CommonResponse.success();

		}
		return CommonResponse.error("存在空值错误！");
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("暂不允许撤回!");
	}

}
