package com.ejianc.business.worklog.controller;

import java.io.Serializable;

import com.alibaba.fastjson.JSON;
import com.ejianc.business.worklog.bean.PersonLogDetailEntity;
import com.ejianc.business.worklog.bean.PersonWorkTypeEntity;
import com.ejianc.business.worklog.bean.WorkTypeEntity;
import com.ejianc.business.worklog.service.IPersonWorkTypeService;
import com.ejianc.business.worklog.service.IWorkTypeService;
import com.ejianc.business.worklog.vo.DepartmentLogDetailVO;
import com.ejianc.business.worklog.vo.WorkTypeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.permission.vo.RoleUserRelationVO;
import com.ejianc.foundation.permission.vo.RoleVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.worklog.bean.PersonLogEntity;
import com.ejianc.business.worklog.service.IPersonLogService;
import com.ejianc.business.worklog.vo.PersonLogVO;

/**
 * 工作日志-个人工作日志
 *
 * @author generator
 */
@Controller
@RequestMapping("personLog")
public class PersonLogController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IPersonLogService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IPersonWorkTypeService personWorkTypeService;

    @Autowired
    private IRoleApi roleApi;

    @Autowired
    private IWorkTypeService workTypeService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PersonLogVO> saveOrUpdate(@RequestBody PersonLogVO saveOrUpdateVO) {
        PersonLogEntity entity = BeanMapper.map(saveOrUpdateVO, PersonLogEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        PersonLogVO vo = BeanMapper.map(entity, PersonLogVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PersonLogVO> queryDetail(Long id) {
        PersonLogEntity entity = service.selectById(id);
        List<PersonLogDetailEntity> personLogDetailList = entity.getPersonLogDetailList();
        if (ListUtil.isNotEmpty(personLogDetailList)) {
            for (PersonLogDetailEntity personLogDetailEntity : personLogDetailList) {
                WorkTypeEntity workTypeEntity = workTypeService.selectById(personLogDetailEntity.getWorkTypeId());
                String innerName = workTypeEntity.getInnerName();
                String[] innerNameArrays = innerName.split("-");
                innerName = "";
                for (int i = 1; i < innerNameArrays.length; i++) {
                    if (i == 1) {
                        innerName = innerNameArrays[i];
                    } else {
                        innerName = innerName + "-" + innerNameArrays[i];
                    }
                }
                personLogDetailEntity.setWorkTypeName(innerName);
            }
        }
        PersonLogVO vo = BeanMapper.map(entity, PersonLogVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PersonLogVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (PersonLogVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(PersonLogVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PersonLogVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("personName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            //普通组织
            commonOrgIds.add(org.getId());
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */


        Long userId = userContextCache.getUserId();
        Long deptId = userContextCache.getDeptId();
        Long employeeId = userContextCache.getEmployeeId();
        //以下角色不过滤，其他只能查看自己的日志
        Long roleId = 747409464501612595L;//员工日志-统一查看权限
        CommonResponse<List<RoleVO>> listCommonResponse = roleApi.queryRoleByUserId(userId);
        if (listCommonResponse.isSuccess()) {
            List<RoleVO> roleVOS = listCommonResponse.getData();
            long count = roleVOS.stream().filter(s -> s.getId().equals(roleId)).count();
            if(deptId != 1502571152969568257L){
                param.getParams().put("departmentId", new Parameter(QueryParam.EQ, deptId));
            }

            if (count == 0) {
                QueryParam personWorkTypeParam = new QueryParam();
                personWorkTypeParam.getParams().put("employeeId", new Parameter(QueryParam.EQ, userId));
                List<PersonWorkTypeEntity> personWorkTypeEntities = personWorkTypeService.queryList(personWorkTypeParam);
                List<Long> ids = personWorkTypeEntities.stream().map(PersonWorkTypeEntity::getId).collect(Collectors.toList());
                if(ListUtil.isNotEmpty(ids)){
                    param.getParams().put("personId", new Parameter(QueryParam.IN, ids));
                }
            }
        }


        IPage<PersonLogEntity> page = service.queryPage(param, false);
        IPage<PersonLogVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PersonLogVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<PersonLogEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("PersonLog-export.xlsx", beans, response);
    }

    /**
     * @param param
     * @Description 个人日志列表参照
     * @Return void
     */
    @RequestMapping(value = "/refPersonLogTreeData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<DepartmentLogDetailVO>> refPersonLogTreeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                             String condition,
                                                                             String searchObject,
                                                                             String searchText,
                                                                             String relyCondition) {

        Long departmentId = null;
        Date workDate = null;
        String logType = null;
        Long workTypeId = null;
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject con = JSONObject.parseObject(condition);
            if (null != con.get("departmentId")) {
                departmentId = con.getLong("departmentId");
            }
            if (null != con.get("workDate")) {
                workDate = con.getDate("workDate");
            }
            if (null != con.get("logType")) {
                logType = con.getString("logType");
            }
        }
        if (StringUtils.isNotEmpty(relyCondition)) {
            /** relyCondition */
            workTypeId = Long.parseLong(relyCondition.split("=")[1]);
        }

        //分页查询
        Page<DepartmentLogDetailVO> page = new Page<DepartmentLogDetailVO>(pageNumber, pageSize);
        Page<DepartmentLogDetailVO> pageData = service.getPersonLog(page, departmentId, workDate, logType, workTypeId);

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * 参照树----工作分类树
     *
     * @param condition
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/refPersonLogTree", method = RequestMethod.GET)
    @ResponseBody
    public List<Map<String, Object>> refPersonLogTree(@RequestParam(required = false) String condition,
                                                      @RequestParam(required = false) String searchText) {
        List<WorkTypeVO> dataList = null;
        try {
            Map<String, Object> params = new HashMap<>();
            if (StringUtils.isNotBlank(searchText)) {
                params.put("searchText", searchText);
                params.put("tenantId", InvocationInfoProxy.getTenantid());
            }
            if (StringUtils.isNotBlank(condition)) {
                /** 处理condition */
                JSONObject con = JSONObject.parseObject(condition);
                Long departmentId = con.getLong("departmentId");
                if (null != departmentId) {
                    params.put("departmentId", departmentId);
                }
            }
            dataList = service.queryWorkTypeTree(params);

            List<Map> maps = BeanMapper.mapList(dataList, Map.class);
//            List<Map> maps = new ArrayList<>();
            for (Map map : maps) {
                String name = map.get("workTypeName").toString();
                map.remove("workTypeName");
                map.put("name", name);

                String parentId = (map.get("lastTypeId") != null) ? map.get("lastTypeId").toString() : "";
                map.remove("lastTypeId");
                map.put("parentId", parentId);
            }
            logger.info("返回参照数据为{}", JSON.toJSONString(maps));
            return ResultAsTree.createTreeData(maps);
        } catch (Exception e) {
            logger.info("错误原因为{}", JSON.toJSONString(e));
            return null;
        }
    }

}
