package com.ejianc.business.worklog.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.worklog.mapper.WorkPlanMapper;
import com.ejianc.business.worklog.bean.WorkPlanEntity;
import com.ejianc.business.worklog.service.IWorkPlanService;

import java.util.ArrayList;
import java.util.List;

/**
 * 工作日志-工作计划
 * 
 * @author generator
 * 
 */
@Service("workPlanService")
public class WorkPlanServiceImpl extends BaseServiceImpl<WorkPlanMapper, WorkPlanEntity> implements IWorkPlanService{


    @Value("${msg.anentId}")
    private String anentId;
    @Value("${msg.secret}")
    private String secret;
    @Value("${msg.enUrl}")
    private String enUrl;

    @Autowired
    private IPushMessageApi pushMessageApi;

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Override
    public boolean sendMsg(WorkPlanEntity entity) {

        String operatorId = entity.getOperatorId();
        String operatorName = entity.getOperatorName();

        String[] userIds = operatorId.split(",");
        String[] userNames = operatorName.split(",");

        String subject = "您有一项新的工作计划！";
        String content = "任务名称：" + entity.getProjectName()
                + "\n计划开始时间：" + DateUtil.formatDate(entity.getRegistTime())
                + "\n计划完成时间:" + DateUtil.formatDate(entity.getEndTime());
        String pcUrl = "/zzyj-outputvalcount-frontend/#/article/card?id=" + entity.getId();

        /**
         * 发送消息
         */
        for (int i = 0; i < userIds.length; i++) {
            String userId = userIds[i];
            String userName = userNames[i];
            /**
             * 如果创建人和主控人一致，则不用发送消息
             */
            if (!userName.equals(entity.getCreateUserName())) {
                continue;
            }
            String moUrl = enUrl + "/portal/sso/index?&userid=" + userId +
                    "&targeturl=" + enUrl + "/zzyj-outputvalcount-frontend/#/article/card?id=" + entity.getId();
            PushMsgParameter parameter = new PushMsgParameter();
            List<String> channel = new ArrayList<>();
            channel.add(PushMsgParameter.CHANNEL_TYPE_WEXINEE);//发送企业微信标志
            channel.add(PushMsgParameter.CHANNEL_TYPE_SYS);//
            String[] receivers = {userId};
            parameter.setReceivers(receivers);// 收信人
            parameter.setChannel(channel.toArray(new String[channel.size()]));// 消息类型
            parameter.setMsgType("notice");//预警消息
            parameter.setSubject(content);// 标题
            parameter.setContent(content);// 内容
            parameter.setPcUrl(pcUrl);// pc端url
            parameter.setMobileUrl(moUrl);// 移动端url
            parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
            parameter.setSendUserId(InvocationInfoProxy.getUserid());
            JSONObject weixineeParams = new JSONObject();
            weixineeParams.put("agentid", anentId);//企业微信应用id
            weixineeParams.put("secret", secret);//企业微信secret
            weixineeParams.put("msgtype", "textcard");
            weixineeParams.put("title", subject);
            weixineeParams.put("description", content);
            weixineeParams.put("url", (enUrl + "/portal/sso/index?&userid=" + userId +
                    "&targeturl=" + enUrl + "/zzyj-outputvalcount-frontend/#/article/card?id=" + entity.getId()));//移动端点击的urlweixineeParams.put("btntxt", "点击查看");
            parameter.setWeixineeParams(weixineeParams);

            CommonResponse<String> result = pushMessageApi.pushMessage(parameter);
            if (result.isSuccess()) {
                logger.error("消息发送成功---------------->" + result.getMsg());
            } else {
                logger.error("消息发送失败---------------->" + result.getMsg());
            }
        }

        return true;

    }
}
