package com.ejianc.business.outputvalcount.controller;

import java.io.*;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import okhttp3.*;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.checkerframework.checker.units.qual.C;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.security.MessageDigest;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.DatatypeConverter;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.outputvalcount.bean.CreditScoreEntity;
import com.ejianc.business.outputvalcount.service.ICreditScoreService;
import com.ejianc.business.outputvalcount.vo.CreditScoreVO;

import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * 信用分
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("creditScore")
public class CreditScoreController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private ICreditScoreService service;


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CreditScoreVO> saveOrUpdate(@RequestBody CreditScoreVO saveOrUpdateVO) {
    	CreditScoreEntity entity = BeanMapper.map(saveOrUpdateVO, CreditScoreEntity.class);
    	service.saveOrUpdate(entity, false);
    	CreditScoreVO vo = BeanMapper.map(entity, CreditScoreVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CreditScoreVO> queryDetail(Long id) {
    	CreditScoreEntity entity = service.selectById(id);
    	CreditScoreVO vo = BeanMapper.map(entity, CreditScoreVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CreditScoreVO> vos) {
        service.removeByIds(vos.stream().map(CreditScoreVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CreditScoreVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        IPage<CreditScoreEntity> page = service.queryPage(param,false);

        for (CreditScoreEntity record : page.getRecords()) {
            record.setBillCode(record.getId()+"");
        }
        IPage<CreditScoreVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), CreditScoreVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<CreditScoreEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("CreditScore-export.xlsx", beans, response);
    }



    public static void main(String[] args) {
//        String html = sendGetRequest();
//        String value1 = "项目经理平均考勤率";
//        String value2 = "建筑工人平均考勤率";
//        String td1 = "<td>";
//        String td2 = "</td>";
//        int i1 = html.indexOf(value1) + value1.length();
//        String substring1 = html.substring(i1+30, i1 + 45);
//        String substring = substring1.substring(substring1.indexOf(td1) + td1.length(), substring1.indexOf(td2));
//        System.out.println(substring);//项目经理平均考勤率
//
//        int i2 = html.indexOf(value2) + value2.length();
//        String substring2 = html.substring(i2+30, i2 + 45);
//        substring = substring2.substring(substring2.indexOf(td1) + td1.length(), substring2.indexOf(td2));
//        System.out.println(substring);//建筑工人平均考勤率


        String s = send2();
        JSONObject jsonObject = JSONObject.parseObject(s);
        JSONArray rows = jsonObject.getJSONArray("rows");
        JSONObject jsonObject1 = rows.getJSONObject(5);
        Integer score = jsonObject1.getInteger("score");
        System.out.println(score);
    }



    /**
     * @Description queryList 同步信用分
     * @param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryCreditScore", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<JSONObject>> queryEndList(HttpServletRequest request) {
        logger.info("开始获取信用分以及考勤率---------------->");
        QueryParam param = new QueryParam();
        param.setPageIndex(1);
        param.setPageSize(1);
        param.getOrderMap().put("id","DESC");

        List<CreditScoreEntity> creditScoreEntities = service.queryList(param);

        //信用分
        //String s = send2();
        //JSONObject jsonObject = JSONObject.parseObject(s);
       // JSONArray rows = jsonObject.getJSONArray("rows");
        //JSONObject jsonObject1 = rows.getJSONObject(5);
        //Integer score = jsonObject1.getInteger("score");

        //考勤率
        String html = sendGetRequest();
        String value1 = "项目经理平均考勤率";
        String value2 = "建筑工人平均考勤率";
        String td1 = "<td>";
        String td2 = "</td>";
        int i1 = html.indexOf(value1) + value1.length();
        String substring1 = html.substring(i1+30, i1 + 45);
        String substring = substring1.substring(substring1.indexOf(td1) + td1.length(), substring1.indexOf(td2));
        //System.out.println(substring);//项目经理平均考勤率

        int i2 = html.indexOf(value2) + value2.length();
        String substring2 = html.substring(i2+30, i2 + 45);
        String substring3 = substring2.substring(substring2.indexOf(td1) + td1.length(), substring2.indexOf(td2));
        //System.out.println(substring);//建筑工人平均考勤率

        LocalDate today = LocalDate.now(); // 获取今天的日期
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd"); // 定义日期格式
        String dateString = today.format(formatter); // 将日期转换为字符串

        CreditScoreEntity entity = new CreditScoreEntity();
        //entity.setCreditScore(new BigDecimal(score));
        entity.setRateOfAttendanceManager(substring);
        entity.setRateOfAttendanceWorker(substring3);
        entity.setId(Long.parseLong(dateString));
        if (CollectionUtils.isNotEmpty(creditScoreEntities)){
            entity.setCreditScore(creditScoreEntities.get(0).getCreditScore());
            entity.setRank(creditScoreEntities.get(0).getRank());
        }
        service.saveOrUpdate(entity, false);

        return CommonResponse.success("执行成功！");
    }
    public static String sendGetRequest() {
        String responseObiect="";
        try {
            String merchant = "ZZYJ" ; // 筑材网提供的商户代码
            Long timestamp = System.currentTimeMillis();
            StringBuilder sb = new StringBuilder();
            sb.append(merchant).append(timestamp);
            String param = sb.toString();
            String str = "10840e1aeebc84523cc2f8904dd1d9f9" + param;  // key为筑材网提供
            String sign = "";
            try {
                MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
                byte[] dst = sha1.digest(str.getBytes("utf-8"));
                sign = DatatypeConverter.printHexBinary(dst);
            } catch (Exception e) {
                throw new BusinessException("参数加密异常:", e);
            }

            URL url = new URL("http://hngcjs.hnjs.henan.gov.cn/company/enterpriseDetail?corpcode=91410100170051898Y&corpname=%E9%83%91%E5%B7%9E%E4%B8%80%E5%BB%BA%E9%9B%86%E5%9B%A2%E6%9C%89%E9%99%90%E5%85%AC%E5%8F%B8&certType=");
            HttpURLConnection connection = (HttpURLConnection) url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Content-Type", "application/json");
            // 在Header中添加参数
//            connection.setRequestProperty("merchant", merchant);
//            connection.setRequestProperty("timestamp", timestamp.toString());
//            connection.setRequestProperty("sign", sign);
            //connection.setDoOutput(true);

            // 发送请求并获取响应
            int responseCode = connection.getResponseCode();

            // 检查响应是否成功
            if (responseCode == HttpURLConnection.HTTP_OK) {
                // 读取响应数据
                InputStream inputStream = connection.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                String line;
                StringBuilder response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
                reader.close();
                inputStream.close();
                // 处理响应数据
                String responseBody = response.toString();
                responseObiect = responseBody;
            } else {
                throw new BusinessException("Request failed. Response Code: " + responseCode);
            }
            // 关闭连接
            connection.disconnect();
        } catch (MalformedURLException e) {
            e.printStackTrace();
        } catch (ProtocolException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }

        return responseObiect;
    }

public static String send2(){
    Unirest.setTimeouts(0, 0);
    try {
        HttpResponse<String> response = Unirest.post("http://hngcjs.hnjs.henan.gov.cn/companyTab/compQualificationList")
                .header("Cookie", "JSESSIONID=abba6cd9-0417-4b75-839c-a2fd2ba01c99")
                //.multiPartContent()
                .field("corpcode", "91410100170051898Y")
                .field("corpname", "郑州一建集团有限公司")
                .asString();
        String body = response.getBody();
        //System.out.println(body);
        return body;

    } catch (UnirestException e) {
        e.printStackTrace();
    }
    return "";
}
}
