/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.common.validator;

import com.gccloud.common.exception.GlobalException;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidatorUtils {
    private static final Logger log = LoggerFactory.getLogger(ValidatorUtils.class);
    private static Validator validator = Validation.buildDefaultValidatorFactory().getValidator();

    public ValidatorUtils() {
        throw new IllegalStateException("\u4e0d\u5141\u8bb8\u521b\u5efa");
    }

    public static void validateEntity(Object object, Class<?> ... groups) throws GlobalException {
        Set constraintViolations = validator.validate(object, (Class[])groups);
        if (!constraintViolations.isEmpty()) {
            ArrayList errorList = Lists.newArrayList();
            for (ConstraintViolation constraint : constraintViolations) {
                errorList.add(constraint.getMessage());
            }
            String message = Joiner.on((String)"<br/>").join((Iterable)errorList);
            log.error(message);
            throw new GlobalException(message);
        }
    }
}

