/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.dataset.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.gccloud.common.entity.SuperEntity;
import com.gccloud.common.exception.GlobalException;
import com.gccloud.common.service.ISuperService;
import com.gccloud.common.utils.BeanConvertUtils;
import com.gccloud.common.vo.PageVO;
import com.gccloud.dataset.dto.DatasetParamDTO;
import com.gccloud.dataset.dto.DatasetSearchDTO;
import com.gccloud.dataset.dto.TestExecuteDTO;
import com.gccloud.dataset.entity.DatasetEntity;
import com.gccloud.dataset.entity.config.BaseDataSetConfig;
import com.gccloud.dataset.vo.DataVO;
import com.gccloud.dataset.vo.DatasetInfoVO;
import com.gccloud.dataset.vo.DeleteCheckVO;
import com.github.benmanes.caffeine.cache.AsyncCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface IBaseDataSetService
extends ISuperService<DatasetEntity> {
    public static final Logger log = LoggerFactory.getLogger(IBaseDataSetService.class);
    public static final AsyncCache<String, Object> DATASET_CACHE = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).buildAsync();
    public static final AsyncCache<String, DatasetEntity> DATASET_ENTITY_CACHE = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).buildAsync();
    public static final AsyncCache<String, DatasetInfoVO> DATASET_INFO_CACHE = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).buildAsync();

    default public List<DatasetEntity> getList(DatasetSearchDTO searchDTO) {
        return this.list((Wrapper)this.getQueryWrapper(searchDTO));
    }

    default public PageVO<DatasetEntity> getPage(DatasetSearchDTO searchDTO) {
        return this.page(searchDTO, this.getQueryWrapper(searchDTO));
    }

    default public LambdaQueryWrapper<DatasetEntity> getQueryWrapper(DatasetSearchDTO searchDTO) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.like(StringUtils.isNotBlank((CharSequence)searchDTO.getName()), DatasetEntity::getName, (Object)searchDTO.getName());
        queryWrapper.eq(StringUtils.isNotBlank((CharSequence)searchDTO.getTypeId()), DatasetEntity::getTypeId, (Object)searchDTO.getTypeId());
        queryWrapper.in(CollectionUtils.isNotEmpty(searchDTO.getDatasetType()), DatasetEntity::getDatasetType, searchDTO.getDatasetType());
        queryWrapper.eq(StringUtils.isNotBlank((CharSequence)searchDTO.getSourceId()), DatasetEntity::getSourceId, (Object)searchDTO.getSourceId());
        if (searchDTO.getDatasetIds() != null && searchDTO.getDatasetIds().size() > 0) {
            queryWrapper.in(SuperEntity::getId, searchDTO.getDatasetIds());
        }
        queryWrapper.orderByDesc(SuperEntity::getUpdateDate);
        return queryWrapper;
    }

    default public String add(DatasetEntity entity) {
        if (StringUtils.isBlank((CharSequence)entity.getCode())) {
            entity.setCode(RandomStringUtils.randomAlphabetic((int)10));
        }
        this.save((Object)entity);
        return entity.getId();
    }

    default public void update(DatasetEntity entity) {
        this.updateById((Object)entity);
        DATASET_CACHE.synchronous().invalidate((Object)entity.getId());
        DATASET_ENTITY_CACHE.synchronous().invalidate((Object)entity.getId());
        DATASET_INFO_CACHE.synchronous().invalidate((Object)entity.getId());
    }

    default public void delete(String id) {
        this.removeById((Serializable)((Object)id));
        DATASET_CACHE.synchronous().invalidate((Object)id);
        DATASET_ENTITY_CACHE.synchronous().invalidate((Object)id);
        DATASET_INFO_CACHE.synchronous().invalidate((Object)id);
    }

    default public DeleteCheckVO deleteCheck(String id) {
        return new DeleteCheckVO();
    }

    default public boolean checkNameRepeat(String id, String name) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.select((Object[])new SFunction[]{SuperEntity::getId});
        queryWrapper.eq(DatasetEntity::getName, (Object)name);
        queryWrapper.ne(StringUtils.isNotBlank((CharSequence)id), SuperEntity::getId, (Object)id);
        return this.list((Wrapper)queryWrapper).size() > 0;
    }

    default public DatasetInfoVO getInfoById(String id) {
        CompletableFuture future = DATASET_INFO_CACHE.get((Object)id, key -> {
            DatasetEntity entity = this.getByIdFromCache(id);
            DatasetInfoVO datasetInfoVO = (DatasetInfoVO)BeanConvertUtils.convert((Object)((Object)entity), DatasetInfoVO.class);
            BaseDataSetConfig config = entity.getConfig();
            datasetInfoVO.setFields(config.getFieldList());
            datasetInfoVO.setParams(config.getParamsList());
            return datasetInfoVO;
        });
        try {
            return (DatasetInfoVO)future.get();
        }
        catch (Exception exception) {
            DatasetEntity entity = this.getByIdFromCache(id);
            DatasetInfoVO datasetInfoVO = (DatasetInfoVO)BeanConvertUtils.convert((Object)((Object)entity), DatasetInfoVO.class);
            BaseDataSetConfig config = entity.getConfig();
            datasetInfoVO.setFields(config.getFieldList());
            datasetInfoVO.setParams(config.getParamsList());
            return datasetInfoVO;
        }
    }

    default public DatasetEntity getByIdFromCache(String id) {
        CompletableFuture future = DATASET_ENTITY_CACHE.get((Object)id, key -> {
            DatasetEntity entity = (DatasetEntity)((Object)((Object)this.getById((Serializable)((Object)id))));
            return entity;
        });
        try {
            return (DatasetEntity)((Object)future.get());
        }
        catch (Exception e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
            DatasetEntity entity = (DatasetEntity)((Object)this.getById((Serializable)((Object)id)));
            DATASET_ENTITY_CACHE.put((Object)id, CompletableFuture.completedFuture(entity));
            return entity;
        }
    }

    default public DatasetEntity getByCode(String code) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DatasetEntity::getCode, (Object)code);
        List list = this.list((Wrapper)queryWrapper);
        if (list.isEmpty()) {
            throw new GlobalException("\u6570\u636e\u96c6\u4e0d\u5b58\u5728");
        }
        if (list.size() > 1) {
            throw new GlobalException("\u6570\u636e\u96c6\u7f16\u7801\u91cd\u590d");
        }
        return (DatasetEntity)((Object)list.get(0));
    }

    default public boolean checkBackendExecutionNeeded(String datasetId) {
        return true;
    }

    default public PageVO<Object> execute(String id, List<DatasetParamDTO> params, int current, int size) {
        return null;
    }

    public Object execute(String var1, List<DatasetParamDTO> var2);

    default public DataVO execute(TestExecuteDTO executeDTO) {
        return null;
    }
}

