/*
 * Decompiled with CFR 0.152.
 */
package com.power.common.util;

import com.power.common.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexUtil {
    public static boolean isMatches(Collection<String> patterns, String str) {
        if (Objects.isNull(patterns)) {
            return false;
        }
        for (String patternStr : patterns) {
            Pattern pattern = Pattern.compile(patternStr);
            if (!pattern.matcher(str).matches()) continue;
            return true;
        }
        return false;
    }

    public static boolean isMatches(String patterns, String str) {
        if (StringUtil.isNotEmpty(patterns)) {
            List<String> patternList = Arrays.asList(patterns.split(";", 0));
            return RegexUtil.isMatches(patternList, str);
        }
        return false;
    }

    public static List<String> extractStrings(String pattern, String msg) {
        Matcher matcher = Pattern.compile(pattern).matcher(msg);
        ArrayList<String> result = new ArrayList<String>();
        while (matcher.find()) {
            int len = matcher.groupCount();
            for (int i = 1; i <= len; ++i) {
                String a = matcher.group(i);
                result.add(a);
            }
        }
        return result;
    }
}

