/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.cert;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERString;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.X509DefaultEntryConverter;
import org.bouncycastle.asn1.x509.X509NameEntryConverter;
import org.bouncycastle.asn1.x509.X509NameTokenizer;

public class X509Name
extends ASN1Encodable {
    public static final DERObjectIdentifier C = new DERObjectIdentifier("2.5.4.6");
    public static final DERObjectIdentifier O = new DERObjectIdentifier("2.5.4.10");
    public static final DERObjectIdentifier OU = new DERObjectIdentifier("2.5.4.11");
    public static final DERObjectIdentifier T = new DERObjectIdentifier("2.5.4.12");
    public static final DERObjectIdentifier CN = new DERObjectIdentifier("2.5.4.3");
    public static final DERObjectIdentifier SN = new DERObjectIdentifier("2.5.4.5");
    public static final DERObjectIdentifier STREET = new DERObjectIdentifier("2.5.4.9");
    public static final DERObjectIdentifier SERIALNUMBER = SN;
    public static final DERObjectIdentifier L = new DERObjectIdentifier("2.5.4.7");
    public static final DERObjectIdentifier ST = new DERObjectIdentifier("2.5.4.8");
    public static final DERObjectIdentifier SURNAME = new DERObjectIdentifier("2.5.4.4");
    public static final DERObjectIdentifier GIVENNAME = new DERObjectIdentifier("2.5.4.42");
    public static final DERObjectIdentifier INITIALS = new DERObjectIdentifier("2.5.4.43");
    public static final DERObjectIdentifier GENERATION = new DERObjectIdentifier("2.5.4.44");
    public static final DERObjectIdentifier UNIQUE_IDENTIFIER = new DERObjectIdentifier("2.5.4.45");
    public static final DERObjectIdentifier BUSINESS_CATEGORY = new DERObjectIdentifier("2.5.4.15");
    public static final DERObjectIdentifier POSTAL_CODE = new DERObjectIdentifier("2.5.4.17");
    public static final DERObjectIdentifier DN_QUALIFIER = new DERObjectIdentifier("2.5.4.46");
    public static final DERObjectIdentifier PSEUDONYM = new DERObjectIdentifier("2.5.4.65");
    public static final DERObjectIdentifier DATE_OF_BIRTH = new DERObjectIdentifier("1.3.6.1.5.5.7.9.1");
    public static final DERObjectIdentifier PLACE_OF_BIRTH = new DERObjectIdentifier("1.3.6.1.5.5.7.9.2");
    public static final DERObjectIdentifier GENDER = new DERObjectIdentifier("1.3.6.1.5.5.7.9.3");
    public static final DERObjectIdentifier COUNTRY_OF_CITIZENSHIP = new DERObjectIdentifier("1.3.6.1.5.5.7.9.4");
    public static final DERObjectIdentifier COUNTRY_OF_RESIDENCE = new DERObjectIdentifier("1.3.6.1.5.5.7.9.5");
    public static final DERObjectIdentifier NAME_AT_BIRTH = new DERObjectIdentifier("1.3.36.8.3.14");
    public static final DERObjectIdentifier POSTAL_ADDRESS = new DERObjectIdentifier("2.5.4.16");
    public static final DERObjectIdentifier TELEPHONE_NUMBER = new DERObjectIdentifier("2.5.4.20");
    public static final DERObjectIdentifier EmailAddress = PKCSObjectIdentifiers.pkcs_9_at_emailAddress;
    public static final DERObjectIdentifier UnstructuredName = PKCSObjectIdentifiers.pkcs_9_at_unstructuredName;
    public static final DERObjectIdentifier UnstructuredAddress = PKCSObjectIdentifiers.pkcs_9_at_unstructuredAddress;
    public static final DERObjectIdentifier E = EmailAddress;
    public static final DERObjectIdentifier DC = new DERObjectIdentifier("0.9.2342.19200300.100.1.25");
    public static final DERObjectIdentifier UID = new DERObjectIdentifier("0.9.2342.19200300.100.1.1");
    public static Hashtable OIDLookUp = new Hashtable();
    public static boolean DefaultReverse = false;
    public static Hashtable DefaultSymbols = OIDLookUp;
    public static Hashtable RFC2253Symbols = new Hashtable();
    public static Hashtable SymbolLookUp = new Hashtable();
    public static Hashtable DefaultLookUp = SymbolLookUp;
    private X509NameEntryConverter converter = null;
    private Vector ordering = new Vector();
    private Vector values = new Vector();
    private Vector added = new Vector();
    private ASN1Sequence seq;

    static {
        DefaultSymbols.put(C, "C");
        DefaultSymbols.put(O, "O");
        DefaultSymbols.put(T, "T");
        DefaultSymbols.put(OU, "OU");
        DefaultSymbols.put(CN, "CN");
        DefaultSymbols.put(L, "L");
        DefaultSymbols.put(ST, "S");
        DefaultSymbols.put(SN, "SERIALNUMBER");
        DefaultSymbols.put(EmailAddress, "E");
        DefaultSymbols.put(DC, "DC");
        DefaultSymbols.put(UID, "UID");
        DefaultSymbols.put(STREET, "STREET");
        DefaultSymbols.put(SURNAME, "SN");
        DefaultSymbols.put(GIVENNAME, "G");
        DefaultSymbols.put(INITIALS, "I");
        DefaultSymbols.put(GENERATION, "GENERATION");
        DefaultSymbols.put(UnstructuredAddress, "unstructuredAddress");
        DefaultSymbols.put(UnstructuredName, "unstructuredName");
        DefaultSymbols.put(UNIQUE_IDENTIFIER, "UniqueIdentifier");
        DefaultSymbols.put(DN_QUALIFIER, "dnQualifier");
        DefaultSymbols.put(PSEUDONYM, "Pseudonym");
        DefaultSymbols.put(POSTAL_ADDRESS, "PostalAddress");
        DefaultSymbols.put(NAME_AT_BIRTH, "NameAtBirth");
        DefaultSymbols.put(COUNTRY_OF_CITIZENSHIP, "CountryOfCitizenship");
        DefaultSymbols.put(COUNTRY_OF_RESIDENCE, "CountryOfResidence");
        DefaultSymbols.put(GENDER, "Gender");
        DefaultSymbols.put(PLACE_OF_BIRTH, "PlaceOfBirth");
        DefaultSymbols.put(DATE_OF_BIRTH, "DateOfBirth");
        DefaultSymbols.put(POSTAL_CODE, "PostalCode");
        DefaultSymbols.put(BUSINESS_CATEGORY, "BusinessCategory");
        DefaultSymbols.put(TELEPHONE_NUMBER, "Phone");
        RFC2253Symbols.put(C, "C");
        RFC2253Symbols.put(O, "O");
        RFC2253Symbols.put(T, "T");
        RFC2253Symbols.put(OU, "OU");
        RFC2253Symbols.put(CN, "CN");
        RFC2253Symbols.put(L, "L");
        RFC2253Symbols.put(ST, "ST");
        RFC2253Symbols.put(SN, "SN");
        RFC2253Symbols.put(EmailAddress, "EMAILADDRESS");
        RFC2253Symbols.put(DC, "DC");
        RFC2253Symbols.put(UID, "UID");
        RFC2253Symbols.put(SURNAME, "SURNAME");
        RFC2253Symbols.put(GIVENNAME, "GIVENNAME");
        RFC2253Symbols.put(INITIALS, "INITIALS");
        RFC2253Symbols.put(GENERATION, "GENERATION");
        DefaultLookUp.put("c", C);
        DefaultLookUp.put("o", O);
        DefaultLookUp.put("t", T);
        DefaultLookUp.put("ou", OU);
        DefaultLookUp.put("cn", CN);
        DefaultLookUp.put("l", L);
        DefaultLookUp.put("st", ST);
        DefaultLookUp.put("sn", SN);
        DefaultLookUp.put("emailaddress", E);
        DefaultLookUp.put("dc", DC);
        DefaultLookUp.put("e", E);
        DefaultLookUp.put("uid", UID);
        DefaultLookUp.put("surname", SURNAME);
        DefaultLookUp.put("givenname", GIVENNAME);
        DefaultLookUp.put("initials", INITIALS);
        DefaultLookUp.put("generation", GENERATION);
        DefaultLookUp.put("unstructuredaddress", UnstructuredAddress);
        DefaultLookUp.put("unstructuredname", UnstructuredName);
    }

    public static X509Name getInstance(ASN1TaggedObject obj, boolean explicit) {
        return X509Name.getInstance(ASN1Sequence.getInstance((ASN1TaggedObject)obj, (boolean)explicit));
    }

    public static X509Name getInstance(Object obj) {
        if (obj == null || obj instanceof X509Name) {
            return (X509Name)((Object)obj);
        }
        if (obj instanceof ASN1Sequence) {
            return new X509Name((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public X509Name(ASN1Sequence seq) {
        this.seq = seq;
        Enumeration e = seq.getObjects();
        while (e.hasMoreElements()) {
            ASN1Set set = (ASN1Set)e.nextElement();
            int i = 0;
            while (i < set.size()) {
                ASN1Sequence s = (ASN1Sequence)set.getObjectAt(i);
                this.ordering.addElement(s.getObjectAt(0));
                this.values.addElement(((DERString)s.getObjectAt(1)).getString());
                this.added.addElement(i != 0 ? new Boolean(true) : new Boolean(false));
                ++i;
            }
        }
    }

    public X509Name(Hashtable attributes) {
        this(null, attributes);
    }

    public X509Name(Vector ordering, Hashtable attributes) {
        this(ordering, attributes, new X509DefaultEntryConverter());
    }

    public X509Name(Vector ordering, Hashtable attributes, X509DefaultEntryConverter converter) {
        this.converter = converter;
        if (ordering != null) {
            int i = 0;
            while (i != ordering.size()) {
                this.ordering.addElement(ordering.elementAt(i));
                this.added.addElement(new Boolean(false));
                ++i;
            }
        } else {
            Enumeration e = attributes.keys();
            while (e.hasMoreElements()) {
                this.ordering.addElement(e.nextElement());
                this.added.addElement(new Boolean(false));
            }
        }
        int i = 0;
        while (i != this.ordering.size()) {
            DERObjectIdentifier oid = (DERObjectIdentifier)this.ordering.elementAt(i);
            if (attributes.get(oid) == null) {
                throw new IllegalArgumentException("No attribute for object id - " + oid.getId() + " - passed to distinguished name");
            }
            this.values.addElement(attributes.get(oid));
            ++i;
        }
    }

    public X509Name(Vector oids, Vector values) {
        this(oids, values, (X509NameEntryConverter)new X509DefaultEntryConverter());
    }

    public X509Name(Vector oids, Vector values, X509NameEntryConverter converter) {
        this.converter = converter;
        if (oids.size() != values.size()) {
            throw new IllegalArgumentException("oids vector must be same length as values.");
        }
        int i = 0;
        while (i < oids.size()) {
            this.ordering.addElement(oids.elementAt(i));
            this.values.addElement(values.elementAt(i));
            this.added.addElement(new Boolean(false));
            ++i;
        }
    }

    public X509Name(String dirName) {
        this(DefaultReverse, DefaultLookUp, dirName);
    }

    public X509Name(String dirName, X509NameEntryConverter converter) {
        this(DefaultReverse, DefaultLookUp, dirName, converter);
    }

    public X509Name(boolean reverse, String dirName) {
        this(reverse, DefaultLookUp, dirName);
    }

    public X509Name(boolean reverse, String dirName, X509NameEntryConverter converter) {
        this(reverse, DefaultLookUp, dirName, converter);
    }

    public X509Name(boolean reverse, Hashtable lookUp, String dirName) {
        this(reverse, lookUp, dirName, (X509NameEntryConverter)new X509DefaultEntryConverter());
    }

    private DERObjectIdentifier decodeOID(String name, Hashtable lookUp) {
        if (name.toUpperCase().startsWith("OID.")) {
            return new DERObjectIdentifier(name.substring(4));
        }
        if (name.charAt(0) >= '0' && name.charAt(0) <= '9') {
            return new DERObjectIdentifier(name);
        }
        DERObjectIdentifier oid = (DERObjectIdentifier)lookUp.get(name.toLowerCase());
        if (oid == null) {
            throw new IllegalArgumentException("Unknown object id - " + name + " - passed to distinguished name");
        }
        return oid;
    }

    public X509Name(boolean reverse, Hashtable lookUp, String dirName, X509NameEntryConverter converter) {
        this.converter = converter;
        X509NameTokenizer nTok = new X509NameTokenizer(dirName);
        while (nTok.hasMoreTokens()) {
            String token = nTok.nextToken();
            int index = token.indexOf(61);
            if (index == -1) {
                throw new IllegalArgumentException("badly formated directory string");
            }
            String name = token.substring(0, index);
            String value = token.substring(index + 1);
            DERObjectIdentifier oid = this.decodeOID(name, lookUp);
            if (value.indexOf(43) > 0) {
                X509NameTokenizer vTok = new X509NameTokenizer(value, '+');
                this.ordering.addElement(oid);
                this.values.addElement(vTok.nextToken());
                this.added.addElement(new Boolean(false));
                while (vTok.hasMoreTokens()) {
                    String sv = vTok.nextToken();
                    int ndx = sv.indexOf(61);
                    String nm = sv.substring(0, ndx);
                    String vl = sv.substring(ndx + 1);
                    this.ordering.addElement(this.decodeOID(nm, lookUp));
                    this.values.addElement(vl);
                    this.added.addElement(new Boolean(true));
                }
                continue;
            }
            this.ordering.addElement(oid);
            this.values.addElement(value);
            this.added.addElement(new Boolean(false));
        }
        if (reverse) {
            Vector o = new Vector();
            Vector v = new Vector();
            Vector a = new Vector();
            int i = this.ordering.size() - 1;
            while (i >= 0) {
                o.addElement(this.ordering.elementAt(i));
                v.addElement(this.values.elementAt(i));
                a.addElement(this.added.elementAt(i));
                --i;
            }
            this.ordering = o;
            this.values = v;
            this.added = a;
        }
    }

    public Vector getOIDs() {
        Vector v = new Vector();
        int i = 0;
        while (i != this.ordering.size()) {
            v.addElement(this.ordering.elementAt(i));
            ++i;
        }
        return v;
    }

    public Vector getValues() {
        Vector v = new Vector();
        int i = 0;
        while (i != this.values.size()) {
            v.addElement(this.values.elementAt(i));
            ++i;
        }
        return v;
    }

    public DERObject toASN1Object() {
        if (this.seq == null) {
            ASN1EncodableVector vec = new ASN1EncodableVector();
            ASN1EncodableVector sVec = new ASN1EncodableVector();
            DERObjectIdentifier lstOid = null;
            int i = 0;
            while (i != this.ordering.size()) {
                ASN1EncodableVector v = new ASN1EncodableVector();
                DERObjectIdentifier oid = (DERObjectIdentifier)this.ordering.elementAt(i);
                v.add((DEREncodable)oid);
                String str = (String)this.values.elementAt(i);
                v.add((DEREncodable)this.converter.getConvertedValue(oid, str));
                if (lstOid == null || ((Boolean)this.added.elementAt(i)).booleanValue()) {
                    sVec.add((DEREncodable)new DERSequence(v));
                } else {
                    vec.add((DEREncodable)new DERSet(sVec));
                    sVec = new ASN1EncodableVector();
                    sVec.add((DEREncodable)new DERSequence(v));
                }
                lstOid = oid;
                ++i;
            }
            vec.add((DEREncodable)new DERSet(sVec));
            this.seq = new DERSequence(vec);
        }
        return this.seq;
    }

    public boolean equals(Object _obj, boolean inOrder) {
        if (_obj == this) {
            return true;
        }
        if (!inOrder) {
            return this.equals(_obj);
        }
        if (_obj == null || !(_obj instanceof X509Name)) {
            return false;
        }
        X509Name _oxn = (X509Name)((Object)_obj);
        int _orderingSize = this.ordering.size();
        if (_orderingSize != _oxn.ordering.size()) {
            return false;
        }
        int i = 0;
        while (i < _orderingSize) {
            String _oid = ((DERObjectIdentifier)this.ordering.elementAt(i)).getId();
            String _val = (String)this.values.elementAt(i);
            String _oOID = ((DERObjectIdentifier)_oxn.ordering.elementAt(i)).getId();
            String _oVal = (String)_oxn.values.elementAt(i);
            if (_oid.equals(_oOID)) {
                if (!(_val = _val.trim().toLowerCase()).equals(_oVal = _oVal.trim().toLowerCase())) {
                    char c2;
                    int k;
                    char c1;
                    StringBuffer v1 = new StringBuffer();
                    StringBuffer v2 = new StringBuffer();
                    if (_val.length() != 0) {
                        c1 = _val.charAt(0);
                        v1.append(c1);
                        k = 1;
                        while (k < _val.length()) {
                            c2 = _val.charAt(k);
                            if (c1 != ' ' || c2 != ' ') {
                                v1.append(c2);
                            }
                            c1 = c2;
                            ++k;
                        }
                    }
                    if (_oVal.length() != 0) {
                        c1 = _oVal.charAt(0);
                        v2.append(c1);
                        k = 1;
                        while (k < _oVal.length()) {
                            c2 = _oVal.charAt(k);
                            if (c1 != ' ' || c2 != ' ') {
                                v2.append(c2);
                            }
                            c1 = c2;
                            ++k;
                        }
                    }
                    if (!v1.toString().equals(v2.toString())) {
                        return false;
                    }
                }
            } else {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(Object _obj) {
        if (_obj == this) {
            return true;
        }
        if (_obj == null || !(_obj instanceof X509Name)) {
            return false;
        }
        X509Name _oxn = (X509Name)((Object)_obj);
        if (this.getDERObject().equals((Object)_oxn.getDERObject())) {
            return true;
        }
        int _orderingSize = this.ordering.size();
        if (_orderingSize != _oxn.ordering.size()) {
            return false;
        }
        boolean[] _indexes = new boolean[_orderingSize];
        int i = 0;
        while (i < _orderingSize) {
            boolean _found = false;
            String _oid = ((DERObjectIdentifier)this.ordering.elementAt(i)).getId();
            String _val = (String)this.values.elementAt(i);
            int j = 0;
            while (j < _orderingSize) {
                if (!_indexes[j]) {
                    String _oOID = ((DERObjectIdentifier)_oxn.ordering.elementAt(j)).getId();
                    String _oVal = (String)_oxn.values.elementAt(j);
                    if (_oid.equals(_oOID)) {
                        char c2;
                        int k;
                        char c1;
                        if ((_val = _val.trim().toLowerCase()).equals(_oVal = _oVal.trim().toLowerCase())) {
                            _indexes[j] = true;
                            _found = true;
                            break;
                        }
                        StringBuffer v1 = new StringBuffer();
                        StringBuffer v2 = new StringBuffer();
                        if (_val.length() != 0) {
                            c1 = _val.charAt(0);
                            v1.append(c1);
                            k = 1;
                            while (k < _val.length()) {
                                c2 = _val.charAt(k);
                                if (c1 != ' ' || c2 != ' ') {
                                    v1.append(c2);
                                }
                                c1 = c2;
                                ++k;
                            }
                        }
                        if (_oVal.length() != 0) {
                            c1 = _oVal.charAt(0);
                            v2.append(c1);
                            k = 1;
                            while (k < _oVal.length()) {
                                c2 = _oVal.charAt(k);
                                if (c1 != ' ' || c2 != ' ') {
                                    v2.append(c2);
                                }
                                c1 = c2;
                                ++k;
                            }
                        }
                        if (v1.toString().equals(v2.toString())) {
                            _indexes[j] = true;
                            _found = true;
                            break;
                        }
                    }
                }
                ++j;
            }
            if (!_found) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        ASN1Sequence seq = (ASN1Sequence)this.getDERObject();
        Enumeration e = seq.getObjects();
        int hashCode = 0;
        while (e.hasMoreElements()) {
            hashCode ^= e.nextElement().hashCode();
        }
        return hashCode;
    }

    private void appendValue(StringBuffer buf, Hashtable oidSymbols, DERObjectIdentifier oid, String value) {
        String sym = (String)oidSymbols.get(oid);
        if (sym != null) {
            buf.append(sym);
        } else {
            buf.append(oid.getId());
        }
        buf.append("=");
        boolean flag = false;
        int i1 = value.length();
        int j = 0;
        while (j < ",+=\n<>#;".length()) {
            if (value.indexOf(",+=\n<>#;".charAt(j)) != -1) {
                flag = true;
                break;
            }
            ++j;
        }
        if (!(i1 <= 0 || flag || value.charAt(0) != ' ' && value.charAt(0) != '\n' && value.charAt(i1 - 1) != ' ' && value.charAt(i1 - 1) != '\n')) {
            flag = true;
        }
        if (i1 > 0 && !flag) {
            boolean flag1 = false;
            int k = 1;
            while (k < i1 - 2) {
                if (value.charAt(k) == ' ' || value.charAt(k) == '\n') {
                    if (flag1) {
                        flag = true;
                        break;
                    }
                    flag1 = true;
                } else {
                    flag1 = false;
                }
                ++k;
            }
        }
        if (flag) {
            buf.append('\"');
        }
        int l = 0;
        while (l < i1) {
            char c = value.charAt(l);
            if (c == '\"' || c == '\\') {
                buf.append('\\');
            }
            buf.append(c);
            ++l;
        }
        if (flag) {
            buf.append('\"');
        }
    }

    public String toString(boolean reverse, Hashtable oidSymbols) {
        StringBuffer buf = new StringBuffer();
        boolean first = true;
        if (reverse) {
            int i = this.ordering.size() - 1;
            while (i >= 0) {
                if (first) {
                    first = false;
                } else if (((Boolean)this.added.elementAt(i + 1)).booleanValue()) {
                    buf.append("+");
                } else {
                    buf.append(", ");
                }
                this.appendValue(buf, oidSymbols, (DERObjectIdentifier)this.ordering.elementAt(i), (String)this.values.elementAt(i));
                --i;
            }
        } else {
            int i = 0;
            while (i < this.ordering.size()) {
                if (first) {
                    first = false;
                } else if (((Boolean)this.added.elementAt(i)).booleanValue()) {
                    buf.append("+");
                } else {
                    buf.append(", ");
                }
                this.appendValue(buf, oidSymbols, (DERObjectIdentifier)this.ordering.elementAt(i), (String)this.values.elementAt(i));
                ++i;
            }
        }
        return buf.toString();
    }

    public String toString() {
        return this.toString(DefaultReverse, DefaultSymbols);
    }
}

