/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.cms.jcajce;

import cn.topca.security.sm.CipherAgent;
import cn.topca.security.sm.TopSMProvider;
import cn.topca.security.x509.AlgorithmId;
import com.itrus.util.CertUtils;
import java.security.Key;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import org.bouncycastle.asn1.cms.RecipientIdentifier;
import org.bouncycastle.asn1.cms.RecipientInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.operator.GenericKey;

public class SM2RecipientInfoGenerator
implements RecipientInfoGenerator {
    private X509Certificate cert;

    static {
        if (Security.getProperty("TopSM") == null) {
            Security.addProvider((Provider)new TopSMProvider());
        }
    }

    public SM2RecipientInfoGenerator(X509Certificate x509certificate) {
        this.cert = x509certificate;
    }

    public RecipientInfo generate(GenericKey genericKey) throws CMSException {
        byte[] encKeyBytes;
        IssuerAndSerialNumber issuerAndSerialNumber = CertUtils.getIssuerAndSerialNumber(this.cert);
        RecipientIdentifier recipientidentifier = new RecipientIdentifier(issuerAndSerialNumber);
        byte[] keyBytes = this.getKey(genericKey).getEncoded();
        try {
            CipherAgent cipher = CipherAgent.getInstance((String)"SM2");
            cipher.init(1, (Certificate)this.cert);
            encKeyBytes = cipher.doFinal(keyBytes);
        }
        catch (Exception e) {
            throw new CMSException(e.getMessage(), e);
        }
        return new RecipientInfo(new KeyTransRecipientInfo(recipientidentifier, new AlgorithmIdentifier(new DERObjectIdentifier(AlgorithmId.SM2_oid.toString()), null), (ASN1OctetString)new DEROctetString(encKeyBytes)));
    }

    private Key getKey(GenericKey generickey) {
        if (generickey.getRepresentation() instanceof Key) {
            return (Key)generickey.getRepresentation();
        }
        if (generickey.getRepresentation() instanceof byte[]) {
            return new SecretKeySpec((byte[])generickey.getRepresentation(), "ENC");
        }
        throw new IllegalArgumentException("unknown generic key type");
    }
}

