/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.cryptorole.bc;

import cn.topca.security.sm.SM2PrivateKey;
import cn.topca.security.sm.TopSMProvider;
import cn.topca.security.x509.AlgorithmId;
import com.itrus.asn1.cms.CMSEnvelopedDataEx;
import com.itrus.cms.CMSEnvelopedAsymmetricDecryptor;
import com.itrus.cms.jcajce.CMSEnvelopedRSADecryptor;
import com.itrus.cms.jcajce.CMSEnvelopedSM2Decryptor;
import com.itrus.cryptorole.CryptoException;
import com.itrus.cryptorole.NotSupportException;
import com.itrus.cryptorole.Recipient;
import com.itrus.cryptorole.SignatureVerifyException;
import com.itrus.svm.SVM;
import com.itrus.svm.SignerAndEncryptedDigest;
import com.itrus.util.FileUtils;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Enumeration;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;

public class RecipientBcImpl
extends Recipient {
    private static String PROVIDER = "BC";
    private static String PROVIDER_TOPSM = "TopSM";

    static {
        if (Security.getProvider(PROVIDER) == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        if (Security.getProperty(PROVIDER_TOPSM) == null) {
            Security.addProvider((Provider)new TopSMProvider());
        }
    }

    public void initCertWithKey(String keyStoreFileName, char[] keyStorePassword, String keyAlias, char[] keyPassword) throws NotSupportException, CryptoException {
        try {
            FileInputStream fis = new FileInputStream(keyStoreFileName);
            KeyStore keystore = KeyStore.getInstance("JKS");
            keystore.load(fis, keyStorePassword);
            fis.close();
            this.keyOfDecryptor = (PrivateKey)keystore.getKey(keyAlias, keyPassword);
            this.certOfDecryptor = (X509Certificate)keystore.getCertificate(keyAlias);
        }
        catch (FileNotFoundException e) {
            throw new CryptoException(e);
        }
        catch (KeyStoreException e) {
            throw new CryptoException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
        catch (CertificateException e) {
            throw new CryptoException(e);
        }
        catch (IOException e) {
            throw new CryptoException(e);
        }
        catch (UnrecoverableKeyException e) {
            throw new CryptoException(e);
        }
    }

    public void initCertWithKey(String pfxFileName, char[] keyPassword) throws NotSupportException, CryptoException {
        try {
            FileInputStream fis = new FileInputStream(pfxFileName);
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            keyStore.load(fis, keyPassword);
            fis.close();
            Enumeration<String> enums = keyStore.aliases();
            while (enums.hasMoreElements()) {
                String keyAlias = enums.nextElement();
                if (!keyStore.isKeyEntry(keyAlias)) continue;
                this.keyOfDecryptor = (PrivateKey)keyStore.getKey(keyAlias, keyPassword);
                this.certOfDecryptor = (X509Certificate)keyStore.getCertificate(keyAlias);
            }
        }
        catch (FileNotFoundException e) {
            throw new CryptoException(e);
        }
        catch (KeyStoreException e) {
            throw new CryptoException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
        catch (CertificateException e) {
            throw new CryptoException(e);
        }
        catch (IOException e) {
            throw new CryptoException(e);
        }
        catch (UnrecoverableKeyException e) {
            throw new CryptoException(e);
        }
    }

    public boolean doVerify(byte[] originalMessage, byte[] encryptedDigest, X509Certificate signer, String signAlgorithm) throws CryptoException {
        if (signAlgorithm == null) {
            signAlgorithm = "SM2".equalsIgnoreCase(signer.getPublicKey().getAlgorithm()) ? "SM3withSM2" : this.signAlgorithm;
        }
        try {
            Signature signature = Signature.getInstance(signAlgorithm);
            signature.initVerify(signer);
            signature.update(originalMessage);
            return signature.verify(encryptedDigest);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
        catch (InvalidKeyException e) {
            throw new CryptoException(e);
        }
        catch (SignatureException e) {
            throw new CryptoException(e);
        }
    }

    public X509Certificate verifySignature(byte[] originalMessage, byte[] signedData) throws CryptoException, SignatureVerifyException {
        SignerAndEncryptedDigest signerAndEncryptedDigest = SVM.verifyAndParsePkcs7(originalMessage, signedData);
        return signerAndEncryptedDigest.getSigner();
    }

    public X509Certificate verifySignature(String originalMessage, String signedData) throws CryptoException, SignatureVerifyException {
        return SVM.verifySignature(originalMessage, signedData);
    }

    public X509Certificate verifySignatureIncludeOriginal(byte[] signedDataIncludeOriginal) throws NotSupportException, CryptoException, SignatureVerifyException {
        SignerAndEncryptedDigest signerAndEncryptedDigest = SVM.verifyAndParsePkcs7(null, signedDataIncludeOriginal);
        return signerAndEncryptedDigest.getSigner();
    }

    public SignerAndEncryptedDigest verifyAndParsePkcs7(byte[] oriData, byte[] pkcs7) throws SignatureVerifyException, CryptoException {
        return SVM.verifyAndParsePkcs7(oriData, pkcs7);
    }

    public byte[] decryptMessage(byte[] encryptedData) throws CryptoException {
        if (this.keyOfDecryptor == null || this.certOfDecryptor == null) {
            throw new CryptoException(this.notInitializeKeyMessage);
        }
        try {
            CMSEnvelopedDataEx enveloped = new CMSEnvelopedDataEx(encryptedData);
            String publicKeyAlgorithm = this.certOfDecryptor.getPublicKey().getAlgorithm();
            if (AlgorithmId.SM2_oid.toString().equals(publicKeyAlgorithm)) {
                publicKeyAlgorithm = "SM2";
            }
            CMSEnvelopedAsymmetricDecryptor decryptor = "SM2".equalsIgnoreCase(publicKeyAlgorithm) ? new CMSEnvelopedSM2Decryptor(this.certOfDecryptor, (SM2PrivateKey)this.keyOfDecryptor) : new CMSEnvelopedRSADecryptor(this.certOfDecryptor, (RSAPrivateKey)this.keyOfDecryptor);
            return enveloped.getContent(decryptor);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }

    public void decryptFile(String encryptedFileName, String destinationFileName) throws CryptoException, IOException {
        byte[] encryptedMessage = FileUtils.readBytesFromFile(encryptedFileName);
        byte[] originalMessage = this.decryptMessage(encryptedMessage);
        FileUtils.saveBytesToFile(originalMessage, destinationFileName);
    }

    public void decryptFileEx(String encryptedFileName, String destinationFileName) throws CryptoException {
        FileInputStream in = null;
        OutputStream out = null;
        try {
            try {
                in = new FileInputStream(encryptedFileName);
                out = new FileOutputStream(destinationFileName);
                int i = 0;
                byte[] c = new byte[1];
                byte[] p7B64KeyAndIV = new byte[10240];
                while (((InputStream)in).read(c, 0, 1) != -1) {
                    String s = new String(c);
                    if (s.compareToIgnoreCase("|") != 0) {
                        p7B64KeyAndIV[i++] = c[0];
                        continue;
                    }
                    p7B64KeyAndIV[i] = 0;
                    break;
                }
                byte[] p7 = Base64.decode((String)new String(p7B64KeyAndIV, 0, i));
                byte[] bB64KeyAndIV = this.decryptMessage(p7);
                byte[] szB64KeyAndIV = Base64.decode((String)new String(bB64KeyAndIV));
                byte[] szB64Key = null;
                byte[] szB64IV = null;
                String temp = new String(szB64KeyAndIV);
                int index = temp.indexOf("|");
                String temp2 = temp.substring(0, index);
                String temp3 = temp.substring(index + 1);
                szB64Key = temp2.getBytes();
                szB64IV = temp3.getBytes();
                byte[] bkey = Base64.decode((String)new String(szB64Key));
                byte[] biv = Base64.decode((String)new String(szB64IV));
                DESedeKeySpec dks = new DESedeKeySpec(bkey);
                SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DESede");
                SecretKey key = keyFactory.generateSecret(dks);
                IvParameterSpec iv = new IvParameterSpec(biv, 0, 8);
                Cipher c1 = Cipher.getInstance("DESede/CBC/PKCS5Padding");
                c1.init(2, (Key)key, iv, null);
                byte[] buff = new byte[10240];
                int size = 0;
                byte[] buff2 = null;
                while ((size = ((InputStream)in).read(buff)) != -1) {
                    buff2 = c1.update(buff, 0, size);
                    out.write(buff2);
                }
                buff2 = c1.doFinal();
                out.write(buff2);
            }
            catch (FileNotFoundException e) {
                throw new CryptoException(e);
            }
            catch (IOException e) {
                throw new CryptoException(e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new CryptoException(e);
            }
            catch (NoSuchPaddingException e) {
                throw new CryptoException(e);
            }
            catch (InvalidKeyException e) {
                throw new CryptoException(e);
            }
            catch (InvalidKeySpecException e) {
                throw new CryptoException(e);
            }
            catch (InvalidAlgorithmParameterException e) {
                throw new CryptoException(e);
            }
            catch (IllegalStateException e) {
                throw new CryptoException(e);
            }
            catch (IllegalBlockSizeException e) {
                throw new CryptoException(e);
            }
            catch (BadPaddingException e) {
                throw new CryptoException(e);
            }
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    throw new CryptoException(e);
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    throw new CryptoException(e);
                }
            }
        }
    }

    public void decryptFileWithHeader(String header, String encryptedFileName, String destinationFileName) throws CryptoException {
        InputStream in = null;
        OutputStream out = null;
        try {
            try {
                boolean readOK = false;
                in = new FileInputStream(encryptedFileName);
                out = new FileOutputStream(destinationFileName);
                byte[] c = new byte[1];
                while (in.read(c, 0, 1) != -1) {
                    String s = new String(c);
                    if (s.compareToIgnoreCase("|") != 0) continue;
                    readOK = true;
                    break;
                }
                if (!readOK) {
                    throw new CryptoException("Read Encrypted File Header failed.");
                }
                byte[] bB64KeyAndIV = header.getBytes();
                byte[] szB64KeyAndIV = Base64.decode((String)new String(bB64KeyAndIV));
                byte[] szB64Key = null;
                byte[] szB64IV = null;
                String temp = new String(szB64KeyAndIV);
                int index = temp.indexOf("|");
                String temp2 = temp.substring(0, index);
                String temp3 = temp.substring(index + 1);
                szB64Key = temp2.getBytes();
                szB64IV = temp3.getBytes();
                byte[] bkey = Base64.decode((String)new String(szB64Key));
                byte[] biv = Base64.decode((String)new String(szB64IV));
                DESedeKeySpec dks = new DESedeKeySpec(bkey);
                SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DESede");
                SecretKey key = keyFactory.generateSecret(dks);
                IvParameterSpec iv = new IvParameterSpec(biv, 0, 8);
                Cipher c1 = Cipher.getInstance("DESede/CBC/PKCS5Padding");
                c1.init(2, (Key)key, iv, null);
                byte[] buff = new byte[10240];
                int size = 0;
                byte[] buff2 = null;
                while ((size = in.read(buff)) != -1) {
                    buff2 = c1.update(buff, 0, size);
                    out.write(buff2);
                }
                buff2 = c1.doFinal();
                out.write(buff2);
            }
            catch (FileNotFoundException e) {
                throw new CryptoException(e);
            }
            catch (IOException e) {
                throw new CryptoException(e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new CryptoException(e);
            }
            catch (NoSuchPaddingException e) {
                throw new CryptoException(e);
            }
            catch (InvalidKeyException e) {
                throw new CryptoException(e);
            }
            catch (InvalidKeySpecException e) {
                throw new CryptoException(e);
            }
            catch (InvalidAlgorithmParameterException e) {
                throw new CryptoException(e);
            }
            catch (IllegalStateException e) {
                throw new CryptoException(e);
            }
            catch (IllegalBlockSizeException e) {
                throw new CryptoException(e);
            }
            catch (BadPaddingException e) {
                throw new CryptoException(e);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    throw new CryptoException(e);
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    throw new CryptoException(e);
                }
            }
        }
    }

    public static void decryptFileWithSymmetricKey(String symmetricKey, String encryptedFileName, String destinationFileName) throws CryptoException {
        FileInputStream in = null;
        OutputStream out = null;
        try {
            try {
                in = new FileInputStream(encryptedFileName);
                out = new FileOutputStream(destinationFileName);
                byte[] bB64KeyAndIV = symmetricKey.getBytes();
                byte[] szB64KeyAndIV = Base64.decode((String)new String(bB64KeyAndIV));
                byte[] szB64Key = null;
                byte[] szB64IV = null;
                String temp = new String(szB64KeyAndIV);
                int index = temp.indexOf("|");
                String temp2 = temp.substring(0, index);
                String temp3 = temp.substring(index + 1);
                szB64Key = temp2.getBytes();
                szB64IV = temp3.getBytes();
                byte[] bkey = Base64.decode((String)new String(szB64Key));
                byte[] biv = Base64.decode((String)new String(szB64IV));
                DESedeKeySpec dks = new DESedeKeySpec(bkey);
                SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DESede");
                SecretKey key = keyFactory.generateSecret(dks);
                IvParameterSpec iv = new IvParameterSpec(biv, 0, 8);
                Cipher c1 = Cipher.getInstance("DESede/CBC/PKCS5Padding");
                c1.init(2, (Key)key, iv, null);
                byte[] buff = new byte[10240];
                int size = 0;
                byte[] buff2 = null;
                while ((size = ((InputStream)in).read(buff)) != -1) {
                    buff2 = c1.update(buff, 0, size);
                    out.write(buff2);
                }
                buff2 = c1.doFinal();
                out.write(buff2);
            }
            catch (FileNotFoundException e) {
                throw new CryptoException(e);
            }
            catch (IOException e) {
                throw new CryptoException(e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new CryptoException(e);
            }
            catch (NoSuchPaddingException e) {
                throw new CryptoException(e);
            }
            catch (InvalidKeyException e) {
                throw new CryptoException(e);
            }
            catch (InvalidKeySpecException e) {
                throw new CryptoException(e);
            }
            catch (InvalidAlgorithmParameterException e) {
                throw new CryptoException(e);
            }
            catch (IllegalStateException e) {
                throw new CryptoException(e);
            }
            catch (IllegalBlockSizeException e) {
                throw new CryptoException(e);
            }
            catch (BadPaddingException e) {
                throw new CryptoException(e);
            }
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    throw new CryptoException(e);
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    throw new CryptoException(e);
                }
            }
        }
    }

    public static void main(String[] args) throws Exception {
        byte[] encry = Base64.decode((String)"MIIweAYJKoZIhvcNAQcDoIIwaTCCMGUCAQAxgjAJMIG5AgEAMCIwDjEMMAoGA1UEAxMDbnN3AhCXHzkBMzD1skmmtIad2e3HMA0GCSqGSIb3DQEBAQUABIGAA+4pHW5AvtXj+DdtbswA5HzfSe/fvz+tVBGEweZHPURD2RgasYLhFioe4xseXMCmNyPiLy5AaOQSwjtROeHqItMYO2iKZPvDi99VvEOwfVO7YdneatW9LfkJqKloLTfDcVvuBHsNSGtOfRL3d2lswi3N/T8dkQ1qLi/Un3ZY8uAwgd0CAQAwRDAwMQ8wDQYDVQQDDAZ1c2VyY2ExDzANBgNVBAsMBnVzZXJjYTEMMAoGA1UECgwDdG9wAhBTE+3VtrsTMPjEMixCXD9uMAwGCCqBHM9VAYItBQAEgYMwgYACIIxXV9l75C/dcym+YQBWIltXx1ioDlpR7PHjRSYbrDf5AiD13Quq9NgZRPB1Qd49fwdIgJ1GgNGVnUtPHLmGTxNoYgQgODSZw3yxz5joW+736X88fEPbGg5ojGTf+4S82jRAS74EGBlcom9e4rBAZgJhMbAHCOyI/Ih/XK/PrTCB3wIBADBGMDIxEDAOBgNVBAMMB2FkbWluY2ExEDAOBgNVBAsMB2FkbWluY2ExDDAKBgNVBAoMA3RvcAIQHkRq7L8IigQSn2cxOah2wjAMBggqgRzPVQGCLQUABIGDMIGAAiB7v6mI1xF6hrxHAWx2XOMQandeLG1t7QViYT4KH0wsYgIg5V0OieNJiF7gdDv7NHr6l4hNFdIPt4WLT/BQ9qOZ4bcEIH+h8Tifqf/TVPnCDhz3uItr8qVAeKPn5Z5DAocDm3AeBBgY4AkbuISvcbLitmPyowq4DJIzgt8xIjgwgd8CAQAwRjAyMRAwDgYDVQQDDAdhZG1pbmNhMRAwDgYDVQQLDAdhZG1pbmNhMQwwCgYDVQQKDAN0b3ACEH8o8bgtFUcwTT74WK2FwUYwDAYIKoEcz1UBgi0FAASBgzCBgAIgkd7VdGqeANTVWWOk699s0BWKDMY3Prr5z3Vh0IrTVMUCIHSMlqtMdQTCjDOz+zOPi9O+QqGd+LdSlVKqbhdqZ1RzBCATmldhRfGDe8jkJ1BINTJOcIsblB2ckn7KGwyLhzPa2QQYxA4ZTNseO3Xvu3MdCwew91lllhUWNz83MIHwAgEAMFkwUTELMAkGA1UEBhMCY24xCzAJBgNVBAgTAmNuMQswCQYDVQQHEwJjbjELMAkGA1UEChMCY24xCzAJBgNVBAsTAmNuMQ4wDAYDVQQDEwVNeUtleQIET/upXzANBgkqhkiG9w0BAQEFAASBgIeyQ4QvxytvIQAknnPB3LJ3zBFqZ09hAAzMHM5aWwxjhDud6zlQOUb93WVp0zZIEebrpvTQf7T8/s16HzmBmmbCIBqZQL6uD9vcrn+oF310/IklEqzJa4Qb2kIxqZLp7BA3x/yCIhQxVl0dh2Qlscq4qL6CnqDJWCaykEk4t5etMIH9AgEAMGQwTDETMBEGA1UEAwwKdXNlci1pdHJ1czEYMBYGA1UECwwP5rWL6K+V6YOo6K+V55SoMRswGQYDVQQKDBLlpKnor5rlronkv6Hor5XnlKgCFBHRy/p/8B/WrE+410TmMrEJTIsbMAwGCCqBHM9VAYItBQAEgYMwgYACIDmpoGrOhuQTRkZTj1IOFsQYm39MovSJqAZRvYa+C4YzAiCc6vEMqycCSOd6dVupj/xgGkRXajxdcSflYCL+EMh/JQQgXpKGwUMwPZom4LBH9hPXgvEVTLAdw7Rejl91nvpQHjMEGC0iaSxpWM9vG96clzxKEgeEU4qTbUpqvTCB/wIBADBoMFoxCzAJBgNVBAYTAlVTMRMwEQYDVQQKEwpBcHBsZSBJbmMuMRUwEwYDVQQLEwxBcHBsZSBpUGhvbmUxHzAdBgNVBAMTFkFwcGxlIGlQaG9uZSBEZXZpY2UgQ0ECCgRhZqhmKnIFdXAwDQYJKoZIhvcNAQEBBQAEgYBuYGPeLsoc9yFOkwE8/A3IplvlN6Kp63ZuAdmNahclPnJVYyQAEa1gYx4QbJHDzpANV1HOdTLOBcCizgdIpwVLN3t/7OiqBPeAqlDHNNCxPmCVsLt1KURewqzsJnZGQphxPJuGh4FrSLnyxItkK3FWXBhIRtbni+IBJ8TiKDZcFTCCAQECAQAwaDBQMRcwFQYDVQQDDA7nlKjmiLdDQeivgeS5pjEYMBYGA1UECwwP5rWL6K+V6YOo6K+V55SoMRswGQYDVQQKDBLlpKnor5rlronkv6Hor5XnlKgCFD+/iXbIouAn7XkStY9Veu4xzyU/MAwGCCqBHM9VAYItBQAEgYMwgYACIFGWyyeU+k9Iy/25mxwdk2bF0WDVRoaJrE+49wjL6I2MAiDpMWBM54wSIJ8lUiYwMeSL+4mDe1umvQv8xAIMXA3XuwQg9vaN++HLLDYmYaRwGbzMxMLgJ0aN2XTOZ7FSHuM9cnkEGI7sV4z+63TT0DYShDzt7Aq+3ePWD0IgwTCCAQQCAQAwbTBZMRkwFwYDVQQKHhBZKVoBi9pP4f8IbUuL1f8JMRswGQYDVQQLHhJZKVoBi9pP4f8IbUuL1f8JkOgxHzAdBgNVBAMeFlkpWgGL2k/h/whtS4vV/wloOQBDAEECEAGPIADz9Dbxxb+fJkB6GAEwDQYJKoZIhvcNAQEBBQAEgYBkvH7JCVjWZtrDN6MEuNQ+/4pkNBxjjthnoXqUSvMigXF53mjGiFyU5a6/XJC7/u2SmLOIAo1CaYquOILDiSbM75XBeBQNemVjud7fOVpStUNZKDA54gCje/J00+0NaGwlqlonD4v6K00xPqbZ7CE5qSE+YMKyudIjYSPOslZjzzCCAQQCAQAwbTBZMRkwFwYDVQQKHhBZKVoBi9pP4f8IbUuL1f8JMRswGQYDVQQLHhJZKVoBi9pP4f8IbUuL1f8JkOgxHzAdBgNVBAMeFlkpWgGL2k/h/whtS4vV/wloOQBDAEECEAH3xYSob6Yi+I9El3GEggEwDQYJKoZIhvcNAQEBBQAEgYApIA1Y1eqRypH7GoTBxlw5KXRWyR79iSGRyW+HWkt0lIkQuUDI0XvUNKwBI8ekAHQ6eOdV2uca7hwAKvePZaXyQAOdCcy2/n3jTBLBlKhupN25SgXcvjF0JoQlEa7eF1PyHtefhBBDvoiV4cwLLqakJYjN5MUE0UX7/3tH7F7lWTCCAQoCAQAwczBbMRkwFwYDVQQKHhBZKVoBi9pP4f8IbUuL1f8JMRswGQYDVQQLHhJZKVoBi9pP4f8IbUuL1f8JkOgxITAfBgNVBAMeGFkpWgGL2k/h/whtS4vV/wl1KGI3AEMAQQIUBMqA9zI7IuQi+teoZ4mHUNTTAQAwDQYJKoZIhvcNAQEBBQAEgYALTNx/nAjmjDnqEN4dcdOY7T6B1ZpaQsdE1B6ExmANteBAnz9fJ+XkFMh3MiC3lrLEzDaz4XjcEIyb904giwBDv9zkfOvT6QTPvFRnXYVE/vl1LOFKLppzwNlaqxZ1wBPF2E6ElOgQMNcKHDxwkgo9eBlixPdGPTZbgxfZein+SjCCAQoCAQAwczBbMRkwFwYDVQQKHhBZKVoBi9pP4f8IbUuL1f8JMRswGQYDVQQLHhJZKVoBi9pP4f8IbUuL1f8JkOgxITAfBgNVBAMeGFkpWgGL2k/h/whtS4vV/wl1KGI3AEMAQQIUClI0R3ZukmGMmChJIImHUAxfDAAwDQYJKoZIhvcNAQEBBQAEgYAlUvjakGiUfMtPvZ8wJPKEYVUJTkAzOcNrPyHTxeXSNe76bQtp1rbfPiINQKuVBEFhxYGQPMu1gjHocirFcDUWEyl07lCaspgV0cCWZ017dh47q1U6g3JYAmQm0uFJifpEldsHCzBhaHdPzF8GGuaEJXEQDPPdtXsdQgK/fi6iKDCCAQoCAQAwczBbMRkwFwYDVQQKHhBZKVoBi9pP4f8IbUuL1f8JMRswGQYDVQQLHhJZKVoBi9pP4f8IbUuL1f8JkOgxITAfBgNVBAMeGFkpWgGL2k/h/whtS4vV/wl1KGI3AEMAQQIUEI2zZOMIaDPm54XUyDa/T/jaBQAwDQYJKoZIhvcNAQEBBQAEgYBAC7BMmOOswiMFe/V7tcLNqMNd5QNpo80DgWrl53tv30XTeWeyC+Ru6h3ZaB5l3Iw71AKWG88houBq6+rm8rNVLmdGrrpiefWqOzt1qqCP1u8n0HFv7WqDRM4TmiRdZG7rM5ZPho9vd/biSQLMoaC71WlYA75DnmHVkv8TiJlEETCCAQoCAQAwczBbMRkwFwYDVQQKHhBZKVoBi9pP4f8IbUuL1f8JMRswGQYDVQQLHhJZKVoBi9pP4f8IbUuL1f8JkOgxITAfBgNVBAMeGFkpWgGL2k/h/whtS4vV/wl1KGI3AEMAQQIUHCzJPj6WigLoydFwdzW/T9iSBAAwDQYJKoZIhvcNAQEBBQAEgYCBi80r9nw+boKGx3oUUD5TWefwMiSlGPgVsHediTCWu+derZ9ofWFftUeXobIQgI7K3XcHtovsQIlY+89TbzqDqet1RwNzlWjsEFbL9yMyaYj7EKmoFlgX5VzRjHuHuXX70xBZKUQA0y0sd8uco4e8+eWANZ+cc0FmmRXKQgLdyDCCAQoCAQAwczBbMRkwFwYDVQQKHhBZKVoBi9pP4f8IbUuL1f8JMRswGQYDVQQLHhJZKVoBi9pP4f8IbUuL1f8JkOgxITAfBgNVBAMeGFkpWgGL2k/h/whtS4vV/wl1KGI3AEMAQQIUIWiI6nBGXGlJ9YYQvDa/TwC2BAAwDQYJKoZIhvcNAQEBBQAEgYDNkNWzlskmJrKTCXuzetcyG9+QbPAihlrB6SknOl36bsgt3UARNE3F8xhZLf2kHyczz4bS2lFaEpNlcZrCwOG+p1yo7FFaQpjY0EzBsGQtsYSr/51QmQxCdIcNLIqGWVSM74SrRHTd1jj8CTao/c2r/QOMqF2vN8+eDJRUr4kjojCCAQoCAQAwczBbMRkwFwYDVQQKHhBZKVoBi9pP4f8IbUuL1f8JMRswGQYDVQQLHhJZKVoBi9pP4f8IbUuL1f8JkOgxITAfBgNVBAMeGFkpWgGL2k/h/whtS4vV/wl1KGI3AEMAQQIUKWoiLwZfkXCQz18aLo+RTckTAQAwDQYJKoZIhvcNAQEBBQAEgYCQHuV6mrCMG7sFgdrS6ccmNa/5faF3G/KD/X5uFCPelSwgjbb/VaOEjrJsUjHwUbFXJEIlHULgT/mpjpayJ1z1Nf0z3Rd9Jh991s8FzVdqEo1uF8nvwQ6mstB4gyn5G4dhWqeisa6s6GlvWRxQeqdASZNw0IYuI6Yp0RJfkpEIujCCAQoCAQAwczBbMRkwFwYDVQQKHhBZKVoBi9pP4f8IbUuL1f8JMRswGQYDVQQLHhJZKVoBi9pP4f8IbUuL1f8JkOgxITAfBgNVBAMeGFkpWgGL2k/h/whtS4vV/wl1KGI3AEMAQQIUNzzvTfKxjynfdZmMT/nHUPNGAwAwDQYJKoZIhvcNAQEBBQAEgYCISmrhpzr+Snf3gwlb3jcLbFdedRKv5uDQyTNBqLbXtl70f0mjF32uEVBUKKCZl8Y6v9gH+HnL2Be481mnuMAE1XSGgm84SZwYtb2DFsOPx5ftweuQfBqZy8weJIZQcUfbQWn/VEk/EuPRVlOi+zibHAT/EIN/CZRMaFuWzZi75jCCAQoCAQAwczBbMRkwFwYDVQQKHhBZKVoBi9pP4f8IbUuL1f8JMRswGQYDVQQLHhJZKVoBi9pP4f8IbUuL1f8JkOgxITAfBgNVBAMeGFkpWgGL2k/h/whtS4vV/wl1KGI3AEMAQQIUQkgi4yP35ugPLzuui0sjUE03DQAwDQYJKoZIhvcNAQEBBQAEgYCcpDJJUpmImRIW1S4OMjnKiIX6ykD+PQbZnNQT8z2uzNG4vxruf3zVuTHdp1Bj8t0yfQt9k1MuQ+V7N7NigPznRZqOQOb85cqkSe99bwOToJF7+2m5sjXA7lfVeFj7YSfRvED24zzoZ6+xgikbIStkuOn7VD/ZytFjpImEXV0ynTCCAQoCAQAwczBbMRkwFwYDVQQKHhBZKVoBi9pP4f8IbUuL1f8JMRswGQYDVQQLHhJZKVoBi9pP4f8IbUuL1f8JkOgxITAfBgNVBAMeGFkpWgGL2k/h/whtS4vV/wl1KGI3AEMAQQIURuXb3wyDZ2LcCVDNXDa/T2C4AQAwDQYJKoZIhvcNAQEBBQAEgYBu0JqVoH9iODAdNBisNSEVvVUslOx48VfLFmRkbhk527hO6dTNM0oO0VfJmvFhaC8d/rJ3HkUyA4aDzHkMb5d50XG31HJLZ9s0co1XhHj3kQJYg00lLzm00wHSidslAxEJhooGz8tbRdgmMtunWNkUjK1p/VxIdEtiNoxVoQQq9TCCAQoCAQAwczBbMRkwFwYDVQQKHhBZKVoBi9pP4f8IbUuL1f8JMRswGQYDVQQLHhJZKVoBi9pP4f8IbUuL1f8JkOgxITAfBgNVBAMeGFkpWgGL2k/h/whtS4vV/wl1KGI3AEMAQQIUSKJaDSznONLcH9sztlHIUKIdCQAwDQYJKoZIhvcNAQEBBQAEgYAG6kaUWosmlOMDJZmTz37Ltjn0kzim4WIjAYskJdW8MkK6DflUmU2ElHYzH6LJTPXUkPf1lyy1gpZglOIlVKmY3ihtxk2ZKyl/D7w40EGWe0FljsvHShwNypFg++SBE6i5MAAchYbYep+8yUhGyJEKKCJpCQP3257oToafOryypTCCAQoCAQAwczBbMRkwFwYDVQQKHhBZKVoBi9pP4f8IbUuL1f8JMRswGQYDVQQLHhJZKVoBi9pP4f8IbUuL1f8JkOgxITAfBgNVBAMeGFkpWgGL2k/h/whtS4vV/wl1KGI3AEMAQQIUUNc9q0Brt27vxZE4n4mHUFTiCQAwDQYJKoZIhvcNAQEBBQAEgYBpE485t/hVv9qqvfKxmObzaaND7Zu7m25XVHMgaVKPlXf4mHV/Ne4AAfVBVof2nBP1Ek0eAtMZPOenLUVdtsiOoskFv5W9Lg0rGTJrgNqA9h0Oe12VViDhvX/4fRqt5dUZ7p0v37w2BoRXs0IL92ywkabwyxw+Jx0jy9XHO+nLYjCCAQoCAQAwczBbMRkwFwYDVQQKHhBZKVoBi9pP4f8IbUuL1f8JMRswGQYDVQQLHhJZKVoBi9pP4f8IbUuL1f8JkOgxITAfBgNVBAMeGFkpWgGL2k/h/whtS4vV/wl1KGI3AEMAQQIUa2vKACdKY1cFXz1euYmHULweCwAwDQYJKoZIhvcNAQEBBQAEgYCkfVM8J9dPkHRpmGcuqMecMr7/NDyAPBIERlrczpkzbq18wmcy95APPnrBYDGVTP3rV2sT82QR6JJbM4Wn7GfFNlYNv2lC3UzqV23hWc9fViwSsG0wcejC9IrUMuz1Xjlbf31q9yqkrMt5igcbK77lTiCTI9ro+rC59OGuUBVZjzCCAQoCAQAwczBbMRkwFwYDVQQKHhBZKVoBi9pP4f8IbUuL1f8JMRswGQYDVQQLHhJZKVoBi9pP4f8IbUuL1f8JkOgxITAfBgNVBAMeGFkpWgGL2k/h/whtS4vV/wl1KGI3AEMAQQIUcaAEM6nKbgRem370oYpZUNfPAAAwDQYJKoZIhvcNAQEBBQAEgYCMP2TsY/8qCqDT1OK9E8Od34p775tZItL0KtdERM95/BWy1RWMEakf1YrDnbLiLm48CwgpwIFrHmOOGLh2aspqwL/bGft9gzF8r/UFfvlvNG/k0+o/v6OMwkFjI7NVy3rL0NRxFfCAXEs+c8Ubr+TXReAb1shbFqGPZT5KfNq50DCCAQoCAQAwczBbMRkwFwYDVQQKHhBZKVoBi9pP4f8IbUuL1f8JMRswGQYDVQQLHhJZKVoBi9pP4f8IbUuL1f8JkOgxITAfBgNVBAMeGFkpWgGL2k/h/whtS4vV/wl1KGI3AEMAQQIUd+qOq2o3YD+GD29kkYmHUFyrCwAwDQYJKoZIhvcNAQEBBQAEgYA8sKj4SzTBugt7i8MsIeAA0p/fv0M65FROOvhxCp/ao5LKOoC9O41gH3HG/iXnWnKQMFh4paDXc3HtItTHnOYquS67vaT9ZmGO9QCY/ZYco9bsGsg+6CvdMOIqmce3WMZtr/TDesg7Seq16BmKUjLoauntuGHLmaG1IasNbo51UjCCAQsCAQAwdDBbMRkwFwYDVQQKHhBZKVoBi9pP4f8IbUuL1f8JMRswGQYDVQQLHhJZKVoBi9pP4f8IbUuL1f8JkOgxITAfBgNVBAMeGFkpWgGL2k/h/whtS4vV/wl1KGI3AEMAQQIVAINGrBX91W8lgFMNZ1mHi0+bmwsAMA0GCSqGSIb3DQEBAQUABIGAXM3YPeCgNiajJiUwr796hDJYrpTO8Mf/qdJuPDrtwTLz4KCDCTlhKrqvURsRUBfLTYkjmmGW5E2wnu/OSqPdqvhLPXcDy+8rptJTab8X6j1x1hR1QYjI9bpk2ezE1pVcS6SFI77ed7QtkjRiVLZhBpAk2Xu/dNx/Rm8HTpbDsxAwggELAgEAMHQwWzEZMBcGA1UECh4QWSlaAYvaT+H/CG1Li9X/CTEbMBkGA1UECx4SWSlaAYvaT+H/CG1Li9X/CZDoMSEwHwYDVQQDHhhZKVoBi9pP4f8IbUuL1f8JdShiNwBDAEECFQCPv9KKOHJQCXAZpgqsiYdQ5EELADANBgkqhkiG9w0BAQEFAASBgM6NwdXVYjHQJIuBvGYb+ln8qpMPOltELR6atTyYyONpV+jWKTC6pnxzEQ0tYlBYs4Hkcku7L0wLMQ2Esf13V73yRrGQFOl3VWUzH3L+moR+gCHIaTVM8Lft07iyYWFEgVgOD2V2o6R0QZyInaLu0VbrdgujHTztL22qtT0kW7sWMIIBCwIBADB0MFsxGTAXBgNVBAoeEFkpWgGL2k/h/whtS4vV/wkxGzAZBgNVBAseElkpWgGL2k/h/whtS4vV/wmQ6DEhMB8GA1UEAx4YWSlaAYvaT+H/CG1Li9X/CXUoYjcAQwBBAhUAniz9aUSu+9J2VHkhlqetUPaVCgAwDQYJKoZIhvcNAQEBBQAEgYCELvC7fxOyeKkbpZqiQYKFM82LMt8O7eODuNKQNURfUyABNqNujiB9Wjras80xHh9id+D1GakfkH4yjWYCkCb+/A4ku0SzByJ0zrQAl8o9LBvx6vrBim0jNd6xw++Yob6ytiMZa1SRuz1c0pcVVWrZVt0C9fQmkmyw1Qk3W1XkvDCCAQsCAQAwdDBbMRkwFwYDVQQKHhBZKVoBi9pP4f8IbUuL1f8JMRswGQYDVQQLHhJZKVoBi9pP4f8IbUuL1f8JkOgxITAfBgNVBAMeGFkpWgGL2k/h/whtS4vV/wl1KGI3AEMAQQIVAKIVfXufyRKY0gh2HEeJh1A0KQYAMA0GCSqGSIb3DQEBAQUABIGAjNYP65iQBNo3m7Q3V3lQ+ATVdPS1onZgtLAqXz3vlY1gBzsc+CyY10TPv8DPqAZ0inRDLH+qeDi3qklKC3UvKvRWzwCVbDCezJsRENoFLm6PNthLqwQoNHEtzBUCOy8bU/5ZQdBZ7FQ2l7bQ8021giPShJbnoQ2OUThUAJqe/iswggELAgEAMHQwWzEZMBcGA1UECh4QWSlaAYvaT+H/CG1Li9X/CTEbMBkGA1UECx4SWSlaAYvaT+H/CG1Li9X/CZDoMSEwHwYDVQQDHhhZKVoBi9pP4f8IbUuL1f8JdShiNwBDAEECFQCkGMYrWNw9opayZJkNzIdO8NQBADANBgkqhkiG9w0BAQEFAASBgI0P9xFEEZXayWXnnSn9At/FkSgrOPq0HzjPKvGkaHcuqlKAKX/uliNDUwBba0wUi49EvwhqXErRzO4+uv7DHj5o3XU0+P94jNxVZIAv5/TREeLlNFn9nURdpU1B9cNk4R3Qqoaef4ljFd4CAzS+5t9gamrI1kzF45tInlaJAciCMIIBCwIBADB0MFsxGTAXBgNVBAoeEFkpWgGL2k/h/whtS4vV/wkxGzAZBgNVBAseElkpWgGL2k/h/whtS4vV/wmQ6DEhMB8GA1UEAx4YWSlaAYvaT+H/CG1Li9X/CXUoYjcAQwBBAhUAqgMlKUBDpe/pacWoEE7IUIotBwAwDQYJKoZIhvcNAQEBBQAEgYDCC/FnkaWlpEB7OgRgZ433ky2AQl3hkBS2y4MXD05j+lu9xDB4Z/O701sua5O5YcSa0iE5jnTm2fcePt9D8hTIVwRrao8wilNBI5R4m60ZiMcLcYF5OhJzl7iH8WzpdZ9nkEDslBW62ZSoSlNSmR3esdJDd5LBCseLgpBwoQtVBjCCAQsCAQAwdDBbMRkwFwYDVQQKHhBZKVoBi9pP4f8IbUuL1f8JMRswGQYDVQQLHhJZKVoBi9pP4f8IbUuL1f8JkOgxITAfBgNVBAMeGFkpWgGL2k/h/whtS4vV/wl1KGI3AEMAQQIVAK41ustlTAC30aBfZpQ4mk98QwsAMA0GCSqGSIb3DQEBAQUABIGAL7z9cNaJhXBzODzTZaBiFK1pLwaMBfs9ekElWXmc1HBxhenLc5/VhScue5KGq9mBjTOl80ezIUsUvgBhhe1d7YPTIT6SkJQksfNX51DvjjuGAX8FhCVBGnvQE4VcnzBPaS4fHughz2y1IsMpkJZ9T8GFE+Q3I2j/4lCtYFwuIDgwggELAgEAMHQwWzEZMBcGA1UECh4QWSlaAYvaT+H/CG1Li9X/CTEbMBkGA1UECx4SWSlaAYvaT+H/CG1Li9X/CZDoMSEwHwYDVQQDHhhZKVoBi9pP4f8IbUuL1f8JdShiNwBDAEECFQC2ieO2bbshwR/Ajpk6Nr9POOIJADANBgkqhkiG9w0BAQEFAASBgH4YXBH7DQDnamuHI087U6O2a9SqrYvvY1DaniqXMt63PNrsfE9VGIo+ryK3XpjofsAns9OPpJRSVv/+mtgINWdq0Y19cMtbucQMUqvNcg6btdMz4XPoGQbTt2KYmQntaT1fNjW3iMDIlS/1WrFH6Gp3+VClQHYGkW2kGvtxjgeXMIIBCwIBADB0MFsxGTAXBgNVBAoeEFkpWgGL2k/h/whtS4vV/wkxGzAZBgNVBAseElkpWgGL2k/h/whtS4vV/wmQ6DEhMB8GA1UEAx4YWSlaAYvaT+H/CG1Li9X/CXUoYjcAQwBBAhUA3+VrR8GRAuAfKzWta4+RTaGcDgAwDQYJKoZIhvcNAQEBBQAEgYBOzPf/El2ZGY964TJLX37KDG4tu0bS+W56Tn0J5D8jnHUgZx9lVJFDkhZUJrQOUbcRG+vCZPxBzLLj6uQAi7lu8EFapT/a82eR9m8urIVuRc4YgjiBoQcpEKiDLtOF+6j//kLNF578cPOm9s4BmrQp9mM0T6GQ/bW5/JGomj1ilTCCAQsCAQAwdDBbMRkwFwYDVQQKHhBZKVoBi9pP4f8IbUuL1f8JMRswGQYDVQQLHhJZKVoBi9pP4f8IbUuL1f8JkOgxITAfBgNVBAMeGFkpWgGL2k/h/whtS4vV/wl1KGI3AEMAQQIVAObhdWfWjzXUlgZZSzaJh1B0pwsAMA0GCSqGSIb3DQEBAQUABIGAUhMYoBGHosrqzUr050hmab656sR9T/H2XS05iCLtmk4xEZLLQ7HuzzPAMAex0JWIwyKPeOIH+BHibQWd0BzD3vpQQAfFtXn2K8/OFh80ngBnAWzyH2yaVXEM9vKaISnlk08yEc9hm3f8+yACB9WgWNzJOdSsBX2OpmT4kh71elYwggELAgEAMHQwWzEZMBcGA1UECh4QWSlaAYvaT+H/CG1Li9X/CTEbMBkGA1UECx4SWSlaAYvaT+H/CG1Li9X/CZDoMSEwHwYDVQQDHhhZKVoBi9pP4f8IbUuL1f8JdShiNwBDAEECFQD4uamzTTGz7nS9MA2th4tPy6sHADANBgkqhkiG9w0BAQEFAASBgKqmHkAyzW3rypaSIDJw870XjSkoC2Ep4SJA9tqH5RGYb0g7fGN48W2HuLRtjs82vpyng2k8qpaQ6s6X4q3xMC+ds0wW1arvyumnSmrpTmPM5C2mmupA1Pcs63+n3oxPN2N9+bQvnbEWODezayLEVcl2pYD1vjpK7WP59XhuCEDDMIIBCwIBADB0MFsxGTAXBgNVBAoeEFkpWgGL2k/h/whtS4vV/wkxGzAZBgNVBAseElkpWgGL2k/h/whtS4vV/wmQ6DEhMB8GA1UEAx4YWSlaAYvaT+H/CG1Li9X/CXUoYjcAQwBBAhUA+zEQE//KMbCJe2240IiHUPwrDgAwDQYJKoZIhvcNAQEBBQAEgYA7AJeLTKPd7lRIutjkU+8qCxCoxjQXo8StN/rZd01gH9Qpsq2TBn6hdut0RLRVQ6tHQFxsyvHNhni/yvqdjOFyJuUx15Q+XT3cYesFDw24MwiDgMXbEGb7l4A+TOfrrjFLs7ZpkgHo8CJW6DEN47mimuFrY2edjeYE7UmOHCTrbDCCAQwCAQAwdTBdMRkwFwYDVQQKHhBZKVoBi9pP4f8IbUuL1f8JMRswGQYDVQQLHhJZKVoBi9pP4f8IbUuL1f8JkOgxIzAhBgNVBAMeGlkpWgGL2k/h/whtS4vV/wl7oXQGVFgAQwBBAhRGpnm0TtZbtZ7HiA+2bb1NmScOADANBgkqhkiG9w0BAQEFAASBgBSWni5YufXSpQHtXmQMWw7Gb4x73ReVLFiLUhLcOzH23Y7ZvuxP/FQTXPvK2cgkbiv2//9yz/04hpM948OH3Vsd13/LFwVG+CGrk9k3zV3JoXilzy3EKArlDMtds08skKuLsY9WHFlzmIoKRRg0d3A9DreJCe0lmgx8/9nqckpqMIIBDQIBADB2MF0xGTAXBgNVBAoeEFkpWgGL2k/h/whtS4vV/wkxGzAZBgNVBAseElkpWgGL2k/h/whtS4vV/wmQ6DEjMCEGA1UEAx4aWSlaAYvaT+H/CG1Li9X/CXuhdAZUWABDAEECFQCKbW+GpfhTz/D+j4LMar1N0R4HADANBgkqhkiG9w0BAQEFAASBgJCrY0AJragNBIIcX8U3VYDsUAJS164mSVawgoAfuCPj9NiQQDLCWj4SHxYOCOEZS4opSvN7sJGCPCfRbjCtoNs8zMtAY1+blOVc/hNFS89wCusqtlbphAxZsrRkpjpJTg0S3/zAQvYyQSjQV5is5FGWMQU2JrWzK6rffXAtbh7pMIIBDwIBADB4MGAxDTALBgNVBAYeBABDAE4xITAfBgNVBAoeGE4tVv2P3FknlsZW4mcJllCNI077UWxT+DEVMBMGA1UECx4MjSJSoXuhdAZgO5DoMRUwEwYDVQQDHgyP3FknlsZW4gBDAEECFErRzvMRCxXATAZKCFKBm1CDgAkAMA0GCSqGSIb3DQEBAQUABIGAfflpOI/squbKI9ut5hfDvVBTcE8MzmOnB9jamzJahZS68D6+DQR4GlvJrRRACmb6FU7I/z0eRRysbLwEqe4BPP5mWWiaSYMNaUwhd9j484dFYc2IeqFUI2KtQS3ziMqY/qf4ZrcI4i0/XRHzIFENH510rI8aE1CLm5/kXr91PK4wggERAgEAMHowYTEZMBcGA1UECh4QWSlaAYvaT+H/CG1Li9X/CTEbMBkGA1UECx4SWSlaAYvaT+H/CG1Li9X/CZDoMScwJQYDVQQDHh5ZKVoBi9pP4f8IbUuL1f8JAFIAQXuhdAZUWABDAEECFQCSY6Rs05e5xoyiT460b71NiVQAADANBgkqhkiG9w0BAQEFAASBgBrci+SIexTeYQxEXuHu28pJTxr+ATjEZptm5oJHeRWRQOt+Ul31cpQ44QzSpAlRE9F9fb3hdhNO/WU7KtEsO36F/LRdRvHJHK2gckl6YMGzJHHSzNZQ+WpUjvDThoi+mZzqD7IRt2zZMz7ljwxduJuRF5XSjFIKI1PCmKFYdvgMMIIBIAIBADCBiDBwMQ0wCwYDVQQGHgQAQwBOMSkwJwYDVQQKHiBTF06sWSlaAYvaT+F1NVtQVUZSoWcNUqFnCZZQUWxT+DEVMBMGA1UECx4MjURukHuhdAZ8+37fMR0wGwYDVQQDHhRZKVoBi9pP4Y1EbpB7oXQGAEMAQQIUXgd8M0kO+4AjaMJZY7wHUMroBwAwDQYJKoZIhvcNAQEBBQAEgYBXQbSoJNhwCBQNETT5tiZDSMpZoHT8yP1wPSbRhxKW9sosT+/lf3OKwSk1IwI8mzHpNkp+b5WowhG6m04QF88tAO/wEEKDHHZLk4Zokmu+iQXms2Mftni67gn3sZzsW4lgZIowmQPFEpSgxkrq7UnKQmjkK+lwJsVvyfYvpEb/JzCCAWQCAQAwgcwwgbMxHTAbBgNVBAoTFGlUcnVzY2hpbmEgQ28uLCBMdGQuMRwwGgYDVQQLExNDaGluYSBUcnVzdCBOZXR3b3JrMUAwPgYDVQQLEzdUZXJtcyBvZiB1c2UgYXQgaHR0cHM6Ly93d3cuaXRydXMuY29tLmNuL2N0bnJwYSAoYykyMDA1MTIwMAYDVQQDEylpVHJ1c2NoaW5hIENOIEVudGVycHJpc2UgQWRtaW5pc3RyYXRvciBDQQIUOsREklYUdU/pPF2BToGOT6NXAQAwDQYJKoZIhvcNAQEBBQAEgYB1an+KD2D2ECSKn0gxhhgsM4+NCTmYfhNWYn6ZqT80ciPx6bKwpzWNXw5q2hg+zBduS3IZWyJp6k2Kh3i3Ma/q6YIJA3uv/lyaujQ7ptpRk1ayYq74bleIhYeM6njZ40Do8kSeC/YMI7ppGGtgca8hG6uJO7PsngzWSPArOYMuVTCCAWYCAQAwgc4wgbQxHTAbBgNVBAoTFGlUcnVzY2hpbmEgQ28uLCBMdGQuMR4wHAYDVQQLExVDaGluZXNlIFRydXN0IE5ldHdvcmsxQDA+BgNVBAsTN1Rlcm1zIG9mIHVzZSBhdCBodHRwczovL3d3dy5pdHJ1cy5jb20uY24vY3RucnBhIChjKTIwMDMxMTAvBgNVBAMTKGlUcnVzY2hpbmEgQ04gRW50ZXJwcmlzZSBTdWJzY3JpYmVyIENBLTMCFQDefYa+TDgpX/FuXS2NGsdPW58GADANBgkqhkiG9w0BAQEFAASBgAoI5d8eZnVWOiDkQtH7LZWoFpbkZCpsgnnFMLdlO4gqR3TlWEH5tUMGVM04Wc09txyk302DoagaGiXx4I/d/n+qL39DnE3nPv5SeIZPwXKpzYeQE2IiXfTQ621n6joCXmvvRQ0jLygibVoz7XdAm7wCktOAJr4lQobVVg/lhuhgMIIBZgIBADCBzjCBtDEdMBsGA1UEChMUaVRydXNjaGluYSBDby4sIEx0ZC4xHjAcBgNVBAsTFUNoaW5lc2UgVHJ1c3QgTmV0d29yazFAMD4GA1UECxM3VGVybXMgb2YgdXNlIGF0IGh0dHBzOi8vd3d3Lml0cnVzLmNvbS5jbi9jdG5ycGEgKGMpMjAwMzExMC8GA1UEAxMoaVRydXNjaGluYSBDTiBFbnRlcnByaXNlIFN1YnNjcmliZXIgQ0EtMwIVAPhKt7QCX7Lj9I02ebvIh0/F1QcAMA0GCSqGSIb3DQEBAQUABIGAOJIxZ5RcBJhJA4x0sDDZAqQDGp7fArq9Oyvx8QBucu8eFAP5ZDKutBNa3sYal1xwtD1PbNCDO4Pnh8nBFDkgjv0lgPvlo02SzqvX6XyPoqyszDcRKON1yl6rcc+FK/SW/ivJf1b49wV/6Fzeu9fZ/G4D7xJrk/MkG7So6YPsd50wggF6AgEAMIHiMIHIMQswCQYDVQQGEwJDTjEdMBsGA1UECgwUaVRydXNjaGluYSBDby4sIEx0ZC4xHDAaBgNVBAsME0NoaW5hIFRydXN0IE5ldHdvcmsxQDA+BgNVBAsMN1Rlcm1zIG9mIHVzZSBhdCBodHRwczovL3d3dy5pdHJ1cy5jb20uY24vY3RucnBhIChjKTIwMDcxOjA4BgNVBAMMMWlUcnVzY2hpbmEgQ04gRW50ZXJwcmlzZSBJbmRpdmlkdWFsIFN1YnNjcmliZXIgQ0ECFQDK6AY2ld0V6u676NxiR8NNJOUEADANBgkqhkiG9w0BAQEFAASBgBythl8Gpae1owSWBD3tVjnskT3Q8AZocgVcgb7wrfXfkeWa9yQQTTm+daHjt5VVOUXUNi4IE4cbsAz+vipAqW3XOTRTW0guVIROnlvVBolFUMNDuZJQaHQuOeHTL9933rF/WNkECJJ+xa1djUT6buV7ac+E+d4DZT7apL/ZL+IqMFMGCSqGSIb3DQEHATAUBggqhkiG9w0DBwQITjshmwJMKPOAMJKfXdBUEt9IpQMcUvxVrYU3cyKcczvhD63c9sjB5jlzhS/gOxYlwzx6G3E49+WdYw==");
        RecipientBcImpl rbi = new RecipientBcImpl();
        rbi.initCertWithKey("D:/653.pfx", "password".toCharArray());
        byte[] bb = rbi.decryptMessage(encry);
        System.out.println(new String(bb));
    }
}

