/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.cryptorole.bc;

import cn.topca.security.sm.TopSMProvider;
import cn.topca.security.x509.AlgorithmId;
import com.itrus.asn1.cms.SignedAndEnvelopedData;
import com.itrus.cms.jcajce.RsaSignerInfoGenerator;
import com.itrus.cms.jcajce.SM2RecipientInfoGenerator;
import com.itrus.cms.jcajce.SM2SignerInfoGenerator;
import com.itrus.cryptorole.CryptoException;
import com.itrus.cryptorole.NotSupportException;
import com.itrus.cryptorole.Sender;
import com.itrus.security.pkcs.PKCS7SignedData;
import com.itrus.util.FileUtils;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.EncryptedContentInfo;
import org.bouncycastle.asn1.cms.EnvelopedData;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSEnvelopedDataGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.util.encoders.Base64;

public class SenderBcImpl
extends Sender {
    public static final String DES_EDE3_CBC = "1.2.840.113549.3.7";
    public static final String RC2_CBC = "1.2.840.113549.3.2";
    public static final String IDEA_CBC = "1.3.6.1.4.1.188.7.1.1.2";
    public static final String CAST5_CBC = "1.2.840.113533.7.66.10";
    public static final String AES128_CBC = "2.16.840.1.101.3.4.1.2";
    public static final String AES192_CBC = "2.16.840.1.101.3.4.1.22";
    public static final String AES256_CBC = "2.16.840.1.101.3.4.1.42";
    private static String PROVIDER = "BC";
    private static String PROVIDER_TOPSM = "TopSM";

    static {
        if (Security.getProvider(PROVIDER) == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        if (Security.getProperty(PROVIDER_TOPSM) == null) {
            Security.addProvider((Provider)new TopSMProvider());
        }
    }

    public void initCertWithKey(String keyStoreFileName, char[] keyStorePassword, String keyAlias, char[] keyPassword) throws NotSupportException, CryptoException {
        try {
            FileInputStream fis = new FileInputStream(keyStoreFileName);
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(fis, keyStorePassword);
            fis.close();
            this.keyOfSigner = (PrivateKey)keyStore.getKey(keyAlias, keyPassword);
            this.certOfSigner = (X509Certificate)keyStore.getCertificate(keyAlias);
        }
        catch (FileNotFoundException e) {
            throw new CryptoException(e);
        }
        catch (KeyStoreException e) {
            throw new CryptoException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
        catch (CertificateException e) {
            throw new CryptoException(e);
        }
        catch (IOException e) {
            throw new CryptoException(e);
        }
        catch (UnrecoverableKeyException e) {
            throw new CryptoException(e);
        }
    }

    public void initCertWithKey(String pfxFileName, char[] keyPassword) throws NotSupportException, CryptoException {
        try {
            FileInputStream fis = new FileInputStream(pfxFileName);
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            keyStore.load(fis, keyPassword);
            fis.close();
            Enumeration<String> enums = keyStore.aliases();
            while (enums.hasMoreElements()) {
                String keyAlias = enums.nextElement();
                if (!keyStore.isKeyEntry(keyAlias)) continue;
                this.keyOfSigner = (PrivateKey)keyStore.getKey(keyAlias, keyPassword);
                this.certOfSigner = (X509Certificate)keyStore.getCertificate(keyAlias);
            }
        }
        catch (FileNotFoundException e) {
            throw new CryptoException(e);
        }
        catch (KeyStoreException e) {
            throw new CryptoException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
        catch (CertificateException e) {
            throw new CryptoException(e);
        }
        catch (IOException e) {
            throw new CryptoException(e);
        }
        catch (UnrecoverableKeyException e) {
            throw new CryptoException(e);
        }
    }

    public void initCertWithKey(String pfxFileName, String keyPassword) throws NotSupportException, CryptoException {
        this.initCertWithKey(pfxFileName, keyPassword.toCharArray());
    }

    public byte[] doSign(byte[] originalMessage) throws NotSupportException, CryptoException {
        byte[] encryptedDigest;
        if (this.keyOfSigner == null || this.certOfSigner == null) {
            throw new CryptoException(this.notInitializeKeyMessage);
        }
        if (this.keyOfSigner.getAlgorithm().equalsIgnoreCase("SM2") || this.keyOfSigner.getAlgorithm().equals(AlgorithmId.SM2_oid.toString())) {
            this.signAlgorithm = "SM3withSM2";
        }
        try {
            Signature signature = Signature.getInstance(this.signAlgorithm);
            signature.initSign(this.keyOfSigner);
            signature.update(originalMessage);
            encryptedDigest = signature.sign();
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
        catch (InvalidKeyException e) {
            throw new CryptoException(e);
        }
        catch (SignatureException e) {
            throw new CryptoException(e);
        }
        if (encryptedDigest != null) {
            return encryptedDigest;
        }
        throw new CryptoException("\u7b7e\u540d\u503c\u751f\u6210\u5931\u8d25");
    }

    public String signMessage(String plainText) throws CryptoException, UnsupportedEncodingException {
        return new String(Base64.encode((byte[])this.signMessage(plainText.getBytes("iso8859-1"))));
    }

    public byte[] signMessage(byte[] originalMessage) throws CryptoException {
        if (this.keyOfSigner == null || this.certOfSigner == null) {
            throw new CryptoException(this.notInitializeKeyMessage);
        }
        if (this.keyOfSigner.getAlgorithm().equalsIgnoreCase("SM2") || this.keyOfSigner.getAlgorithm().equals(AlgorithmId.SM2_oid.toString())) {
            this.signAlgorithm = "SM3withSM2";
        }
        Certificate[] chain = new X509Certificate[]{this.certOfSigner};
        try {
            PKCS7SignedData p7Object = new PKCS7SignedData(this.keyOfSigner, chain, this.signAlgorithm.substring(0, this.signAlgorithm.indexOf("with")));
            p7Object.update(originalMessage, 0, originalMessage.length);
            return p7Object.getEncoded();
        }
        catch (InvalidKeyException e) {
            throw new CryptoException(e);
        }
        catch (SecurityException e) {
            throw new CryptoException(e);
        }
        catch (NoSuchProviderException e) {
            throw new CryptoException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
        catch (SignatureException e) {
            throw new CryptoException(e);
        }
    }

    public byte[] signMessageIncludeOriginal(byte[] originalMessage) throws NotSupportException, CryptoException {
        if (this.keyOfSigner == null || this.certOfSigner == null) {
            throw new CryptoException(this.notInitializeKeyMessage);
        }
        if (this.keyOfSigner.getAlgorithm().equalsIgnoreCase("SM2") || this.keyOfSigner.getAlgorithm().equals(AlgorithmId.SM2_oid.toString())) {
            this.signAlgorithm = "SM3withSM2";
        }
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        certList.add(this.certOfSigner);
        CertStore certs = null;
        try {
            certs = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(certList), PROVIDER);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CryptoException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
        catch (NoSuchProviderException e) {
            throw new CryptoException(e);
        }
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        if (this.keyOfSigner.getAlgorithm().equalsIgnoreCase("SM2") || this.keyOfSigner.getAlgorithm().equals(AlgorithmId.SM2_oid.toString())) {
            try {
                gen.addSignerInfoGenerator((SignerInfoGenerator)new SM2SignerInfoGenerator(this.keyOfSigner, this.certOfSigner));
            }
            catch (OperatorCreationException e) {
                throw new CryptoException(e);
            }
        }
        try {
            gen.addSignerInfoGenerator((SignerInfoGenerator)new RsaSignerInfoGenerator(this.keyOfSigner, this.certOfSigner));
        }
        catch (OperatorCreationException e) {
            throw new CryptoException(e);
        }
        try {
            gen.addCertificatesAndCRLs(certs);
        }
        catch (CertStoreException e) {
            throw new CryptoException(e);
        }
        catch (CMSException e) {
            throw new CryptoException(e);
        }
        try {
            CMSSignedData csd = gen.generate((CMSProcessable)new CMSProcessableByteArray(originalMessage), true, PROVIDER);
            return csd.getEncoded();
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
        catch (NoSuchProviderException e) {
            throw new CryptoException(e);
        }
        catch (CMSException e) {
            throw new CryptoException(e);
        }
        catch (IOException e) {
            throw new CryptoException(e);
        }
    }

    public byte[] encryptMessage(byte[] originalMessage) throws CryptoException {
        CMSEnvelopedDataGenerator envelopedGen = new CMSEnvelopedDataGenerator();
        if (this.recipientCerts.size() == 0) {
            throw new CryptoException(this.notAddEncryptCertMessage);
        }
        int i = 0;
        while (i < this.recipientCerts.size()) {
            X509Certificate cert = (X509Certificate)this.recipientCerts.elementAt(i);
            if ("SM2".equalsIgnoreCase(cert.getPublicKey().getAlgorithm())) {
                SM2RecipientInfoGenerator recipientinfogenerator = new SM2RecipientInfoGenerator(cert);
                envelopedGen.addRecipientInfoGenerator((RecipientInfoGenerator)recipientinfogenerator);
            } else {
                envelopedGen.addKeyTransRecipient(cert);
            }
            ++i;
        }
        CMSProcessableByteArray cMSProcessable = new CMSProcessableByteArray(originalMessage);
        try {
            CMSEnvelopedData enveloped = envelopedGen.generate((CMSProcessable)cMSProcessable, this.encryptAlgorithm, PROVIDER);
            return enveloped.getEncoded();
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
        catch (NoSuchProviderException e) {
            throw new CryptoException(e);
        }
        catch (CMSException e) {
            throw new CryptoException(e);
        }
        catch (IOException e) {
            throw new CryptoException(e);
        }
    }

    public void encryptFile(String originalFileName, String destinationFileName) throws CryptoException {
        try {
            byte[] originalMessage = FileUtils.readBytesFromFile(originalFileName);
            byte[] encryptedMessage = this.encryptMessage(originalMessage);
            FileUtils.saveBytesToFile(encryptedMessage, destinationFileName);
        }
        catch (IOException e) {
            throw new CryptoException(e);
        }
    }

    public void encryptFileEx(String srcFileName, String encryptedFileName) throws CryptoException {
        FileInputStream in = null;
        OutputStream out = null;
        try {
            try {
                in = new FileInputStream(srcFileName);
                out = new FileOutputStream(encryptedFileName);
                KeyGenerator keygen = KeyGenerator.getInstance("DESede");
                SecretKey key = keygen.generateKey();
                SecretKeyFactory keyfactory = SecretKeyFactory.getInstance("DESede");
                DESedeKeySpec keyspec = (DESedeKeySpec)keyfactory.getKeySpec(key, DESedeKeySpec.class);
                byte[] rawkey = keyspec.getKey();
                byte[] tempkey = new byte[32];
                int i = 0;
                while (i < tempkey.length) {
                    tempkey[i] = i < rawkey.length ? rawkey[i] : (byte)0;
                    ++i;
                }
                String szB64Key = new String(Base64.encode((byte[])tempkey));
                szB64Key = szB64Key.trim();
                IvParameterSpec iv = new IvParameterSpec(new byte[8]);
                byte[] rawiv = iv.getIV();
                byte[] tempiv = new byte[16];
                int i2 = 0;
                while (i2 < tempiv.length) {
                    tempiv[i2] = i2 < rawiv.length ? rawiv[i2] : (byte)0;
                    ++i2;
                }
                String szB64IV = new String(Base64.encode((byte[])tempiv));
                szB64IV = szB64IV.trim();
                String szB64KeyAndIV = String.valueOf(szB64Key.trim()) + "|" + szB64IV.trim();
                szB64KeyAndIV = new String(Base64.encode((byte[])szB64KeyAndIV.getBytes()));
                szB64KeyAndIV = szB64KeyAndIV.replaceAll("\r\n", "");
                byte[] p7 = this.encryptMessage(szB64KeyAndIV.getBytes());
                szB64KeyAndIV = new String(Base64.encode((byte[])p7)).replaceAll("\r\n", "");
                szB64KeyAndIV = String.valueOf(szB64KeyAndIV) + "|";
                out.write(szB64KeyAndIV.getBytes());
                Cipher c1 = Cipher.getInstance("DESede/CBC/PKCS5Padding");
                c1.init(1, (Key)key, iv, null);
                byte[] buff = new byte[10240];
                int size = 0;
                byte[] buff2 = null;
                while ((size = ((InputStream)in).read(buff)) != -1) {
                    buff2 = c1.update(buff, 0, size);
                    out.write(buff2);
                }
                buff2 = c1.doFinal();
                out.write(buff2);
            }
            catch (FileNotFoundException e) {
                throw new CryptoException(e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new CryptoException(e);
            }
            catch (InvalidKeySpecException e) {
                throw new CryptoException(e);
            }
            catch (NoSuchPaddingException e) {
                throw new CryptoException(e);
            }
            catch (InvalidKeyException e) {
                throw new CryptoException(e);
            }
            catch (InvalidAlgorithmParameterException e) {
                throw new CryptoException(e);
            }
            catch (IOException e) {
                throw new CryptoException(e);
            }
            catch (IllegalBlockSizeException e) {
                throw new CryptoException(e);
            }
            catch (BadPaddingException e) {
                throw new CryptoException(e);
            }
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    throw new CryptoException(e);
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    throw new CryptoException(e);
                }
            }
        }
    }

    public static void encryptFileWithSymmtricKey(String symmetricKey, String srcFileName, String encryptedFileName) throws CryptoException {
        FileInputStream in = null;
        OutputStream out = null;
        try {
            try {
                in = new FileInputStream(srcFileName);
                out = new FileOutputStream(encryptedFileName);
                byte[] szB64KeyAndIV = Base64.decode((String)new String(symmetricKey));
                byte[] szB64Key = null;
                byte[] szB64IV = null;
                String temp = new String(szB64KeyAndIV);
                int index = temp.indexOf("|");
                String temp2 = temp.substring(0, index);
                String temp3 = temp.substring(index + 1);
                szB64Key = temp2.getBytes();
                szB64IV = temp3.getBytes();
                byte[] bkey = Base64.decode((String)new String(szB64Key));
                byte[] biv = Base64.decode((String)new String(szB64IV));
                DESedeKeySpec dks = new DESedeKeySpec(bkey);
                SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DESede");
                SecretKey key = keyFactory.generateSecret(dks);
                IvParameterSpec iv = new IvParameterSpec(biv, 0, 8);
                Cipher c1 = Cipher.getInstance("DESede/CBC/PKCS5Padding");
                c1.init(1, (Key)key, iv, null);
                byte[] buff = new byte[10240];
                int size = 0;
                byte[] buff2 = null;
                while ((size = ((InputStream)in).read(buff)) != -1) {
                    buff2 = c1.update(buff, 0, size);
                    out.write(buff2);
                }
                buff2 = c1.doFinal();
                out.write(buff2);
            }
            catch (Exception e) {
                throw new CryptoException(e);
            }
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    throw new CryptoException(e);
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    throw new CryptoException(e);
                }
            }
        }
    }

    public byte[] signAndEnvelopMessage(byte[] originalMessage) throws CryptoException {
        CMSEnvelopedData cMSEnvelopedData;
        CMSSignedData cMSSignedData;
        if (this.keyOfSigner == null || this.certOfSigner == null) {
            throw new CryptoException(this.notInitializeKeyMessage);
        }
        if (this.recipientCerts.size() == 0) {
            throw new CryptoException(this.notAddEncryptCertMessage);
        }
        CMSSignedDataGenerator sigGen = new CMSSignedDataGenerator();
        CMSEnvelopedDataGenerator envGen = new CMSEnvelopedDataGenerator();
        if ("SM2".equalsIgnoreCase(this.keyOfSigner.getAlgorithm())) {
            try {
                sigGen.addSignerInfoGenerator((SignerInfoGenerator)new SM2SignerInfoGenerator(this.keyOfSigner, this.certOfSigner));
            }
            catch (OperatorCreationException e) {
                throw new CryptoException(e);
            }
        }
        try {
            sigGen.addSignerInfoGenerator((SignerInfoGenerator)new RsaSignerInfoGenerator(this.keyOfSigner, this.certOfSigner));
        }
        catch (OperatorCreationException e) {
            throw new CryptoException(e);
        }
        X509Certificate[] certs = new X509Certificate[]{this.certOfSigner};
        try {
            CertStore certStore = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(Arrays.asList(certs)), PROVIDER);
            sigGen.addCertificatesAndCRLs(certStore);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CryptoException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
        catch (NoSuchProviderException e) {
            throw new CryptoException(e);
        }
        catch (CertStoreException e) {
            throw new CryptoException(e);
        }
        catch (CMSException e) {
            throw new CryptoException(e);
        }
        CMSProcessableByteArray content = new CMSProcessableByteArray(originalMessage);
        try {
            cMSSignedData = sigGen.generate((CMSProcessable)content, PROVIDER);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
        catch (NoSuchProviderException e) {
            throw new CryptoException(e);
        }
        catch (CMSException e) {
            throw new CryptoException(e);
        }
        int i = 0;
        while (i < this.recipientCerts.size()) {
            X509Certificate cert = (X509Certificate)this.recipientCerts.elementAt(i);
            if ("SM2".equalsIgnoreCase(cert.getPublicKey().getAlgorithm())) {
                SM2RecipientInfoGenerator recipientinfogenerator = new SM2RecipientInfoGenerator(cert);
                envGen.addRecipientInfoGenerator((RecipientInfoGenerator)recipientinfogenerator);
            } else {
                envGen.addKeyTransRecipient(cert);
            }
            ++i;
        }
        try {
            cMSEnvelopedData = envGen.generate((CMSProcessable)content, this.encryptAlgorithm, PROVIDER);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
        catch (NoSuchProviderException e) {
            throw new CryptoException(e);
        }
        catch (CMSException e) {
            throw new CryptoException(e);
        }
        SignedData signedData = SignedData.getInstance((Object)cMSSignedData.getContentInfo().getContent());
        ASN1Set signerInfos = signedData.getSignerInfos();
        EnvelopedData envelopedData = EnvelopedData.getInstance((Object)cMSEnvelopedData.getContentInfo().getContent());
        ASN1Set recipientInfos = envelopedData.getRecipientInfos();
        EncryptedContentInfo encryptedContentInfo = envelopedData.getEncryptedContentInfo();
        ASN1Set digestAlgorithms = signedData.getDigestAlgorithms();
        DERSet certificates = null;
        ASN1EncodableVector v = new ASN1EncodableVector();
        try {
            v.add((DEREncodable)X509CertificateStructure.getInstance((Object)ASN1Object.fromByteArray((byte[])this.certOfSigner.getEncoded())));
        }
        catch (CertificateEncodingException e) {
            throw new CryptoException(e);
        }
        catch (IOException e) {
            throw new CryptoException(e);
        }
        certificates = new DERSet(v);
        SignedAndEnvelopedData signedAndEnvelopedData = new SignedAndEnvelopedData(recipientInfos, digestAlgorithms, encryptedContentInfo, (ASN1Set)certificates, null, signerInfos);
        byte[] encoded = null;
        try {
            encoded = signedAndEnvelopedData.getEncoded();
        }
        catch (IOException e) {
            throw new CryptoException(e);
        }
        return encoded;
    }
}

