/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.cvm;

import com.itrus.cert.Names;
import com.itrus.cert.X509CRL;
import com.itrus.cert.X509Certificate;
import com.itrus.cvm.CRLContextConfInfo;
import com.itrus.cvm.CRLDownloadThread;
import com.itrus.util.Semaphore;
import java.io.IOException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CRLContext {
    private static Log log = LogFactory.getLog((String)"ITRUS-CVM");
    private String m_CaAlias;
    private X509CRL m_X509CRL = null;
    private X509Certificate m_CaCert = null;
    private String m_CAFilePath = null;
    private String m_CrlUrl = null;
    private String m_UserCrlUrl = null;
    private String m_CrlFilePath = null;
    private String m_AccountHash = null;
    private int[] m_RetryPolicy = null;
    private boolean m_isNotCheckCRL = false;
    private Semaphore m_semaphore = new Semaphore();
    private int m_status = 0;
    private boolean m_TimingDownload = false;

    public boolean isTimingDownload() {
        return this.m_TimingDownload;
    }

    public void cancelTimingDownload() {
        this.m_TimingDownload = false;
    }

    public CRLContext(CRLContextConfInfo confInfo) throws IOException, CertificateException, NoSuchProviderException {
        this.m_CaCert = X509Certificate.getInstanceFromFile(confInfo.getCAFilePath());
        this.m_CAFilePath = confInfo.getCAFilePath();
        this.m_CrlFilePath = confInfo.getCRLFilePath();
        this.m_CrlUrl = confInfo.getCRLUrl();
        this.m_RetryPolicy = confInfo.getRetryPolicy();
        Names names = this.m_CaCert.getSubjectNames();
        this.m_CaAlias = names.getItem("CN") != null ? names.getItem("CN") : (String)names.getItems((String)names.keys().nextElement()).elementAt(0);
        this.m_isNotCheckCRL = confInfo.isNotCheckCRL();
        this.m_AccountHash = confInfo.getAccountHash();
        this.m_TimingDownload = confInfo.isTimingDownload();
        try {
            this.m_X509CRL = X509CRL.getInstanceFromFile(this.m_CrlFilePath);
            if (!this.m_isNotCheckCRL && !this.isCRLIssuedByLegalCA(this.m_X509CRL, this.m_CaCert)) {
                log.warn((Object)("(" + this.m_CaAlias + ")\u4e0b\u8f7d\u5230\u7684CRL\u4e0d\u662f\u7531\u6307\u5b9aCA\u9881\u53d1\u7684\u3002"));
                this.m_X509CRL = null;
            }
            log.info((Object)("\u52a0\u8f7dCRL\u6210\u529f(" + this.m_CaAlias + "),(CrlFilePath:" + this.m_CrlFilePath + ")\u3002"));
        }
        catch (Exception e) {
            log.warn((Object)("(" + this.m_CaAlias + ")\u8bfb\u53d6CRL\u6587\u4ef6\u9519\u8bef\uff1a[" + e.getMessage() + "]" + this.m_CrlFilePath));
        }
        this.getX509CRL();
    }

    public boolean isCRLIssuedByLegalCA(X509CRL x509CRL, X509Certificate caCert) {
        try {
            x509CRL.verify(caCert.getPublicKey());
            return true;
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage());
            return false;
        }
    }

    public X509Certificate getCaCert() {
        return this.m_CaCert;
    }

    public X509CRL getX509CRL(String userCrlUrl) {
        this.m_UserCrlUrl = userCrlUrl;
        return this.getX509CRL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public X509CRL getX509CRL() {
        block10: {
            try {
                try {
                    this.m_semaphore.waitReadSemaphore();
                    if (this.m_X509CRL != null && this.m_X509CRL.isOnValidPeriod() && !this.m_TimingDownload) break block10;
                    if (this.m_CrlUrl == null && this.m_UserCrlUrl == null) {
                        log.error((Object)("(" + this.m_CaAlias + ")" + "\u65e0\u6cd5\u4ece\u914d\u7f6e\u6587\u4ef6\u6216\u7528\u6237\u8bc1\u4e66\u4e2d\u53d6\u5f97CRL\u4e0b\u8f7d\u5730\u5740\u3002"));
                        break block10;
                    }
                    if (this.m_status == 0) {
                        Semaphore semaphore = this.m_semaphore;
                        synchronized (semaphore) {
                            CRLDownloadThread thread = new CRLDownloadThread(this);
                            thread.start();
                            break block10;
                        }
                    }
                    log.info((Object)("(" + this.m_CaAlias + ")" + "\u5df2\u7ecf\u542f\u52a8\u4e86\u4e0b\u8f7d\u7ebf\u7a0b\uff0c\u9000\u51fa\u2026\u2026"));
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    this.m_semaphore.releaseReadSemaphore();
                }
            }
            finally {
                this.m_semaphore.releaseReadSemaphore();
            }
        }
        return this.m_X509CRL;
    }

    public void setX509CRL(X509CRL x509crl) {
        try {
            try {
                this.m_semaphore.lock();
                this.m_X509CRL = x509crl;
                this.m_status = 0;
            }
            catch (InterruptedException interruptedException) {
                this.m_semaphore.unlock();
            }
        }
        finally {
            this.m_semaphore.unlock();
        }
    }

    public int[] getRetryPolicy() {
        return this.m_RetryPolicy;
    }

    public int getStatus() {
        return this.m_status;
    }

    public void setDownloaded() {
        this.m_status = 0;
    }

    public void setDownloading() {
        this.m_status = 1;
    }

    public String getCrlUrl() {
        return this.m_CrlUrl;
    }

    public void setCrlUrl(String crlUrl) {
        this.m_CrlUrl = crlUrl;
    }

    public String getUserCrlUrl() {
        return this.m_UserCrlUrl;
    }

    public String getCrlFilePath() {
        return this.m_CrlFilePath;
    }

    public String getCaAlias() {
        return this.m_CaAlias;
    }

    public boolean isNotCheckCRL() {
        return this.m_isNotCheckCRL;
    }

    public String getCAFilePath() {
        return this.m_CAFilePath;
    }

    public String getAccountHash() {
        return this.m_AccountHash;
    }
}

