/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.cvm;

import com.itrus.cvm.CRLContext;
import com.itrus.cvm.CRLContextConfInfo;
import com.itrus.util.RegexUtils;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CVMConfigFactory {
    private static Log log = LogFactory.getLog((String)"ITRUS-CVM");

    public Hashtable getCRLContextHashtable(String configFileName) throws ParserConfigurationException, SAXException, IOException, CertificateException, NoSuchProviderException {
        Hashtable<String, CRLContext> hashtable = new Hashtable<String, CRLContext>();
        String configInfo = "\uff08\u914d\u7f6e\u6587\u4ef6\uff1a" + configFileName + "\uff09";
        String error = null;
        String configParent = null;
        Document doc = null;
        File file = new File(configFileName);
        configParent = file.getParent();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        doc = builder.parse(file);
        NodeList nl = doc.getElementsByTagName("CRLContext");
        boolean notCheckCRL = false;
        int i = 0;
        while (i < nl.getLength()) {
            Element element = (Element)nl.item(i);
            String strRetryPolicy = null;
            String crlUrl = null;
            String crlFilePath = null;
            String caFilePath = null;
            String accountHash = null;
            boolean timingDownload = false;
            if (element.getElementsByTagName("CaFileName").getLength() >= 1) {
                caFilePath = String.valueOf(configParent) + System.getProperty("file.separator") + element.getElementsByTagName("CaFileName").item(0).getFirstChild().getNodeValue().trim();
                boolean match = RegexUtils.matchesIgnoreCase(caFilePath, ".*(.cer|.crt|.pem)$");
                if (!match) {
                    error = "<CaFileName>\u5fc5\u987b\u662f\u540e\u7f00\u540d\u4e3a.cer\u6216\u8005.crt\u6216\u8005.pem\u7684\u8bc1\u4e66\u6587\u4ef6\uff01" + configInfo;
                    throw new IOException(error);
                }
            } else {
                error = "<CRLContext>\u5fc5\u987b\u914d\u7f6e<CaFileName>\uff01" + configInfo;
                throw new IOException(error);
            }
            if (element.getElementsByTagName("CrlUrl").getLength() >= 1) {
                crlUrl = element.getElementsByTagName("CrlUrl").item(0).getFirstChild().getNodeValue().trim();
            }
            if (element.getElementsByTagName("CrlFileName").getLength() >= 1) {
                crlFilePath = String.valueOf(configParent) + System.getProperty("file.separator") + element.getElementsByTagName("CrlFileName").item(0).getFirstChild().getNodeValue().trim();
            }
            if (element.getElementsByTagName("NotCheckCRL").getLength() >= 1) {
                String strNotCheckCRL = element.getElementsByTagName("NotCheckCRL").item(0).getFirstChild().getNodeValue();
                boolean bl = notCheckCRL = strNotCheckCRL != null && strNotCheckCRL.equalsIgnoreCase("true");
            }
            if (element.getElementsByTagName("AccountHash").getLength() >= 1) {
                accountHash = element.getElementsByTagName("AccountHash").item(0).getFirstChild().getNodeValue().trim();
            }
            if (element.getElementsByTagName("TimingDownload").getLength() >= 1) {
                String strTimingDownload = element.getElementsByTagName("TimingDownload").item(0).getFirstChild().getNodeValue();
                timingDownload = strTimingDownload != null && strTimingDownload.equalsIgnoreCase("true");
            }
            int[] retryPolicy = null;
            if (element.getElementsByTagName("RetryPolicy").getLength() >= 1 && (strRetryPolicy = element.getElementsByTagName("RetryPolicy").item(0).getFirstChild().getNodeValue().trim()) != null) {
                String[] arrayRetryPolicy = strRetryPolicy.split(",");
                retryPolicy = new int[arrayRetryPolicy.length];
                int j = 0;
                while (j < arrayRetryPolicy.length) {
                    retryPolicy[j] = Integer.parseInt(arrayRetryPolicy[j].trim());
                    ++j;
                }
            }
            CRLContextConfInfo confInfo = new CRLContextConfInfo();
            confInfo.setCAFilePath(caFilePath);
            confInfo.setCRLFilePath(crlFilePath);
            if (crlUrl != null) {
                confInfo.setCRLUrl(crlUrl);
            }
            if (retryPolicy != null) {
                confInfo.setRetryPolicy(retryPolicy);
            }
            confInfo.setNotCheckCRL(notCheckCRL);
            confInfo.setAccountHash(accountHash);
            confInfo.setTimingDownload(timingDownload);
            CRLContext crlContext = new CRLContext(confInfo);
            log.debug((Object)("\u589e\u52a0CA\u652f\u6301[" + crlContext.getCaCert().getSubjectDNString() + "]"));
            hashtable.put(crlContext.getCaCert().getSubjectDNString(), crlContext);
            ++i;
        }
        return hashtable;
    }
}

