/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.security.cert;

import cn.topca.security.sm.SM2PublicKey;
import cn.topca.security.sm.TopSMProvider;
import cn.topca.security.x509.AlgorithmId;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPublicKeySpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x509.RSAPublicKeyStructure;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.bouncycastle.util.encoders.Base64;

public class CertificateUtil {
    private static final Log log;

    static {
        Security.addProvider((Provider)new TopSMProvider());
        log = LogFactory.getLog(CertificateUtil.class);
    }

    public static PublicKey getPublicKey(String base64Cert) {
        Object publicKey = null;
        try {
            ASN1InputStream ain = new ASN1InputStream(Base64.decode((String)base64Cert));
            ASN1Sequence as = ASN1Sequence.getInstance((Object)ain.readObject());
            X509CertificateStructure x509 = X509CertificateStructure.getInstance((Object)as);
            SubjectPublicKeyInfo spki = x509.getSubjectPublicKeyInfo();
            if (spki.getAlgorithmId().getObjectId().getId().equals(AlgorithmId.SM2_oid.toString())) {
                byte[] key = spki.getPublicKeyData().getBytes();
                if (key.length == 65) {
                    byte[] point = new byte[64];
                    System.arraycopy(key, 1, point, 0, 64);
                    publicKey = new SM2PublicKey(point);
                }
            } else {
                ASN1Sequence as1 = ASN1Sequence.getInstance((Object)spki.getPublicKey());
                RSAPublicKeyStructure rsa = new RSAPublicKeyStructure(as1);
                if (rsa != null) {
                    BigInteger n = rsa.getModulus();
                    BigInteger e = rsa.getPublicExponent();
                    RSAPublicKeySpec pubkeyspec = new RSAPublicKeySpec(n, e);
                    publicKey = (RSAPublicKey)KeyFactory.getInstance("RSA").generatePublic(pubkeyspec);
                }
            }
        }
        catch (Exception e) {
            log.warn((Object)("Get RSA Public Key Failed[" + e.getMessage() + "]"), (Throwable)e);
        }
        return publicKey;
    }

    public static PublicKey getPublicKey(ASN1Sequence as) {
        Object publicKey = null;
        try {
            X509CertificateStructure x509 = X509CertificateStructure.getInstance((Object)as);
            SubjectPublicKeyInfo spki = x509.getSubjectPublicKeyInfo();
            if (spki.getAlgorithmId().getObjectId().getId().equals(AlgorithmId.SM2_oid.toString())) {
                byte[] key = spki.getPublicKeyData().getBytes();
                if (key.length == 65) {
                    byte[] point = new byte[64];
                    System.arraycopy(key, 1, point, 0, 64);
                    publicKey = new SM2PublicKey(point);
                } else if (key.length == 64) {
                    publicKey = new SM2PublicKey(key);
                }
            } else {
                ASN1Sequence as1 = ASN1Sequence.getInstance((Object)spki.getPublicKey());
                RSAPublicKeyStructure rsa = new RSAPublicKeyStructure(as1);
                if (rsa != null) {
                    BigInteger n = rsa.getModulus();
                    BigInteger e = rsa.getPublicExponent();
                    RSAPublicKeySpec pubkeyspec = new RSAPublicKeySpec(n, e);
                    publicKey = (RSAPublicKey)KeyFactory.getInstance("RSA").generatePublic(pubkeyspec);
                }
            }
        }
        catch (Exception e) {
            log.warn((Object)("Get RSA Public Key Failed[" + e.getMessage() + "]"), (Throwable)e);
        }
        return publicKey;
    }
}

