/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.security.cert;

import com.itrus.security.cert.X509Certificate;
import com.itrus.security.cert.X509Util;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateParsingException;
import java.util.Date;
import java.util.Iterator;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.bouncycastle.asn1.x509.Time;
import org.bouncycastle.asn1.x509.V3TBSCertificateGenerator;
import org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.bouncycastle.asn1.x509.X509ExtensionsGenerator;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.x509.extension.X509ExtensionUtil;

public class X509CertificateGenerator {
    private V3TBSCertificateGenerator tbsGen = new V3TBSCertificateGenerator();
    private DERObjectIdentifier sigOID;
    private AlgorithmIdentifier sigAlgId;
    private String signatureAlgorithm;
    private X509ExtensionsGenerator extGenerator = new X509ExtensionsGenerator();

    public void reset() {
        this.tbsGen = new V3TBSCertificateGenerator();
        this.extGenerator.reset();
    }

    public void setSerialNumber(BigInteger biginteger) {
        if (biginteger.compareTo(BigInteger.ZERO) <= 0) {
            throw new IllegalArgumentException("serial number must be a positive integer");
        }
        this.tbsGen.setSerialNumber(new DERInteger(biginteger));
    }

    public void setIssuerDN(X500Principal x500principal) {
        try {
            this.tbsGen.setIssuer((X509Name)new X509Principal(x500principal.getEncoded()));
        }
        catch (IOException ioexception) {
            throw new IllegalArgumentException("can't process principal: " + ioexception);
        }
    }

    public void setIssuerDN(X509Name x509name) {
        this.tbsGen.setIssuer(x509name);
    }

    public void setNotBefore(Date date) {
        this.tbsGen.setStartDate(new Time(date));
    }

    public void setNotAfter(Date date) {
        this.tbsGen.setEndDate(new Time(date));
    }

    public void setSubjectDN(X500Principal x500principal) {
        try {
            this.tbsGen.setSubject((X509Name)new X509Principal(x500principal.getEncoded()));
        }
        catch (IOException ioexception) {
            throw new IllegalArgumentException("can't process principal: " + ioexception);
        }
    }

    public void setSubjectDN(X509Name x509name) {
        this.tbsGen.setSubject(x509name);
    }

    public void setPublicKey(PublicKey publickey) throws IllegalArgumentException {
        try {
            this.tbsGen.setSubjectPublicKeyInfo(SubjectPublicKeyInfo.getInstance((Object)new ASN1InputStream(publickey.getEncoded()).readObject()));
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("unable to process key - " + exception.toString());
        }
    }

    public void setSignatureAlgorithm(String s) {
        this.signatureAlgorithm = s;
        try {
            this.sigOID = X509Util.getAlgorithmOID(s);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Unknown signature type requested: " + s);
        }
        this.sigAlgId = X509Util.getSigAlgID(this.sigOID, s);
        this.tbsGen.setSignature(this.sigAlgId);
    }

    static DERBitString booleanToBitString(boolean[] aflag) {
        byte[] abyte0 = new byte[(aflag.length + 7) / 8];
        int i = 0;
        while (i != aflag.length) {
            int n = i / 8;
            abyte0[n] = (byte)(abyte0[n] | (aflag[i] ? (byte)(1 << 7 - i % 8) : (byte)0));
            ++i;
        }
        int j = aflag.length % 8;
        if (j == 0) {
            return new DERBitString(abyte0);
        }
        return new DERBitString(abyte0, 8 - j);
    }

    public void addExtension(String s, boolean flag, DEREncodable derencodable) {
        this.addExtension(new DERObjectIdentifier(s), flag, derencodable);
    }

    public void addExtension(DERObjectIdentifier derobjectidentifier, boolean flag, DEREncodable derencodable) {
        this.extGenerator.addExtension(derobjectidentifier, flag, derencodable);
    }

    public void addExtension(String s, boolean flag, byte[] abyte0) {
        this.addExtension(new DERObjectIdentifier(s), flag, abyte0);
    }

    public void addExtension(DERObjectIdentifier derobjectidentifier, boolean flag, byte[] abyte0) {
        this.extGenerator.addExtension(derobjectidentifier, flag, abyte0);
    }

    public void copyAndAddExtension(String s, boolean flag, X509Certificate x509certificate) throws CertificateParsingException {
        byte[] abyte0 = x509certificate.getExtensionValue(s);
        if (abyte0 == null) {
            throw new CertificateParsingException("extension " + s + " not present");
        }
        try {
            ASN1Object asn1object = X509ExtensionUtil.fromExtensionValue((byte[])abyte0);
            this.addExtension(s, flag, (DEREncodable)asn1object);
        }
        catch (IOException ioexception) {
            throw new CertificateParsingException(ioexception.toString());
        }
    }

    public void copyAndAddExtension(DERObjectIdentifier derobjectidentifier, boolean flag, X509Certificate x509certificate) throws CertificateParsingException {
        this.copyAndAddExtension(derobjectidentifier.getId(), flag, x509certificate);
    }

    public X509Certificate generate(PrivateKey privatekey) throws CertificateEncodingException, IllegalStateException, NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        return this.generate(privatekey, (SecureRandom)null);
    }

    public X509Certificate generate(PrivateKey privatekey, SecureRandom securerandom) throws CertificateEncodingException, IllegalStateException, NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        byte[] abyte0;
        TBSCertificateStructure tbscertificatestructure = this.generateTbsCert();
        try {
            abyte0 = X509Util.calculateSignature(this.sigOID, this.signatureAlgorithm, privatekey, securerandom, (ASN1Encodable)tbscertificatestructure);
        }
        catch (IOException ioexception) {
            throw new CertificateEncodingException("exception encoding TBS cert", ioexception);
        }
        try {
            return this.generateJcaObject(tbscertificatestructure, abyte0);
        }
        catch (CertificateParsingException certificateparsingexception) {
            throw new CertificateEncodingException("exception producing certificate object", certificateparsingexception);
        }
    }

    public X509Certificate generate(PrivateKey privatekey, String s) throws CertificateEncodingException, IllegalStateException, NoSuchProviderException, NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        return this.generate(privatekey, s, null);
    }

    public X509Certificate generate(PrivateKey privatekey, String s, SecureRandom securerandom) throws CertificateEncodingException, IllegalStateException, NoSuchProviderException, NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        byte[] abyte0;
        TBSCertificateStructure tbscertificatestructure = this.generateTbsCert();
        try {
            abyte0 = X509Util.calculateSignature(this.sigOID, this.signatureAlgorithm, s, privatekey, securerandom, (ASN1Encodable)tbscertificatestructure);
        }
        catch (IOException ioexception) {
            throw new CertificateEncodingException("exception encoding TBS cert", ioexception);
        }
        try {
            return this.generateJcaObject(tbscertificatestructure, abyte0);
        }
        catch (CertificateParsingException certificateparsingexception) {
            throw new CertificateEncodingException("exception producing certificate object", certificateparsingexception);
        }
    }

    public TBSCertificateStructure generateTbsCert() {
        if (!this.extGenerator.isEmpty()) {
            this.tbsGen.setExtensions(this.extGenerator.generate());
        }
        return this.tbsGen.generateTBSCertificate();
    }

    public X509Certificate generateJcaObject(TBSCertificateStructure tbscertificatestructure, byte[] abyte0) throws CertificateParsingException {
        ASN1EncodableVector asn1encodablevector = new ASN1EncodableVector();
        asn1encodablevector.add((DEREncodable)tbscertificatestructure);
        asn1encodablevector.add((DEREncodable)this.sigAlgId);
        asn1encodablevector.add((DEREncodable)new DERBitString(abyte0));
        return new X509Certificate(new X509CertificateStructure((ASN1Sequence)new DERSequence(asn1encodablevector)));
    }

    public Iterator getSignatureAlgNames() {
        return X509Util.getAlgNames();
    }
}

