/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.security.pkcs;

import com.itrus.security.cert.X509Util;
import java.security.PublicKey;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509Name;

public class PKCS10Generator {
    public static CertificationRequestInfo buildCertReqInfo(String subject, PublicKey key) throws Exception {
        SubjectPublicKeyInfo pubKeyInfo = null;
        try {
            pubKeyInfo = SubjectPublicKeyInfo.getInstance((Object)new ASN1InputStream(key.getEncoded()).readObject());
        }
        catch (Exception e) {
            AlgorithmIdentifier algKey = new AlgorithmIdentifier(X509Util.getAlgorithmOID(key.getAlgorithm()));
            pubKeyInfo = new SubjectPublicKeyInfo(algKey, key.getEncoded());
        }
        CertificationRequestInfo reqInfo = new CertificationRequestInfo(new X509Name(subject), pubKeyInfo, null);
        return reqInfo;
    }

    public static CertificationRequest buildCSR(CertificationRequestInfo reqInfo, byte[] signData, String signAlgothm) throws Exception {
        AlgorithmIdentifier algSign = new AlgorithmIdentifier(X509Util.getAlgorithmOID(signAlgothm));
        CertificationRequest req = new CertificationRequest(reqInfo, algSign, new DERBitString(signData));
        return req;
    }
}

