/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.security.pkcs;

import cn.topca.security.sm.TopSMProvider;
import com.itrus.security.cert.X509Certificate;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.pkcs.ContentInfo;
import org.bouncycastle.asn1.pkcs.IssuerAndSerialNumber;
import org.bouncycastle.asn1.pkcs.SignedData;
import org.bouncycastle.asn1.pkcs.SignerInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.TBSCertList;
import org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.bouncycastle.jce.X509Principal;

public class PKCS7 {
    private byte[] originalData = null;
    private Collection certs = new ArrayList();
    private Collection crls = new ArrayList();
    private Collection signers = new ArrayList();
    private Collection digestAlg = new ArrayList();

    static {
        Security.addProvider((Provider)new TopSMProvider());
    }

    public PKCS7(byte[] pkcs7) {
        try {
            ASN1InputStream din = new ASN1InputStream(pkcs7);
            DERObject pkcs = din.readObject();
            ContentInfo content = ContentInfo.getInstance((Object)pkcs);
            content.getContentType();
            SignedData data = SignedData.getInstance((Object)content.getContent());
            ASN1Set set1 = data.getDigestAlgorithms();
            int i = 0;
            while (set1 != null && i < set1.size()) {
                AlgorithmIdentifier algId = AlgorithmIdentifier.getInstance((Object)set1.getObjectAt(i));
                this.digestAlg.add(algId);
                ++i;
            }
            ASN1Set set2 = data.getCertificates();
            int i2 = 0;
            while (set2 != null && i2 < set2.size()) {
                X509CertificateStructure x509 = X509CertificateStructure.getInstance((Object)set2.getObjectAt(i2));
                this.certs.add(new X509Certificate(x509));
                ++i2;
            }
            ASN1Set set3 = data.getCRLs();
            int i3 = 0;
            while (set3 != null && i3 < set3.size()) {
                TBSCertList crl = TBSCertList.getInstance((Object)set3.getObjectAt(i3));
                this.crls.add(crl);
                ++i3;
            }
            ASN1Set set4 = data.getSignerInfos();
            int i4 = 0;
            while (set4 != null && i4 < set4.size()) {
                SignerInfo signer = SignerInfo.getInstance((Object)set4.getObjectAt(i4));
                this.signers.add(signer);
                ++i4;
            }
            ContentInfo contentInfo = data.getContentInfo();
            DEREncodable dEREncodable = contentInfo.getContent();
            if (dEREncodable != null) {
                DEROctetString dEROctetString = (DEROctetString)dEREncodable;
                this.originalData = dEROctetString.getOctets();
            }
        }
        catch (Exception e) {
            throw new SecurityException("can't decode PKCS7SignedData object");
        }
    }

    public X509Certificate verify(byte[] data) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        X509Certificate signCert = null;
        for (SignerInfo signerInfo : this.signers) {
            signCert = this.getSignCert(signerInfo);
            if (signCert == null) {
                throw new SecurityException("Can't find signing certificate!");
            }
            String digestAlgorithm = signerInfo.getDigestAlgorithm().getObjectId().getId();
            String digestEncryptionAlgorithm = signerInfo.getDigestEncryptionAlgorithm().getObjectId().getId();
            String signAlgorithmName = this.getSignAlgorithm(digestAlgorithm, digestEncryptionAlgorithm);
            byte[] encryptedDigest = signerInfo.getEncryptedDigest().getOctets();
            Signature signature = Signature.getInstance(signAlgorithmName);
            signature.initVerify(signCert.getPublicKey());
            if (this.originalData != null) {
                signature.update(this.originalData);
            } else if (data != null) {
                signature.update(data);
            } else {
                throw new SecurityException("No original data found!");
            }
            if (signature.verify(encryptedDigest)) continue;
            return null;
        }
        return signCert;
    }

    public X509Certificate getSignCert(SignerInfo signerInfo) {
        X509Certificate signCert = null;
        IssuerAndSerialNumber isAnds = signerInfo.getIssuerAndSerialNumber();
        BigInteger serialNumber = isAnds.getCertificateSerialNumber().getValue();
        X509Principal issuer = new X509Principal(isAnds.getName());
        for (X509Certificate cert : this.certs) {
            if (!cert.getSerialNumber().equals(serialNumber) || !cert.getIssuerDN().equals(issuer)) continue;
            signCert = cert;
            break;
        }
        return signCert;
    }

    private String getSignAlgorithm(String digestAlgorithm, String digestEncryptionAlgorithm) {
        String da = digestAlgorithm;
        String dea = digestEncryptionAlgorithm;
        if (digestAlgorithm.equals("1.2.840.113549.2.5")) {
            da = "MD5";
        } else if (digestAlgorithm.equals("1.2.840.113549.2.2")) {
            da = "MD2";
        } else if (digestAlgorithm.equals("1.3.14.3.2.26")) {
            da = "SHA1";
        } else if (digestAlgorithm.equals("1.2.156.10197.1.401")) {
            da = "SM3";
        } else if (digestAlgorithm.equals("1.2.156.10197.1.401.1")) {
            da = "SM3";
        } else if (digestAlgorithm.equals("1.2.156.10197.1.401.2")) {
            da = "SM3";
        }
        if (digestEncryptionAlgorithm.equals("1.2.840.113549.1.1.1")) {
            dea = "RSA";
        } else if (digestEncryptionAlgorithm.equals("1.2.840.10040.4.1")) {
            dea = "DSA";
        } else if (digestEncryptionAlgorithm.equals("1.2.156.10197.1.301")) {
            dea = "SM2";
        }
        return da + "with" + dea;
    }

    public X509Certificate getSignCert(int i) {
        X509Certificate cert = null;
        Iterator it = this.certs.iterator();
        int cur = 0;
        while (it.hasNext()) {
            cert = (X509Certificate)((Object)it.next());
            if (cur == i) break;
            ++cur;
        }
        return cert;
    }

    public int getSignCertSize() {
        return this.certs.size();
    }

    public SignerInfo getSignerInfo(int i) {
        SignerInfo signer = null;
        Iterator it = this.signers.iterator();
        int cur = 0;
        while (it.hasNext()) {
            signer = (SignerInfo)it.next();
            if (cur == i) break;
            ++cur;
        }
        return signer;
    }

    public int getSignInfoSize() {
        return this.signers.size();
    }

    public byte[] getContent() {
        return this.originalData == null ? null : (byte[])this.originalData.clone();
    }

    public boolean isDetached() {
        return this.originalData == null;
    }
}

