/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.svm;

import cn.topca.security.sm.TopSMProvider;
import com.itrus.cert.X509Certificate;
import com.itrus.cryptorole.CryptoException;
import com.itrus.cryptorole.SignatureVerifyException;
import com.itrus.svm.SignerAndEncryptedDigest;
import com.itrus.util.DERUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateParsingException;
import java.util.ArrayList;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.pkcs.IssuerAndSerialNumber;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.SignedData;
import org.bouncycastle.asn1.pkcs.SignerInfo;
import org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.util.encoders.Base64;

public class SVM
implements PKCSObjectIdentifiers {
    private static final String ID_PKCS7_DATA = "1.2.840.113549.1.7.1";
    private static final String ID_PKCS7_SIGNED_DATA = "1.2.840.113549.1.7.2";
    private static final String ID_MD5 = "1.2.840.113549.2.5";
    private static final String ID_MD2 = "1.2.840.113549.2.2";
    private static final String ID_SHA1 = "1.3.14.3.2.26";
    private static final String ID_RSA = "1.2.840.113549.1.1.1";
    private static final String ID_DSA = "1.2.840.10040.4.1";
    private static final String ID_SM2 = "1.2.156.10197.1.301";
    private static final String ID_SM3 = "1.2.156.10197.1.401";
    private static final String ID_SM3withSM2 = "1.2.156.10197.1.501";

    static {
        Security.addProvider((Provider)new TopSMProvider());
    }

    public static java.security.cert.X509Certificate verifySignature(byte[] toSign, String signedDataStr) throws SignatureVerifyException, CryptoException {
        byte[] pkcs7 = null;
        pkcs7 = !signedDataStr.startsWith("M") ? DERUtils.HexStringToBytes(signedDataStr) : Base64.decode((String)signedDataStr);
        SignerAndEncryptedDigest signerAndEncryptedDigest = SVM.verifyAndParsePkcs7(toSign, pkcs7);
        return signerAndEncryptedDigest.getSigner();
    }

    public static java.security.cert.X509Certificate verifySignature(String toSignStr, String signedDataStr) throws SignatureVerifyException, CryptoException {
        try {
            return SVM.verifySignature(toSignStr.getBytes("iso8859-1"), signedDataStr);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] fetchEncryptedDigest(String toSignStr, String signedDataStr) throws SignatureVerifyException, CryptoException {
        byte[] oriData = toSignStr.getBytes();
        byte[] pkcs7 = null;
        pkcs7 = !signedDataStr.startsWith("M") ? DERUtils.HexStringToBytes(signedDataStr) : Base64.decode((String)signedDataStr);
        SignerAndEncryptedDigest signerAndEncryptedDigest = SVM.verifyAndParsePkcs7(oriData, pkcs7);
        return signerAndEncryptedDigest.getEncryptedDigest();
    }

    private static String getDigestAlgorithm(String digestAlgorithm, String digestEncryptionAlgorithm) {
        String da = digestAlgorithm;
        String dea = digestEncryptionAlgorithm;
        if (digestAlgorithm.equals(ID_MD5)) {
            da = "MD5";
        } else if (digestAlgorithm.equals(ID_MD2)) {
            da = "MD2";
        } else if (digestAlgorithm.equals(ID_SHA1)) {
            da = "SHA1";
        } else if (digestAlgorithm.equals(ID_SM3)) {
            da = "SM3";
        }
        if (digestEncryptionAlgorithm.equals(ID_RSA)) {
            dea = "RSA";
        } else if (digestEncryptionAlgorithm.equals(ID_DSA)) {
            dea = "DSA";
        } else if (digestEncryptionAlgorithm.equals(ID_SM2)) {
            dea = "SM2";
        } else if (digestEncryptionAlgorithm.equals(ID_SM3withSM2)) {
            dea = "SM2";
        }
        return String.valueOf(da) + "with" + dea;
    }

    public static SignerAndEncryptedDigest verifyAndParsePkcs7(byte[] oriData, byte[] pkcs7) throws SignatureVerifyException, CryptoException {
        ASN1Set signerinfos;
        org.bouncycastle.asn1.pkcs.ContentInfo contentInfo;
        DEREncodable dEREncodable;
        DERObject pkcs;
        X509Certificate signCert = null;
        ASN1InputStream din = new ASN1InputStream(pkcs7);
        try {
            pkcs = din.readObject();
        }
        catch (IOException e) {
            throw new SecurityException("can't decode PKCS7SignedData object");
        }
        if (!(pkcs instanceof ASN1Sequence)) {
            throw new SecurityException("Not a valid PKCS#7 object - not a sequence");
        }
        ContentInfo content = ContentInfo.getInstance((Object)pkcs);
        if (!content.getContentType().equals((Object)signedData)) {
            throw new SecurityException("Not a valid PKCS#7 signed-data object - wrong header " + content.getContentType().getId());
        }
        SignedData data = SignedData.getInstance((Object)content.getContent());
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        if (data.getCertificates() != null) {
            Enumeration ec = ASN1Set.getInstance((Object)data.getCertificates()).getObjects();
            while (ec.hasMoreElements()) {
                try {
                    certs.add(new X509Certificate(X509CertificateStructure.getInstance(ec.nextElement())));
                }
                catch (CertificateParsingException e) {
                    throw new CryptoException(e);
                }
            }
        }
        if ((dEREncodable = (contentInfo = data.getContentInfo()).getContent()) != null) {
            DEROctetString dEROctetString = (DEROctetString)dEREncodable;
            oriData = dEROctetString.getOctets();
        }
        if ((signerinfos = data.getSignerInfos()).size() != 1) {
            throw new SecurityException("This PKCS#7 object has multiple SignerInfos - only one is supported at this time");
        }
        SignerInfo signerInfo = SignerInfo.getInstance((Object)signerinfos.getObjectAt(0));
        IssuerAndSerialNumber isAnds = signerInfo.getIssuerAndSerialNumber();
        BigInteger serialNumber = isAnds.getCertificateSerialNumber().getValue();
        X509Principal issuer = new X509Principal(isAnds.getName());
        for (X509Certificate cert : certs) {
            if (!serialNumber.equals(cert.getSerialNumber()) || !issuer.equals((Object)cert.getIssuerDN())) continue;
            signCert = cert;
            break;
        }
        if (signCert == null) {
            throw new SecurityException("Can't find signing certificate with serial " + serialNumber.toString(16));
        }
        String digestAlgorithm = signerInfo.getDigestAlgorithm().getObjectId().getId();
        byte[] encryptedDigest = signerInfo.getEncryptedDigest().getOctets();
        String digestEncryptionAlgorithm = signerInfo.getDigestEncryptionAlgorithm().getObjectId().getId();
        try {
            Signature sig = Signature.getInstance(SVM.getDigestAlgorithm(digestAlgorithm, digestEncryptionAlgorithm));
            sig.initVerify(signCert.getPublicKey());
            if (oriData == null) {
                throw new CryptoException("Unable to get the original data to be signed.");
            }
            sig.update(oriData);
            if (!sig.verify(encryptedDigest)) {
                SignatureVerifyException e = new SignatureVerifyException("Signature verify failed, plaintext may be falsified. Signer is [" + signCert.getSubjectDNString() + "]");
                e.setSigner((java.security.cert.X509Certificate)((Object)signCert));
                throw e;
            }
            SignerAndEncryptedDigest signerAndEncryptedDigest = new SignerAndEncryptedDigest();
            signerAndEncryptedDigest.setSigner(signCert);
            signerAndEncryptedDigest.setEncryptedDigest(encryptedDigest);
            signerAndEncryptedDigest.setOriData(oriData);
            return signerAndEncryptedDigest;
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
        catch (InvalidKeyException e) {
            throw new CryptoException(e);
        }
        catch (SignatureException e) {
            throw new CryptoException(e);
        }
    }
}

