/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.util;

import com.itrus.cert.PKCS10CertificationRequest;
import com.itrus.cert.X509Certificate;
import com.itrus.util.Base64;
import com.itrus.util.CertUtils;
import com.itrus.util.CryptoException;
import com.itrus.util.KeyStoreType;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class KeyStoreUtil {
    private static final HashMap AVAILABLE_TYPES;

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        AVAILABLE_TYPES = new HashMap();
    }

    public static KeyPair getPrivateKey(KeyStore keystore, String alias, char[] password) {
        try {
            Key key = keystore.getKey(alias, password);
            if (key instanceof PrivateKey) {
                Certificate cert = keystore.getCertificate(alias);
                PublicKey publicKey = cert.getPublicKey();
                return new KeyPair(publicKey, (PrivateKey)key);
            }
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
        return null;
    }

    public static String ExportPriv(String alias, File fKeyStore, char[] passPhrase) throws Exception {
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(new FileInputStream(fKeyStore), passPhrase);
        KeyPair kp = KeyStoreUtil.getPrivateKey(ks, alias, passPhrase);
        PrivateKey privKey = kp.getPrivate();
        StringBuffer priv = new StringBuffer();
        priv.append("-----BEGIN RSA PRIVATE KEY-----\n");
        priv.append(new String(Base64.encode(privKey.getEncoded(), true)));
        priv.append("\n-----END RSA PRIVATE KEY-----");
        return priv.toString();
    }

    public static KeyStore createKeyStore(KeyStoreType keyStoreType) throws CryptoException, IOException {
        KeyStore keyStore = null;
        try {
            keyStore = KeyStoreUtil.getKeyStoreImpl(keyStoreType);
            keyStore.load(null, null);
        }
        catch (GeneralSecurityException ex) {
            throw new CryptoException(ex);
        }
        return keyStore;
    }

    public static KeyPair genKeys(int keysize) throws NoSuchAlgorithmException, NoSuchProviderException {
        KeyPairGenerator keygen = KeyPairGenerator.getInstance("RSA", "SunJSSE");
        keygen.initialize(keysize);
        KeyPair rsaKeys = keygen.generateKeyPair();
        return rsaKeys;
    }

    public static String genCertReq(File fKeyStore, File csrFile, char[] password, KeyStoreType keyStoreType) throws CryptoException, FileNotFoundException {
        String csr_str = null;
        KeyStore keyStore = null;
        try {
            keyStore = KeyStoreUtil.getKeyStoreImpl(keyStoreType);
        }
        catch (KeyStoreException ex) {
            throw new CryptoException(ex);
        }
        FileInputStream fis = new FileInputStream(fKeyStore);
        try {
            keyStore.load(fis, password);
            Enumeration<String> enums = keyStore.aliases();
            java.security.cert.X509Certificate c = null;
            while (enums.hasMoreElements()) {
                String alias = enums.nextElement().toString();
                if (!keyStore.isKeyEntry(alias)) continue;
                c = (java.security.cert.X509Certificate)keyStore.getCertificate(alias);
                X509Certificate cc = X509Certificate.getInstance(c);
                PrivateKey priv = (PrivateKey)keyStore.getKey(alias, password);
                PublicKey pub = c.getPublicKey();
                PKCS10CertificationRequest csr = new PKCS10CertificationRequest("SHA1WithRSA", cc.getSubjectX500Principal(), pub, null, priv, "BC");
                byte[] buf = csr.getEncoded();
                FileOutputStream os = new FileOutputStream(csrFile);
                OutputStreamWriter wr = new OutputStreamWriter(os);
                csr_str = Base64.encode(buf);
                wr.write("-----BEGIN NEW CERTIFICATE REQUEST-----\n");
                wr.write(csr_str);
                wr.write("\n-----END NEW CERTIFICATE REQUEST-----\n");
                wr.flush();
                break;
            }
            if (csr_str != null) {
                String string = csr_str;
                return string;
            }
        }
        catch (GeneralSecurityException ex) {
            throw new CryptoException(ex);
        }
        catch (FileNotFoundException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw new CryptoException(ex);
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException iOException) {}
        }
        return csr_str;
    }

    public static KeyStore loadKeyStore(File fKeyStore, char[] cPassword, KeyStoreType keyStoreType) throws CryptoException, FileNotFoundException {
        KeyStore keyStore = null;
        try {
            keyStore = KeyStoreUtil.getKeyStoreImpl(keyStoreType);
        }
        catch (KeyStoreException ex) {
            throw new CryptoException(ex);
        }
        FileInputStream fis = new FileInputStream(fKeyStore);
        try {
            try {
                keyStore.load(fis, cPassword);
            }
            catch (GeneralSecurityException ex) {
                throw new CryptoException(ex);
            }
            catch (FileNotFoundException ex) {
                throw ex;
            }
            catch (IOException ex) {
                throw new CryptoException(ex);
            }
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException iOException) {}
        }
        return keyStore;
    }

    public static KeyStore loadKeyStore(String sPkcs11Provider, char[] cPassword) throws CryptoException {
        KeyStore keyStore = null;
        try {
            if (Security.getProvider(sPkcs11Provider) == null) {
                throw new CryptoException(new String("Provider not found: " + sPkcs11Provider));
            }
            keyStore = KeyStore.getInstance(KeyStoreType.PKCS11.toString(), sPkcs11Provider);
        }
        catch (GeneralSecurityException ex) {
            throw new CryptoException(ex);
        }
        try {
            keyStore.load(null, cPassword);
        }
        catch (Exception ex) {
            throw new CryptoException(ex);
        }
        return keyStore;
    }

    public static KeyStore saveKeyStore(KeyStore keyStore, File fKeyStoreFile, char[] cPassword) throws CryptoException, IOException {
        FileOutputStream fos = new FileOutputStream(fKeyStoreFile);
        try {
            try {
                keyStore.store(fos, cPassword);
            }
            catch (IOException ex) {
                throw new CryptoException(ex);
            }
            catch (GeneralSecurityException ex) {
                throw new CryptoException(ex);
            }
        }
        finally {
            fos.close();
        }
        if (KeyStoreType.GKR.equals(KeyStoreType.getInstance(keyStore.getType()))) {
            keyStore = KeyStoreUtil.loadKeyStore(fKeyStoreFile, cPassword, KeyStoreType.GKR);
        }
        return keyStore;
    }

    public static SubjectKeyIdentifier createSubjectKeyId(PublicKey pubKey) {
        try {
            ByteArrayInputStream bIn = new ByteArrayInputStream(pubKey.getEncoded());
            SubjectPublicKeyInfo info = new SubjectPublicKeyInfo((ASN1Sequence)new ASN1InputStream((InputStream)bIn).readObject());
            return new SubjectKeyIdentifier(info);
        }
        catch (Exception e) {
            throw new RuntimeException("error creating key");
        }
    }

    private static KeyStore getKeyStoreImpl(KeyStoreType keyStoreType) throws KeyStoreException {
        KeyStore keyStore = null;
        if (keyStoreType == KeyStoreType.PKCS12) {
            try {
                keyStore = KeyStore.getInstance(keyStoreType.toString(), "BC");
            }
            catch (NoSuchProviderException noSuchProviderException) {
                // empty catch block
            }
        }
        if (keyStore == null) {
            try {
                keyStore = KeyStore.getInstance(keyStoreType.toString());
            }
            catch (KeyStoreException e) {
                AVAILABLE_TYPES.put(keyStoreType, Boolean.FALSE);
                throw e;
            }
        }
        AVAILABLE_TYPES.put(keyStoreType, Boolean.TRUE);
        return keyStore;
    }

    public static Certificate[] getCertChain(KeyStore keyStore, String privateKeyAlias) throws KeyStoreException {
        Certificate[] certchain = keyStore.getCertificateChain(privateKeyAlias);
        if (certchain.length < 1) {
            return certchain;
        }
        if (certchain.length > 0) {
            return certchain;
        }
        ArrayList<Certificate> array = new ArrayList<Certificate>();
        int i = 0;
        while (i < certchain.length) {
            array.add(certchain[i]);
            ++i;
        }
        boolean stop = false;
        while (!stop) {
            java.security.cert.X509Certificate cert = (java.security.cert.X509Certificate)array.get(array.size() - 1);
            String ialias = CertUtils.getPartFromDN(CertUtils.getIssuerDN(cert), "CN");
            Certificate[] chain1 = keyStore.getCertificateChain(ialias);
            if (chain1 == null) {
                stop = true;
                continue;
            }
            if (chain1.length == 0) {
                stop = true;
            }
            int j = 0;
            while (j < chain1.length) {
                array.add(chain1[j]);
                if (CertUtils.isSelfSigned((java.security.cert.X509Certificate)chain1[j])) {
                    stop = true;
                }
                ++j;
            }
        }
        Certificate[] ret = new Certificate[array.size()];
        int i2 = 0;
        while (i2 < ret.length) {
            ret[i2] = (java.security.cert.X509Certificate)array.get(i2);
            ++i2;
        }
        return ret;
    }

    public static boolean isAvailable(KeyStoreType keyStoreType) {
        Boolean available = (Boolean)AVAILABLE_TYPES.get(keyStoreType);
        if (available != null) {
            return available;
        }
        try {
            KeyStoreUtil.getKeyStoreImpl(keyStoreType);
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
        return (Boolean)AVAILABLE_TYPES.get(keyStoreType);
    }

    public static KeyStoreType[] getAvailableTypes() {
        KeyStoreType[] known = KeyStoreType.getKnownTypes();
        ArrayList<KeyStoreType> available = new ArrayList<KeyStoreType>();
        int i = 0;
        int len = known.length;
        while (i < len) {
            if (KeyStoreUtil.isAvailable(known[i])) {
                available.add(known[i]);
            }
            ++i;
        }
        return available.toArray(new KeyStoreType[available.size()]);
    }

    public static boolean isWindowsKeyStore(String storetype) {
        return storetype.equalsIgnoreCase("Windows-MY") || storetype.equalsIgnoreCase("Windows-ROOT");
    }

    public static String niceStoreTypeName(String storetype) {
        if (storetype.equalsIgnoreCase("Windows-MY")) {
            return "Windows-MY";
        }
        if (storetype.equalsIgnoreCase("Windows-ROOT")) {
            return "Windows-ROOT";
        }
        return storetype.toUpperCase();
    }

    public static void JKSToPKCS12(String keyStoreFileName, char[] storePass, String keyEntryAlias, char[] keyEntryPass, String p12FileName, char[] p12Password) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException {
        KeyStore inputKeyStore = KeyStore.getInstance("JKS");
        FileInputStream fis = new FileInputStream(keyStoreFileName);
        inputKeyStore.load(fis, storePass);
        fis.close();
        KeyStore outputKeyStore = KeyStore.getInstance("PKCS12");
        outputKeyStore.load(null, p12Password);
        Enumeration<String> enums = inputKeyStore.aliases();
        while (enums.hasMoreElements()) {
            String alias = enums.nextElement();
            if (!inputKeyStore.isKeyEntry(alias) || !alias.equals(keyEntryAlias)) continue;
            Key key = inputKeyStore.getKey(alias, keyEntryPass);
            Certificate[] certChain = inputKeyStore.getCertificateChain(alias);
            outputKeyStore.setKeyEntry(keyEntryAlias, key, p12Password, certChain);
        }
        FileOutputStream out = new FileOutputStream(p12FileName);
        outputKeyStore.store(out, p12Password);
        out.close();
    }
}

