/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;

public class SerialNumberUtils {
    public static String getSerialNumber() {
        SecureRandom random = new SecureRandom();
        byte[] serialnumber = new byte[16];
        random.nextBytes(serialnumber);
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < serialnumber.length) {
            String hex = Integer.toHexString(serialnumber[i] & 0xFF);
            if (hex.length() == 1) {
                hex = String.valueOf('0') + hex;
            }
            sb.append(hex);
            ++i;
        }
        return sb.toString().toUpperCase();
    }

    public static String getSerialNumber(X509Certificate x509) {
        String serial = x509.getSerialNumber().toString(16).toUpperCase();
        if (x509.getSerialNumber().signum() != 1) {
            throw new RuntimeException("Certificate SerialNumber may not be a negative number.But it happened.");
        }
        if (serial.length() % 2 != 0) {
            serial = "0" + serial;
        }
        return serial;
    }

    public static String getHashStr(String strHash, String alg) {
        byte[] b2 = strHash.getBytes();
        return SerialNumberUtils.getHashStr(b2, alg);
    }

    public static String getHashStr(byte[] strHash, String alg) {
        StringBuffer sb = new StringBuffer();
        try {
            MessageDigest md = MessageDigest.getInstance(alg);
            byte[] b = md.digest(strHash);
            int i = 0;
            while (i < b.length) {
                sb.append(Integer.toHexString(b[i] & 0xFF));
                ++i;
            }
        }
        catch (NoSuchAlgorithmException e) {
            System.err.println(e.getMessage());
        }
        return sb.toString().toUpperCase();
    }
}

