/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dsi.dataengine.impl;

import com.vertica.dsi.dataengine.impl.DSIArray;
import com.vertica.dsi.dataengine.interfaces.IArray;
import com.vertica.dsi.dataengine.interfaces.IColumn;
import com.vertica.dsi.dataengine.utilities.ColumnMetadata;
import com.vertica.dsi.dataengine.utilities.TypeMetadata;
import com.vertica.dsi.dataengine.utilities.TypeUtilities;
import com.vertica.support.exceptions.ErrorException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class DSISimpleArray
extends DSIArray {
    protected Object m_array;
    protected int m_length;
    private IColumn m_arrayMetadata;
    private IColumn m_nestedMetadata;

    @Deprecated
    public DSISimpleArray(Object array, IColumn arrayMetadata, IColumn nestedMetadata) {
        this(array, DSISimpleArray.createNestedMetadata(arrayMetadata, nestedMetadata));
    }

    public DSISimpleArray(Object array, IColumn arrayMetadata) throws ClassCastException {
        this.CreateSimpleArray(array, arrayMetadata);
    }

    protected void CreateSimpleArray(Object array, IColumn arrayMetadata) {
        if (!array.getClass().isArray()) {
            throw new ClassCastException("Not an array: " + array.getClass());
        }
        short type = arrayMetadata.getTypeMetadata().getType();
        if (type != 2003) {
            throw new ClassCastException("ArrayMetadata mismatch expected 2003 received " + type);
        }
        this.m_arrayMetadata = arrayMetadata;
        this.m_array = array;
        this.m_length = Array.getLength(array);
        this.m_nestedMetadata = arrayMetadata.getTypeMetadata().getNestedColumnList().get(0);
        int nesting = 0;
        TypeMetadata nestedMetadata = this.m_nestedMetadata.getTypeMetadata();
        short nestedType = nestedMetadata.getType();
        while (nestedType == 2003) {
            ++nesting;
            this.m_nestedMetadata = nestedMetadata.getNestedColumnList().get(0);
            nestedMetadata = this.m_nestedMetadata.getTypeMetadata();
            nestedType = nestedMetadata.getType();
        }
        boolean isValid = this.verifyArray(array, nesting, nestedType);
        if (!isValid) {
            throw new ClassCastException("Array is not valid");
        }
    }

    protected boolean verifyArray(Object array, int level, int type) {
        if (array == null) {
            return true;
        }
        int len = Array.getLength(array);
        boolean isValid = true;
        if (level > 0) {
            for (int i = 0; i < len && (isValid = this.verifyArray(Array.get(array, i), level - 1, type)); ++i) {
            }
        } else {
            for (int i = 0; i < len; ++i) {
                Object temp = Array.get(array, i);
                if (temp != null) {
                    isValid = TypeUtilities.verifySQLTypeMapping(type, temp.getClass());
                }
                if (isValid) {
                    continue;
                }
                break;
            }
        }
        return isValid;
    }

    @Override
    public Object createArray(long offset, int count) throws ErrorException {
        if (0L > offset) {
            throw new IndexOutOfBoundsException(String.valueOf(offset));
        }
        int length = this.m_length;
        if (offset >= (long)length) {
            if (this.isMultidimensional()) {
                return new DSISimpleArray[0];
            }
            return Array.newInstance(this.m_array.getClass().getComponentType(), 0);
        }
        int offsetAsInt = (int)offset;
        int copyLength = length - offsetAsInt;
        if (-1L != (long)count && count < copyLength) {
            copyLength = count;
        }
        Object srcArray = this.m_array;
        if (this.isMultidimensional()) {
            DSISimpleArray[] arrArray = new DSISimpleArray[copyLength];
            IColumn arrayColumn = this.getArrayColumn().getTypeMetadata().getNestedColumnList().get(0);
            for (int i = 0; i < copyLength; ++i) {
                Object arr = Array.get(srcArray, offsetAsInt + i);
                arrArray[i] = new DSISimpleArray(arr, arrayColumn);
            }
            return arrArray;
        }
        Class<?> componentType = srcArray.getClass().getComponentType();
        Object dstArray = Array.newInstance(componentType, copyLength);
        System.arraycopy(srcArray, offsetAsInt, dstArray, 0, copyLength);
        return dstArray;
    }

    @Override
    public IColumn getBaseColumn() {
        return this.getArrayColumn().getTypeMetadata().getNestedColumnList().get(0);
    }

    @Override
    protected Iterator<?> createIterator(long offset, int count) {
        int length = this.m_length;
        if (offset >= (long)length) {
            return Collections.emptyList().iterator();
        }
        int offsetAsInt = (int)offset;
        int itrLen = length - offsetAsInt;
        if (-1L != (long)count && count < itrLen) {
            itrLen = count;
        }
        return new DSISimpleArrayIterator(this.m_array, offsetAsInt, itrLen);
    }

    protected IColumn getArrayColumn() {
        return this.m_arrayMetadata;
    }

    protected IColumn getNestedColumn() {
        return this.m_nestedMetadata;
    }

    protected boolean isMultidimensional() {
        short type = this.m_arrayMetadata.getTypeMetadata().getNestedColumnList().get(0).getTypeMetadata().getType();
        return type == 2003;
    }

    @Override
    public String getStringRepresentation() {
        if (!this.isMultidimensional()) {
            StringBuilder text = new StringBuilder();
            String separator = ", ";
            for (int index = 0; index < this.m_length; ++index) {
                Object element = Array.get(this.m_array, index);
                if (element != null) {
                    text.append(element.toString());
                } else {
                    text.append("null");
                }
                if (index == this.m_length - 1) {
                    separator = "";
                }
                text.append(separator);
            }
            return text.toString();
        }
        return this.toString();
    }

    private static IColumn createNestedMetadata(IColumn arrayMetadata, IColumn nestedMetadata) {
        ColumnMetadata result = ColumnMetadata.copyOf(arrayMetadata);
        ArrayList<IColumn> nestedMetaList = new ArrayList<IColumn>(1);
        nestedMetaList.add(nestedMetadata);
        result.getTypeMetadata().setNestedColumnList(nestedMetaList);
        return result;
    }

    protected final class DSISimpleArrayIterator
    implements Iterator<Object> {
        private int m_offset;
        private int m_count;
        private Object m_data;
        private boolean m_isNested;

        public DSISimpleArrayIterator(Object data, int offset, int count) {
            this.m_data = data;
            this.m_offset = offset;
            this.m_count = count;
            this.m_isNested = DSISimpleArray.this.isMultidimensional();
        }

        @Override
        public boolean hasNext() {
            return 0 < this.m_count;
        }

        @Override
        public Object next() {
            if (0 >= this.m_count) {
                throw new NoSuchElementException();
            }
            --this.m_count;
            Object obj = Array.get(this.m_data, this.m_offset++);
            assert (!(obj instanceof IArray)) : "IArray provided.";
            assert (!(obj instanceof java.sql.Array)) : "java.sql.Array provided.";
            if (!this.m_isNested) {
                return obj;
            }
            return new DSISimpleArray(obj, DSISimpleArray.this.getArrayColumn().getTypeMetadata().getNestedColumnList().get(0));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove()");
        }
    }
}

