/*
 * Decompiled with CFR 0.152.
 */
package com.weaver.esb.spi;

import com.weaver.esb.spi.EsbService;
import com.weaver.esb.spi.RequestConfig;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EsbManager {
    private static Logger log = LoggerFactory.getLogger(EsbManager.class);

    public static EsbService getService(String protocol, RequestConfig requestConfig) {
        ServiceLoader<EsbService> loaders = ServiceLoader.load(EsbService.class);
        for (EsbService service : loaders) {
            try {
                log.info("find service protocol:" + service.getProtocol());
                if (protocol != null && !protocol.isEmpty() && !service.getProtocol().equalsIgnoreCase(protocol)) continue;
                log.info("service init");
                service.init(requestConfig);
                log.info("return service protocol:" + service.getProtocol());
                return service;
            }
            catch (Exception e) {
                log.error(e.getMessage());
                e.printStackTrace();
            }
        }
        log.error("not find service protocol:" + protocol);
        return null;
    }

    public static EsbService getService(RequestConfig requestConfig) {
        return EsbManager.getService(null, requestConfig);
    }
}

