/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.flow.instanceId;

import cn.hutool.core.collection.CollUtil;
import com.yomahub.liteflow.flow.FlowBus;
import com.yomahub.liteflow.flow.element.Chain;
import com.yomahub.liteflow.flow.element.Condition;
import com.yomahub.liteflow.flow.element.Node;
import com.yomahub.liteflow.flow.entity.InstanceInfoDto;
import com.yomahub.liteflow.flow.instanceId.NodeInstanceIdManageSpi;
import com.yomahub.liteflow.flow.instanceId.NodeInstanceIdManageSpiHolder;
import com.yomahub.liteflow.util.JsonUtil;
import com.yomahub.liteflow.util.SerialsUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public abstract class BaseNodeInstanceIdManageSpi
implements NodeInstanceIdManageSpi {
    @Override
    public Node getNodeByIdAndInstanceId(String chainId, String instanceId) {
        if (StringUtils.isBlank((String)chainId) || StringUtils.isBlank((String)instanceId)) {
            return null;
        }
        Chain chain = FlowBus.getChain(chainId);
        if (chain == null) {
            return null;
        }
        List<Condition> conditionList = chain.getConditionList();
        return this.getNodeFromConditions(conditionList, instanceId);
    }

    @Override
    public Node getNodeByIdAndIndex(String chainId, String nodeId, Integer index) {
        if (StringUtils.isBlank((String)chainId) || index == null) {
            return null;
        }
        Chain chain = FlowBus.getChain(chainId);
        if (chain == null) {
            return null;
        }
        List<Condition> conditionList = chain.getConditionList();
        return this.getNodeFromConditions(conditionList, nodeId, index);
    }

    @Override
    public List<String> getNodeInstanceIds(String chainId, String nodeId) {
        if (StringUtils.isBlank((String)chainId) || StringUtils.isBlank((String)nodeId)) {
            return Collections.emptyList();
        }
        List<String> instanceIdFile = this.readInstanceIdFile(chainId);
        ArrayList<String> instanceIds = new ArrayList<String>();
        for (int i = 1; i < instanceIdFile.size(); ++i) {
            List<InstanceInfoDto> instanceInfos = JsonUtil.parseList(instanceIdFile.get(i), InstanceInfoDto.class);
            for (InstanceInfoDto dto : instanceInfos) {
                if (!Objects.equals(dto.getNodeId(), nodeId)) continue;
                instanceIds.add(dto.getInstanceId());
            }
        }
        return instanceIds;
    }

    private Node getNodeFromConditions(List<Condition> conditionList, String instanceId) {
        if (CollUtil.isEmpty(conditionList)) {
            return null;
        }
        for (Condition condition : conditionList) {
            List<Node> allNodeInCondition = condition.getAllNodeInCondition();
            for (Node node : allNodeInCondition) {
                if (!Objects.equals(node.getNodeInstanceId(), instanceId)) continue;
                return node;
            }
        }
        return null;
    }

    private Node getNodeFromConditions(List<Condition> conditionList, String nodeId, Integer index) {
        if (CollUtil.isEmpty(conditionList)) {
            return null;
        }
        HashMap<String, Integer> idCntMap = new HashMap<String, Integer>();
        for (Condition condition : conditionList) {
            List<Node> allNodeInCondition = condition.getAllNodeInCondition();
            for (Node node : allNodeInCondition) {
                idCntMap.put(node.getId(), idCntMap.getOrDefault(node.getId(), -1) + 1);
                if (!Objects.equals(node.getId(), nodeId) || !Objects.equals(idCntMap.get(node.getId()), index)) continue;
                return node;
            }
        }
        return null;
    }

    @Override
    public int getNodeLocationById(String chainId, String instanceId) {
        if (StringUtils.isBlank((String)chainId) || StringUtils.isBlank((String)instanceId)) {
            return -1;
        }
        List<String> instanceIdFile = this.readInstanceIdFile(chainId);
        for (int i = 1; i < instanceIdFile.size(); ++i) {
            List<InstanceInfoDto> instanceInfos = JsonUtil.parseList(instanceIdFile.get(i), InstanceInfoDto.class);
            for (InstanceInfoDto dto : instanceInfos) {
                if (!Objects.equals(dto.getInstanceId(), instanceId)) continue;
                return dto.getIndex();
            }
        }
        return -1;
    }

    @Override
    public void setNodesInstanceId(Condition condition, Chain chain) {
        NodeInstanceIdManageSpi nodeInstanceIdManageSpi = NodeInstanceIdManageSpiHolder.getInstance().getNodeInstanceIdManageSpi();
        String elMd5 = chain.getElMd5();
        String chainId = chain.getChainId();
        List<String> instanceIdFile = nodeInstanceIdManageSpi.readInstanceIdFile(chainId);
        if (CollUtil.isEmpty(instanceIdFile) || !instanceIdFile.get(0).equals(elMd5)) {
            nodeInstanceIdManageSpi.writeInstanceIdFile(this.writeNodeInstanceId(condition, chainId), elMd5, chainId);
        } else {
            List<InstanceInfoDto> instanceInfos = new ArrayList<InstanceInfoDto>();
            for (int i = 1; i < instanceIdFile.size(); ++i) {
                instanceInfos = JsonUtil.parseList(instanceIdFile.get(i), InstanceInfoDto.class);
            }
            ArrayList<InstanceInfoDto> finalInstanceInfos = instanceInfos;
            this.setInstanceIdFromFile(finalInstanceInfos, chainId, condition.getAllNodeInCondition());
        }
    }

    private void setInstanceIdFromFile(List<InstanceInfoDto> finalInstanceInfos, String chainId, List<Node> nodeList) {
        if (CollUtil.isEmpty(nodeList)) {
            return;
        }
        HashMap idCntMap = new HashMap();
        nodeList.forEach(node -> {
            idCntMap.put(node.getId(), idCntMap.getOrDefault(node.getId(), -1) + 1);
            for (InstanceInfoDto dto : finalInstanceInfos) {
                if (!Objects.equals(dto.getNodeId(), node.getId()) || !Objects.equals(dto.getChainId(), chainId) || !Objects.equals(dto.getIndex(), idCntMap.get(node.getId()))) continue;
                node.setNodeInstanceId(dto.getInstanceId());
                break;
            }
        });
    }

    private List<InstanceInfoDto> writeNodeInstanceId(Condition condition, String chainId) {
        ArrayList<InstanceInfoDto> instanceInfos = new ArrayList<InstanceInfoDto>();
        this.addInstanceIdFromExecutableGroup(instanceInfos, condition.getAllNodeInCondition(), chainId);
        return instanceInfos;
    }

    private void addInstanceIdFromExecutableGroup(List<InstanceInfoDto> instanceInfos, List<Node> nodeList, String chainId) {
        if (CollUtil.isEmpty(nodeList)) {
            return;
        }
        HashMap idCntMap = new HashMap();
        nodeList.forEach(node -> {
            InstanceInfoDto instanceInfoDto = new InstanceInfoDto();
            instanceInfoDto.setChainId(chainId);
            instanceInfoDto.setNodeId(node.getId());
            String shortUUID = SerialsUtil.generateShortUUID();
            idCntMap.put(node.getId(), idCntMap.getOrDefault(node.getId(), -1) + 1);
            String instanceId = node.getId() + "_" + shortUUID + "_" + idCntMap.get(node.getId());
            node.setNodeInstanceId(instanceId);
            instanceInfoDto.setInstanceId(instanceId);
            instanceInfoDto.setIndex((Integer)idCntMap.get(node.getId()));
            instanceInfos.add(instanceInfoDto);
        });
    }
}

