package com.yonyou.uap.tenant.service.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

import com.yonyou.uap.tenant.entity.PasswordLevel;
import com.yonyou.uap.tenant.entity.UserExstatus;

import uap.web.core.ContextHolder;

public class PasswordPolicyUtils {
	
	public JdbcTemplate getJdbcTemplateDao(){
		return (JdbcTemplate) ContextHolder.getContext().getBean("jdbcTemplateDao");
	}
	
	public Map<String, Object> getUserStatus(String userId) {
		HashMap<String, Object> map = new HashMap<String, Object>();
		HashSet<Integer> set = new HashSet<Integer>();
		String userExSql = " select * from pub_user_exstatus where user_id =? and exstatuscode =? ";
		
		List<UserExstatus> list = getJdbcTemplateDao().query(userExSql, new RowMapper<UserExstatus>() {
			@Override
			public UserExstatus mapRow(ResultSet rs, int rowNum) throws SQLException {
				Timestamp extimeTs = rs.getTimestamp("extime");
				UserExstatus vo = new UserExstatus(rs.getInt("exstatuscode"), new Date(extimeTs.getTime()) , rs.getString("tenant_id"), rs.getString("user_id"), rs.getString("userex_id"));
				return vo;
			}
		}, userId,2);

		UserExstatus status;
		for (Iterator<UserExstatus> i$ = list.iterator(); i$.hasNext(); set.add(Integer.valueOf(status.getExstatuscode()))) {
			status = (UserExstatus) i$.next();
			if (status.getExstatuscode() == 2) {
				map.put("extime", status.getExtime());
			}
		}

		map.put("statusSet", set);
		return map;
	}

	public PasswordLevel getPasswordLevel(String passwordPolicy) {
		PasswordLevel pwdLevel = null;
		if (StringUtils.isBlank(passwordPolicy)) {
			pwdLevel = this.getPasswordLevelById("5c5865ce-cf83-4b0d-bc7d-5fae9da95701");
		} else {
			pwdLevel = this.getPasswordLevelById(passwordPolicy);
		}
		return pwdLevel;
	}

	private PasswordLevel getPasswordLevelById(String passwordPolicy) {
		String selectSql = " select * from pub_passwordlevel where pwdlevel_id =? ";
		List<PasswordLevel> list = getJdbcTemplateDao().query(selectSql, new RowMapper<PasswordLevel>() {
			@Override
			public PasswordLevel mapRow(ResultSet rs, int rowNum) throws SQLException {
				PasswordLevel vo = new PasswordLevel(rs.getString("pwdlevel_id"), rs.getInt("alertdays"), rs.getString("code"), 
						rs.getShort("errorloginthreshold"), rs.getString("isautolock"), rs.getString("isforceupdate"), 
						rs.getInt("mininumlength"), rs.getString("name"), rs.getString("pwdcomplexity_id"), 
						rs.getInt("remembercount"), rs.getDouble("similaritydegree"), rs.getDate("starttime"), rs.getInt("unlocktime"), rs.getInt("validatedays"));
				return vo;
			}
		}, passwordPolicy);
		
		if(list != null && list.size() > 0) {
			return list.get(0);
		}
		return null;
	}

	public boolean isLockByAdmin(Set<Integer> statusSet) {
		return statusSet.contains(Integer.valueOf(1));
	}

	public boolean isLockBySelf(Set<Integer> statusSet) {
		return statusSet.contains(Integer.valueOf(2));
	}

	public boolean getUserIsLockStatus(Date exTime, PasswordLevel pwdLevel, String userId) {
		int limitLockTime = pwdLevel.getUnlocktime();
		boolean returnValue = false;
		DateTime lastLockTime = new DateTime(exTime);
		DateTime currentTime = new DateTime(System.currentTimeMillis());
		long pastTime = (currentTime.getMillis() - lastLockTime.getMillis()) / 1000L / 60L / 60L;
		if (limitLockTime != -1 && pastTime >= (long) limitLockTime) {
			this.delUserExByStatus(userId, 2);
			returnValue = true;
		}
		return returnValue;
	}

	private void delUserExByStatus(String userId, int status) {
		String deleteSql = "delete from pub_user_exstatus where user_id =? and exstatuscode =?";
		Object args[] = new Object[]{userId,status};  
		getJdbcTemplateDao().update(deleteSql, args);
	}

	public boolean isUserInitOrResetExStatus(Set<Integer> statusSet) {
		return statusSet.contains(Integer.valueOf(4)) || statusSet.contains(Integer.valueOf(3));
	}

	public boolean isUserPwdDisabled(String pwdstarttime, PasswordLevel pwdLevel) throws ParseException {
		boolean isUserPwdDisabled = false;
		if (StringUtils.isBlank(pwdstarttime)) {
			return false;
		} else {
			Integer validateDays = Integer.valueOf(pwdLevel.getValidatedays());
			if (validateDays != null && validateDays.intValue() != 0) {
				SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
				Date startdate = formatter.parse(pwdstarttime);
				Date currDate = new Date();
				long passMillis = currDate.getTime() - startdate.getTime();
				int differDay = (int) (passMillis / 1000L / 60L / 60L / 24L);
				if (differDay > validateDays.intValue()) {
					isUserPwdDisabled = true;
				}

				return isUserPwdDisabled;
			} else {
				return false;
			}
		}
	}

	public String getValidateTip(String pwdstarttime, PasswordLevel pwdLevel) throws ParseException {
		if (StringUtils.isBlank(pwdstarttime)) {
			return null;
		} else if (pwdLevel == null) {
			return null;
		} else {
			Integer alertDays = Integer.valueOf(pwdLevel.getAlertdays());
			if (alertDays != null && alertDays.intValue() != 0) {
				Integer validateDays = Integer.valueOf(pwdLevel.getValidatedays());
				if (validateDays != null && validateDays.intValue() != 0) {
					String sTip = null;
					SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
					Date startdate = formatter.parse(pwdstarttime);
					if (startdate == null) {
						return sTip;
					} else {
						int instant = validateDays.intValue() - alertDays.intValue();
						GregorianCalendar cal = new GregorianCalendar();
						cal.setTime(startdate);
						cal.add(6, instant);
						Date tipDate = cal.getTime();
						Date currDate = new Date();
						long passMillis = currDate.getTime() - tipDate.getTime();
						int passdays = (int) (passMillis / 1000L / 60L / 60L / 24L);
						if (passdays >= 0 && passdays < alertDays.intValue()) {
							sTip = "密码还有" + Integer.toString(alertDays.intValue() - passdays) + "天失效";
						}

						return sTip;
					}
				} else {
					return null;
				}
			} else {
				return null;
			}
		}
	}

	public boolean isLock(PasswordLevel pwdLevel) {
		return pwdLevel.getUnlocktime() != 0;
	}

	public boolean isExceedErrorPasswordCount(PasswordLevel pwdLevel, int count) {
		return count > pwdLevel.getErrorloginthreshold();
	}

	public void lockUser(String userId) {
		String deleteSql = "delete from pub_user_exstatus where user_id =? and exstatuscode =2";
		Object args[] = new Object[]{userId};  
		getJdbcTemplateDao().update(deleteSql, args);

		UserExstatus exstatus = new UserExstatus();
		exstatus.setExstatuscode(2);
		exstatus.setUserId(userId);
		exstatus.setExtime(new Date());
		this.addUserExstatus(exstatus);
	}

	private void addUserExstatus(UserExstatus userExstatus) {
		if (userExstatus.getUserexId() == null || "".equalsIgnoreCase(userExstatus.getUserexId())) {
			userExstatus.setUserexId(UUID.randomUUID().toString());
		}
		String insertSql = "insert into pub_user_exstatus(userex_id,tenant_id,user_id,exstatuscode,extime) values(?,?,?,?,?) " ;
		Object args[] = new Object[]{userExstatus.getUserexId(),"",userExstatus.getUserId(),userExstatus.getExstatuscode(),userExstatus.getExtime()};  
		getJdbcTemplateDao().update(insertSql, args);
	}
	
}
